<!DOCTYPE html>
<html lang="es" style="scroll-behavior: smooth;">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Administración</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body class="flex h-screen bg-gray-100">

    <div id="panel-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden"></div>

    <aside id="sidebar" class="fixed top-0 left-0 h-full w-full lg:w-64 z-40 transform -translate-x-full lg:relative lg:translate-x-0 transition-transform duration-300" style="background-color: var(--brand-dark-blue);">
        <div id="open-profile-panel" class="p-6 text-center text-white border-b border-gray-700 cursor-pointer hover:bg-gray-800 transition-colors">
            <div class="w-24 h-24 rounded-full mx-auto bg-gray-700 border-4 border-gray-600 flex items-center justify-center mb-4">
                <i class="fa-solid fa-user text-4xl text-gray-400"></i>
            </div>
            <h3 class="font-bold text-xl">Nombre de Usuario</h3>
            <p class="text-sm text-gray-400">Nombre del Negocio</p>
        </div>
        <nav class="pt-4">
            <a href="#section-dashboard" class="sidebar-link active"><i class="fa-solid fa-chart-line"></i><span>Dashboard</span></a>
            <a href="#section-products" class="sidebar-link"><i class="fa-solid fa-box-open"></i><span>Productos</span></a>
            <a href="#section-categories" class="sidebar-link"><i class="fa-solid fa-tags"></i><span>Categorías</span></a>
            <a href="#section-quotes" class="sidebar-link"><i class="fa-solid fa-file-invoice"></i><span>Cotizaciones</span></a>
            <a href="#section-users" class="sidebar-link"><i class="fa-solid fa-users"></i><span>Usuarios</span></a>
            <a href="#" class="sidebar-link mt-8"><i class="fa-solid fa-right-from-bracket"></i><span>Salir</span></a>
        </nav>
    </aside>

    <div class="flex-1 flex flex-col">
        <header class="lg:hidden fixed top-0 left-0 right-0 z-20 flex items-center justify-between p-4 shadow-md" style="background-color: var(--brand-dark-blue);">
            <button id="open-sidebar-btn" class="text-white text-2xl">
                <i class="fa-solid fa-bars"></i>
            </button>
            <h2 class="font-heading text-xl text-white">ADMINISTRACIÓN</h2>
            <div class="w-8"></div> </header>

        <main class="flex-1 p-6 md:p-10 overflow-y-auto pt-24 lg:pt-6">
            
            <h1 class="font-heading text-4xl text-brand-dark-blue mb-6">MI CATÁLOGO DE PRODUCTOS</h1>

            <div id="section-dashboard">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <div class="bg-white p-4 rounded-lg shadow-md flex items-center border-l-4 border-green-500 transition-transform transform hover:scale-105">
                        <div class="p-3 mr-4 text-green-500 bg-green-100 rounded-full"><i class="fa-solid fa-file-invoice text-2xl"></i></div>
                        <div><p class="text-3xl font-bold text-brand-dark-blue">12</p><p class="text-gray-500 font-semibold">Cotizaciones Nuevas</p></div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow-md flex items-center border-l-4 border-blue-500 transition-transform transform hover:scale-105">
                        <div class="p-3 mr-4 text-blue-500 bg-blue-100 rounded-full"><i class="fa-solid fa-box-open text-2xl"></i></div>
                        <div><p class="text-3xl font-bold text-brand-dark-blue">152</p><p class="text-gray-500 font-semibold">Productos Activos</p></div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow-md flex items-center border-l-4 border-yellow-500 transition-transform transform hover:scale-105">
                        <div class="p-3 mr-4 text-yellow-500 bg-yellow-100 rounded-full"><i class="fa-solid fa-users text-2xl"></i></div>
                        <div><p class="text-3xl font-bold text-brand-dark-blue">34</p><p class="text-gray-500 font-semibold">Usuarios Temporales</p></div>
                    </div>
                </div>
            </div>

            <div id="section-products" class="admin-section">
                <div class="section-header"><h2 class="font-heading"><i class="fa-solid fa-box-open"></i>Gestión de Productos</h2><p class="font-heading">Añade, edita o elimina los artículos de tu catálogo.</p></div>
                <div class="flex justify-end mb-4"><button id="add-product-btn" class="btn btn-primary"><i class="fa-solid fa-plus mr-2"></i>Añadir Producto</button></div>
                <div class="bg-transparent md:bg-white md:p-4 md:rounded-lg md:shadow-md">
                    <table class="w-full text-left responsive-table">
                        <thead class="hidden md:table-header-group"><tr class="border-b"><th class="p-3">Código</th><th class="p-3">Nombre</th><th class="p-3">Categoría</th><th class="p-3">Acciones</th></tr></thead>
                        <tbody>
                            <tr>
                                <td data-label="Código" class="p-3">S-001</td>
                                <td data-label="Nombre" class="p-3">Silla Tiffany Blanca</td>
                                <td data-label="Categoría" class="p-3">Sillas</td>
                                <td data-label="Acciones" class="p-3">
                                    <div class="flex items-center justify-end md:justify-start gap-4">
                                        <button class="text-blue-600 hover:text-blue-800 text-lg"><i class="fa-solid fa-pencil"></i></button>
                                        <button data-delete-item="Silla Tiffany Blanca" class="delete-btn text-red-600 hover:text-red-800 text-lg"><i class="fa-solid fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td data-label="Código" class="p-3">M-012</td>
                                <td data-label="Nombre" class="p-3">Mesa Redonda Imperial</td>
                                <td data-label="Categoría" class="p-3">Mesas</td>
                                <td data-label="Acciones" class="p-3">
                                    <div class="flex items-center justify-end md:justify-start gap-4">
                                        <button class="text-blue-600 hover:text-blue-800 text-lg"><i class="fa-solid fa-pencil"></i></button>
                                        <button data-delete-item="Mesa Redonda Imperial" class="delete-btn text-red-600 hover:text-red-800 text-lg"><i class="fa-solid fa-trash"></i></button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div id="section-categories" class="admin-section">
                <div class="section-header"><h2 class="font-heading"><i class="fa-solid fa-tags"></i>Gestión de Categorías</h2><p class="font-heading">Organiza tus productos para una fácil navegación.</p></div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="bg-white p-6 rounded-lg shadow-md">
                        <h3 class="font-heading text-xl mb-4">Añadir Nueva Categoría</h3>
                        <input type="text" placeholder="Nombre de la categoría" class="w-full p-2 border rounded mb-4">
                        <button class="btn btn-primary w-full">Guardar Categoría</button>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-md">
                        <h3 class="font-heading text-xl mb-4">Categorías Existentes</h3>
                        <ul class="space-y-2">
                            <li class="flex justify-between items-center p-2 bg-gray-50 rounded"><span>Sillas</span><button data-delete-item="la categoría Sillas" class="delete-btn text-red-600 text-sm"><i class="fa-solid fa-trash"></i></button></li>
                            <li class="flex justify-between items-center p-2 bg-gray-50 rounded"><span>Mesas</span><button data-delete-item="la categoría Mesas" class="delete-btn text-red-600 text-sm"><i class="fa-solid fa-trash"></i></button></li>
                            <li class="flex justify-between items-center p-2 bg-gray-50 rounded"><span>Carpas</span><button data-delete-item="la categoría Carpas" class="delete-btn text-red-600 text-sm"><i class="fa-solid fa-trash"></i></button></li>
                        </ul>
                    </div>
                </div>
            </div>

            <div id="section-quotes" class="admin-section">
                   <div class="section-header"><h2 class="font-heading"><i class="fa-solid fa-file-invoice"></i>Bandeja de Cotizaciones</h2><p class="font-heading">Revisa y gestiona las solicitudes de tus clientes.</p></div>
                   <div id="quotes-list" class="bg-white rounded-lg shadow-md overflow-hidden">
                       <div data-quote-id="1" class="p-4 border-b hover:bg-gray-50 cursor-pointer flex justify-between items-center">
                           <div>
                               <p class="font-bold">Carlos Pérez - <span class="font-normal text-gray-600">carlos.p@email.com</span></p>
                               <p class="text-sm text-gray-500">Solicitud para evento el 2025-12-15</p>
                           </div>
                           <span class="text-xs font-bold uppercase py-1 px-2 rounded-full bg-green-200 text-green-800">Nuevo</span>
                       </div>
                       <div data-quote-id="2" class="p-4 border-b hover:bg-gray-50 cursor-pointer flex justify-between items-center">
                           <div>
                               <p class="font-bold">Ana López - <span class="font-normal text-gray-600">ana.lopez@email.com</span></p>
                               <p class="text-sm text-gray-500">Solicitud para evento el 2026-01-20</p>
                           </div>
                           <span class="text-xs font-bold uppercase py-1 px-2 rounded-full bg-blue-200 text-blue-800">Contactado</span>
                       </div>
                   </div>
            </div>

            <div id="section-users" class="admin-section">
                <div class="section-header"><h2 class="font-heading"><i class="fa-solid fa-users"></i>Usuarios Temporales</h2><p class="font-heading">Crea y administra claves de acceso para tus clientes.</p></div>
                   <div class="bg-white p-6 rounded-lg shadow-md">
                       <h3 class="font-heading text-xl mb-4">Crear Nuevo Acceso</h3>
                       <div class="flex flex-col sm:flex-row gap-4">
                           <input type="text" placeholder="Nombre del cliente (ej. Carlos)" class="w-full flex-grow p-2 border rounded">
                           <button class="btn btn-primary flex-shrink-0">Generar Clave</button>
                       </div>
                   </div>
                   <div class="bg-transparent md:bg-white md:p-4 md:rounded-lg md:shadow-md mt-6">
                       <table class="w-full text-left responsive-table">
                           <thead class="hidden md:table-header-group"><tr class="border-b"><th class="p-3">Cliente</th><th class="p-3">Clave de Acceso</th><th class="p-3">Acciones</th></tr></thead>
                           <tbody>
                               <tr>
                                   <td data-label="Cliente" class="p-3">Carlos Pérez</td>
                                   <td data-label="Clave" class="p-3 font-mono">BODA2025</td>
                                   <td data-label="Acciones" class="p-3">
                                       <div class="flex items-center justify-end md:justify-start gap-4">
                                           <button data-delete-item="el acceso de Carlos Pérez" class="delete-btn text-red-600 hover:text-red-800 text-lg"><i class="fa-solid fa-trash"></i></button>
                                       </div>
                                   </td>
                               </tr>
                               <tr>
                                   <td data-label="Cliente" class="p-3">Ana López</td>
                                   <td data-label="Clave" class="p-3 font-mono">EVENTO01</td>
                                   <td data-label="Acciones" class="p-3">
                                       <div class="flex items-center justify-end md:justify-start gap-4">
                                           <button data-delete-item="el acceso de Ana López" class="delete-btn text-red-600 hover:text-red-800 text-lg"><i class="fa-solid fa-trash"></i></button>
                                       </div>
                                   </td>
                               </tr>
                           </tbody>
                       </table>
                   </div>
            </div>
        </main>
    </div>

    <div id="profile-panel" class="side-panel fixed top-0 right-0 h-full w-full md:w-1/2 lg:w-1/3 bg-white shadow-lg z-50 transform translate-x-full transition-transform duration-300">
        <div class="p-4 border-b flex justify-between items-center">
            <h3 class="font-heading text-xl">Editar Perfil</h3>
            <button class="close-panel-btn text-gray-500 hover:text-black text-2xl">&times;</button>
        </div>
        <div class="p-6 overflow-y-auto" style="height: calc(100% - 57px);">
            <form>
                <div class="text-center mb-6">
                    <div class="w-24 h-24 rounded-full mx-auto bg-gray-200 border-2 border-dashed flex items-center justify-center cursor-pointer relative group">
                        <i class="fa-solid fa-camera text-3xl text-gray-400"></i>
                        <div class="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center text-white opacity-0 group-hover:opacity-100 transition-opacity rounded-full">
                            <span>Cambiar</span>
                        </div>
                    </div>
                </div>
                <div><label for="profile-name" class="block text-sm font-bold text-gray-700">Nombre de Usuario</label><input type="text" id="profile-name" value="Nombre de Usuario" class="w-full p-2 border rounded mt-1"></div>
                <div class="mt-4"><label for="profile-email" class="block text-sm font-bold text-gray-700">Email</label><input type="email" id="profile-email" value="usuario@negocio.com" class="w-full p-2 border rounded mt-1 bg-gray-100" disabled></div>
                <div class="mt-4"><label for="profile-password" class="block text-sm font-bold text-gray-700">Nueva Contraseña</label><input type="password" id="profile-password" class="w-full p-2 border rounded mt-1"></div>
                <div class="mt-4"><label for="profile-password-confirm" class="block text-sm font-bold text-gray-700">Confirmar Contraseña</label><input type="password" id="profile-password-confirm" class="w-full p-2 border rounded mt-1"></div>
                <div class="mt-8"><button type="submit" class="btn btn-primary w-full">Guardar Cambios</button></div>
            </form>
        </div>
    </div>

    <div id="product-panel" class="side-panel fixed top-0 right-0 h-full w-full md:w-1/2 lg:w-1/3 bg-white shadow-lg z-50 transform translate-x-full transition-transform duration-300">
        <div class="p-4 border-b flex justify-between items-center">
            <h3 class="font-heading text-xl">Añadir Nuevo Producto</h3>
            <button class="close-panel-btn text-gray-500 hover:text-black text-2xl">&times;</button>
        </div>
        <div class="p-6 overflow-y-auto" style="height: calc(100% - 57px);">
            <form>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <input type="text" placeholder="Nombre del Producto" class="p-2 border rounded w-full">
                    <input type="text" placeholder="Código (ej. S-002)" class="p-2 border rounded w-full">
                </div>
                <select class="p-2 border rounded w-full mt-4">
                    <option>Seleccionar Categoría</option>
                    <option>Sillas</option>
                    <option>Mesas</option>
                    <option>Carpas</option>
                </select>
                <textarea placeholder="Descripción del producto..." rows="4" class="p-2 border rounded w-full mt-4"></textarea>
                <h3 class="font-semibold mt-6 mb-2">Fotos del Producto (Máx. 4)</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    <div class="h-24 bg-gray-200 rounded flex items-center justify-center text-gray-400 cursor-pointer hover:bg-gray-300"><i class="fa-solid fa-plus"></i></div>
                    <div class="h-24 bg-gray-200 rounded flex items-center justify-center text-gray-400 cursor-pointer hover:bg-gray-300"><i class="fa-solid fa-plus"></i></div>
                    <div class="h-24 bg-gray-200 rounded flex items-center justify-center text-gray-400 cursor-pointer hover:bg-gray-300"><i class="fa-solid fa-plus"></i></div>
                    <div class="h-24 bg-gray-200 rounded flex items-center justify-center text-gray-400 cursor-pointer hover:bg-gray-300"><i class="fa-solid fa-plus"></i></div>
                </div>
                <div class="flex justify-end gap-4 mt-8">
                    <button type="button" class="close-panel-btn btn bg-gray-300">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar Producto</button>
                </div>
            </form>
        </div>
    </div>
    
    <div id="quote-detail-panel" class="side-panel fixed top-0 right-0 h-full w-full md:w-1/2 lg:w-1/3 bg-white shadow-lg z-50 transform translate-x-full transition-transform duration-300">
        <div class="p-4 border-b flex justify-between items-center">
            <h2 class="font-heading text-xl">Detalle de Cotización</h2>
            <button class="close-panel-btn text-gray-500 hover:text-black text-2xl">&times;</button>
        </div>
        <div class="p-6 overflow-y-auto" style="height: calc(100% - 57px);">
            <div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div><p class="font-bold">Cliente:</p><p id="quote-client-name"></p></div>
                    <div><p class="font-bold">Email:</p><p id="quote-client-email"></p></div>
                    <div><p class="font-bold">Teléfono:</p><p id="quote-client-phone"></p></div>
                    <div><p class="font-bold">Fecha del Evento:</p><p id="quote-event-date"></p></div>
                </div>
                <div class="mb-4"><p class="font-bold">Comentarios:</p><p id="quote-client-comments" class="text-gray-600 italic"></p></div>
                
                <h3 class="font-heading text-lg border-t pt-4 mb-2">Productos Cotizados</h3>
                <div id="quote-product-list" class="space-y-2">
                    </div>
            </div>
            <div class="flex justify-end gap-4 mt-8">
                <button id="mark-contacted-btn" class="btn btn-secondary">Marcar como Contactado</button>
            </div>
        </div>
    </div>

    <div id="delete-confirm-modal" class="modal-backdrop hidden">
        <div class="modal-content text-center">
            <i class="fa-solid fa-triangle-exclamation text-5xl text-red-500 mb-4"></i>
            <h2 class="font-heading text-2xl mb-2">¿Estás seguro?</h2>
            <p class="text-gray-600 mb-6">Vas a eliminar <strong id="item-to-delete-name"></strong>. Esta acción no se puede deshacer.</p>
            <div class="flex justify-center gap-4">
                <button id="cancel-delete-btn" class="btn bg-gray-300">Cancelar</button>
                <button id="confirm-delete-btn" class="btn btn-danger">Sí, Eliminar</button>
            </div>
        </div>
    </div>

    <script src="script.js"></script>
</body>
</html>