<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso al Catálogo | Tu Negocio</title>
    <meta name="description" content="Accede a tu catálogo personalizado de productos para eventos.">
    <meta name="robots" content="noindex, nofollow">

    <!-- Carga de Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Enlace a la fuente Barlow de Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Enlace a Lucide Icons para los iconos -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <style>
        /* Paleta de colores de la marca */
        :root {
            --color-primary: #07162d; /* Azul Oscuro */
            --color-secondary: #9e1428; /* Rojo */
            --color-highlight: #ffc857; /* Amarillo */
            --color-background: #f5f5f5; /* Fondo Blanco */
        }

        body {
            font-family: 'Barlow', sans-serif;
            /* Aplicamos el gradiente al body para que cubra toda la pantalla */
            background: linear-gradient(135deg, var(--color-primary) 0%, #1a2b42 100%);
            display: flex;
            flex-direction: column; /* Permite centrar verticalmente y añadir el copyright abajo */
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 1rem; /* Espaciado general para móviles */
            box-sizing: border-box; /* Asegura que el padding no cause desbordamiento */
            color: var(--color-primary); /* Color de texto predeterminado para el body */
        }

        /* Estilos para el título de dos colores */
        .main-title-part-1 { color: var(--color-primary); }
        .main-title-part-2 { color: var(--color-secondary); }

        /* Estilo para el botón de acceso */
        .btn-access {
            background-color: var(--color-secondary);
            color: white;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .btn-access:hover {
            background-color: #7c1020; /* Tono más oscuro al pasar el ratón */
            transform: translateY(-2px); /* Efecto de "levantar" */
            box-shadow: 0 10px 15px -3px rgba(158, 20, 40, 0.3), 0 4px 6px -2px rgba(158, 20, 40, 0.1);
        }
        .btn-access:active {
            transform: translateY(-1px) scale(0.98); /* Efecto de "presionar" */
            box-shadow: 0 2px 4px -1px rgba(158, 20, 40, 0.2);
        }

        /* Estilo para los campos de entrada con icono */
        .input-with-icon {
            position: relative;
        }
        .input-with-icon input {
            padding-left: 2.5rem; /* Espacio para el icono */
        }
        .input-with-icon .icon {
            position: absolute;
            left: 0.75rem; /* 12px */
            top: 50%;
            transform: translateY(-50%);
            color: #9ca3af; /* gray-400 */
            pointer-events: none; /* Asegura que el icono no bloquee el clic en el input */
        }

        /* Overlay para la imagen del lado izquierdo */
        .image-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(7, 22, 45, 0.6) 0%, rgba(158, 20, 40, 0.4) 100%);
            border-radius: 1rem 0 0 1rem; /* Solo esquinas izquierdas redondeadas */
        }

        /* Media queries para ajustar el diseño en pantallas pequeñas */
        @media (max-width: 767px) {
            .login-card {
                padding: 1.5rem; /* Menos padding en móviles */
            }
            /* Ajuste el tamaño del título para móviles */
            .title-mobile-adjust {
                font-size: 2.5rem; /* Tamaño de fuente más pequeño para el título en móvil */
            }
        }
    </style>
</head>
<body class="flex flex-col items-center justify-center min-h-screen p-4">
    <div class="w-full max-w-4xl">
        <!-- Logotipo -->
        <div class="mb-6 text-center">
            <img src="https://placehold.co/192x64/07162d/ffffff?text=Tu+Negocio" alt="Logotipo" class="w-48 mx-auto" onerror="this.src='https://placehold.co/192x64/07162d/ffffff?text=Tu+Negocio'; this.style.backgroundColor='transparent';">
        </div>

        <!-- Contenedor de Acceso -->
        <div class="relative flex flex-col bg-white shadow-2xl rounded-2xl md:flex-row md:space-y-0 overflow-hidden">
            <!-- Lado Izquierdo (Imagen y Marca con Overlay) -->
            <div class="relative hidden md:block md:w-1/2">
                <img 
                    src="https://placehold.co/600x800/07162d/ffc857?text=Imagen+de+Portada" 
                    alt="Imagen de fondo para el acceso" 
                    class="w-full h-full object-cover rounded-l-2xl"
                >
                <div class="image-overlay"></div>
            </div>

            <!-- Lado Derecho (Formulario de Código) -->
            <div class="flex flex-col justify-center p-6 md:p-10 w-full md:w-1/2 rounded-r-2xl">
                <h2 class="mb-2 text-4xl font-extrabold text-center md:text-left title-mobile-adjust">
                    <span class="main-title-part-1">ACCESO </span><span class="main-title-part-2">AL CATÁLOGO</span>
                </h2>
                <span class="font-light text-gray-500 text-base mb-4 text-center md:text-left">
                    Introduce tu código para ver el catálogo personalizado.
                </span>

                <!-- Área para mensajes de error (oculta por defecto) -->
                <div id="error-message" class="hidden bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                    <strong class="font-bold">¡Error!</strong>
                    <span class="block sm:inline" id="error-text"></span>
                </div>

                <form id="access-form" class="space-y-3">
                    <div>
                        <label for="access-code" class="block mb-1 text-md font-semibold text-gray-700 text-left">Código de Acceso</label>
                        <div class="input-with-icon">
                            <i data-lucide="key" class="icon w-5 h-5"></i>
                            <input 
                                type="text"
                                id="access-code"
                                name="access-code"
                                class="w-full p-3 border border-gray-300 rounded-lg placeholder:font-light placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]"
                                placeholder="Introduce tu código"
                                required
                            >
                        </div>
                    </div>

                    <button type="submit" class="w-full btn-access font-bold p-3 rounded-lg mb-6 flex items-center justify-center uppercase">
                        <i data-lucide="log-in" class="w-5 h-5 mr-2"></i>
                        <span>ACCEDER</span>
                    </button>
                </form>

                <!-- Removido: "¿NO TIENES UNA CUENTA? REGÍSTRATE AQUÍ" -->
            </div>
        </div>
        
        <!-- Copyright -->
        <div class="mt-8 text-center text-gray-400 text-sm">
            <p>&copy; 2024 Tu Negocio. Todos los derechos reservados.</p>
        </div>
    </div>

    <script>
        // Inicializa los iconos de Lucide al cargar la página
        lucide.createIcons();

        document.addEventListener('DOMContentLoaded', () => {
            // Datos simulados de códigos de acceso y nombres de clientes
            const validCodes = {
                "CLIENTE123": "Juan Pérez",
                "EVENTOABC": "Maria García",
                "VIP2024": "Empresa XYZ",
                "DEMO": "Invitado Especial" // Un código de ejemplo para probar
            };

            const accessForm = document.getElementById('access-form');
            const accessCodeInput = document.getElementById('access-code');
            const errorMessageDiv = document.getElementById('error-message');
            const errorTextSpan = document.getElementById('error-text');

            accessForm.addEventListener('submit', (e) => {
                e.preventDefault(); // Evita el envío del formulario por defecto

                const code = accessCodeInput.value.trim().toUpperCase(); // Obtiene el código y lo convierte a mayúsculas
                
                // Oculta cualquier mensaje de error previo
                errorMessageDiv.classList.add('hidden');
                errorTextSpan.textContent = '';

                if (validCodes[code]) {
                    // Si el código es válido, guarda el nombre del cliente en sessionStorage
                    sessionStorage.setItem('clientName', validCodes[code]);
                    sessionStorage.setItem('loggedIn', 'true'); // Marca al usuario como logueado
                    
                    // Redirige al catálogo. Asegúrate de que la URL sea correcta para tu entorno.
                    window.location.href = window.location.origin + window.location.pathname.replace('login-page.html', 'catalogo-interactivo.html');
                } else {
                    // Muestra un mensaje de error si el código es inválido
                    errorTextSpan.textContent = 'Código de acceso inválido. Inténtalo de nuevo.';
                    errorMessageDiv.classList.remove('hidden');
                    accessCodeInput.value = ''; // Limpia el campo
                }
            });

            // Opcional: Si ya está logueado, redirigir al catálogo inmediatamente
            // Esto es para el caso en que el usuario intente acceder directamente a login-page.html
            // mientras ya tiene una sesión activa.
            if (sessionStorage.getItem('loggedIn') === 'true' && sessionStorage.getItem('clientName')) {
                window.location.href = window.location.origin + window.location.pathname.replace('login-page.html', 'catalogo-interactivo.html');
            }
        });
    </script>
</body>
</html>
