<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cleaning Pro | Servicios de Limpieza Profesional para Hogares y Negocios</title>
    <meta name="description" content="Cleaning Pro ofrece servicios de limpieza profunda, mantenimiento regular y limpieza de oficinas para hogares y negocios. ¡Obtén tu cotización gratis hoy!">
    
    <link rel="icon" type="image/png" href="img/Favicon.png">
    <link rel="apple-touch-icon" href="img/Favicon.png">

    <meta property="og:title" content="Cleaning Pro | Servicios de Limpieza Profesional para Hogares y Negocios">
    <meta property="og:description" content="Cleaning Pro ofrece servicios de limpieza profunda, mantenimiento regular y limpieza de oficinas para hogares y negocios. ¡Obtén tu cotización gratis hoy!">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://cleaningpro.com/">
    <meta property="og:image" content="img/image01.jpg">
    <meta property="og:locale" content="es_ES">

    <script src="https://cdn.tailwindcss.com"></script>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <script src="https://unpkg.com/lucide@latest"></script>

    <script src="https://unpkg.com/imask"></script>
    
    <script src="script.js"></script>
    <link rel="stylesheet" href="style.css">

    <style>
        .sticky-nav {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 50;
            transition: all 0.3s ease-in-out;
        }
    </style>
    
        <?php include 'files/gtm-head.php'; ?>

</head>
<body>

        <?php include 'files/gtm-body.php'; ?>

    <div id="wrapper">

        <header class="hidden md:block bg-white shadow-lg">
            <div class="max-w-7xl mx-auto py-5 px-6 flex items-center">
                <div class="flex-grow flex justify-center">
                    <img src="img/LogoNegro.png" alt="Logotipo de Cleaning Pro" class="w-auto h-21 object-contain max-w-[300px]">
                </div>

                <div class="flex items-center space-x-6 ml-auto">
                    <div class="flex items-center gap-3">
                        <i data-lucide="phone-call" class="text-brand-primary text-3xl"></i>
                        <span class="text-xl text-brand-primary font-black"> +1 (425) 243-4579</span>
                    </div>
<a href="mailto:info@cleaningpro.com" class="flex items-center gap-3 hover:opacity-80 transition-opacity duration-200">
    <i data-lucide="mail" class="text-brand-primary text-3xl"></i>
    <span class="text-xl text-brand-primary font-black">
        <script>
            document.write('info' + '@' + 'cleaningpro.com');
        </script>
    </span>
</a>
                    <a href="#quote-form" class="hidden md:flex btn btn-primary py-2 px-4 text-base rounded-md items-center gap-2 ml-6" role="button">
                        OBTÉN UNA COTIZACIÓN <i data-lucide="arrow-right" class="text-xl"></i>
                    </a>
                </div>
            </div>
            
            <nav class="bg-brand-primary py-3 shadow-md" id="main-navbar">
                <ul class="max-w-7xl mx-auto flex flex-wrap justify-center items-center gap-x-8 gap-y-2 text-lg font-black">
                    <li><a href="#wrapper" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="home"></i> INICIO</a></li>
                    <li><a href="#services-list" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="sparkles"></i> SERVICIOS</a></li>
                    <li><a href="#how-it-works" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="settings"></i> CÓMO FUNCIONA</a></li>
                    <li><a href="#gallery-section" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="image"></i> GALERÍA</a></li>
                    <li><a href="#coverage-area" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="map-pin"></i> COBERTURA</a></li>
                    <li><a href="#quote-form" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="file-text"></i> OBTÉN COTIZACIÓN</a></li>
                    <li><a href="index.php" class="border-2 border-brand-secondary text-brand-secondary hover:bg-brand-secondary hover:text-brand-primary transition-colors duration-220 px-3 py-1 rounded-md flex items-center gap-2 text-sm"><i data-lucide="globe"></i> ENGLISH</a></li>
                </ul>
            </nav>
        </header>

        <header class="md:hidden bg-white shadow-lg py-3 px-4 flex items-center fixed top-0 left-0 w-full z-50">
            <img src="img/LogoNegro.png" alt="Logotipo de Cleaning Pro para móvil" class="w-auto h-16 object-contain mr-auto max-w-[120px]">
            
            <button id="openQuoteModalMobile" class="btn-mobile-header">
                <span>OBTÉN UNA COTIZACIÓN</span>
                <i data-lucide="file-text"></i>
            </button>

            <i data-lucide="menu" class="hamburger-icon ml-auto icon w-16 h-16 text-brand-primary" id="openMobileMenu"></i>
        </header>

        <div class="mobile-menu-overlay hidden" id="mobileMenuOverlay"></div>
        <div class="mobile-menu" id="mobileMenu">
            <div class="mobile-menu-header">
                <img src="img/LogoBlanco.png" alt="Logotipo de Cleaning Pro en menú móvil" class="w-80 max-w-full h-auto object-contain mb-3">
                
                <div class="contact-card phone-card" data-aos="zoom-in" data-aos-delay="200">
                    <i data-lucide="message-square" class="icon-large"></i>
                    <div class="text-content">
                        <span class="contact-label">CONSULTA GRATIS</span>
                        <a href="https://wa.me/14252434579" target="_blank" class="contact-value">+1 (425) 243-4579</a>
                    </div>
                </div>
            </div>
            <nav class="mobile-menu-nav">
                <ul>
                    <li><a href="#wrapper" class="mobile-menu-link"><i data-lucide="home"></i> INICIO</a></li>
                    <li><a href="#services-list" class="mobile-menu-link"><i data-lucide="sparkles"></i> NUESTROS SERVICIOS</a></li>
                    <li><a href="#how-it-works" class="mobile-menu-link"><i data-lucide="settings"></i> CÓMO FUNCIONA</a></li>
                    <li><a href="#gallery-section" class="mobile-menu-link"><i data-lucide="image"></i> GALERÍA</a></li>
                    <li><a href="#coverage-area" class="mobile-menu-link"><i data-lucide="map-pin"></i> ZONA DE COBERTURA</a></li>
                    <li><a href="#quote-form" class="mobile-menu-link"><i data-lucide="file-text"></i> OBTÉN UNA COTIZACIÓN</a></li>
                    <li class="mt-4">
                        <a href="index.php" class="inline-block border-2 border-brand-secondary text-brand-secondary hover:bg-brand-secondary hover:text-brand-primary transition-colors duration-220 px-4 py-2 rounded-md flex items-center gap-2 w-full justify-center">
                            <i data-lucide="globe"></i> ENGLISH
                        </a>
                    </li>
                </ul>
            </nav>
            <div class="mobile-menu-footer">
                <?php include 'footer.php'; ?>
            </div>
        </div>
        <main class="flex-grow">
            <section class="bg-brand-secondary text-brand-primary text-center py-3 px-4 text-lg font-heading tracking-wide shadow-md flex items-center justify-center gap-2 md:hidden mt-24">
                <i class="ph-bold ph-calendar-check text-2xl"></i>
                PLANIFICA TU LIMPIEZA
            </section>

            <section id="solution-section" class="text-center py-32 px-10 shadow-inner hero-section-bg">
                <div class="max-w-7xl mx-auto md:flex md:items-center md:gap-12 md:text-left">
                    <div class="md:w-1/2 mb-8 md:mb-0">
                        <h3 class="section-subtitle subtitle-dark mt-4 text-2xl text-center md:text-left" data-aos="fade-up" data-aos-delay="100">¿BUSCAS UN ESPACIO IMPECABLE?</h3>
                        <h1 class="text-4xl sm:text-5xl md:text-6xl leading-tight font-heading text-white animate-fade-in-down text-center md:text-left">
                            ESTAMOS AQUÍ PARA HACERLO BRILLAR
                        </h1>
                        <p class="text-lg text-white mt-4 md:text-xl">
                            Ya sea que necesites limpieza profunda en tu hogar, mantenimiento regular o servicios de limpieza de oficinas, tenemos todo lo que necesitas para transformar tu espacio. Ofrecemos una variedad de opciones personalizables para adaptarse a cualquier necesidad.
                        </p>
                        <a href="#quote-form" class="btn btn-primary mt-8 inline-flex" role="button" data-aos="fade-up" data-aos-delay="700">
                            OBTÉN UNA COTIZACIÓN <i data-lucide="arrow-right" class="text-2xl"></i>
                        </a>
                    </div>
                    <div class="md:w-1/2 flex justify-center md:justify-start">
                        <img src="img/image01.jpg" alt="Imagen de productos de limpieza y guantes" class="w-full rounded-xl shadow-xl object-cover h-64 sm:h-80 md:h-96" data-aos="zoom-in">
                    </div>
                </div>
            </section>

            <section class="relative bg-brand-light py-32 px-6 overflow-hidden" data-aos="fade-up">
                <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(white 1px, transparent 1px); background-size: 20px 20px;"></div>
                <div class="relative z-10 text-center md:flex md:items-center md:justify-center md:text-left max-w-7xl mx-auto md:gap-12">
                    <div class="md:w-1/2 flex justify-center md:justify-end mb-8 md:mb-0">
                        <img src="img/LogoNegro.png" onerror="this.onerror=null; this.src='https://placehold.co/800x600/F0F0F0/333333?text=Image+Not+Found';" alt="Logotipo circular de Cleaning Pro" class="w-56 h-56 sm:w-72 sm:h-72 object-contain rounded-full border-8 border-brand-secondary shadow-2xl transform hover:scale-105 transition-transform duration-300 p-4 md:hidden">
                        <img src="img/image03.jpg" alt="Imagen del logotipo completo de Cleaning Pro para escritorio" class="w-full rounded-xl shadow-xl object-cover h-64 sm:h-80 md:h-96 hidden md:block">
                    </div>
                    <div class="md:w-1/2 md:pl-8">
                        <h3 class="section-subtitle subtitle-light mt-4 text-2xl text-center md:text-left">Crea el ambiente perfecto en tu hogar o negocio.</h3>
                        <h2 class="section-title title-light mt-2 text-5xl sm:text-6xl text-center md:text-left">UN ESPACIO LIMPIO NO DEBE SER ESTRESANTE</h2>
                        <p class="text-gray-700 leading-relaxed max-w-2xl mt-6 text-xl opacity-90">
                            Después de un día ocupado, lo último que quieres es preocuparte por la limpieza. Nuestros servicios de limpieza profunda y mantenimiento regular sientan las bases para un espacio impecable, asegurando que tu hogar o negocio luzca increíble. Nuestros servicios de limpieza de oficinas garantizan un entorno productivo y saludable.
                        </p>
                    </div>
                </div>
            </section>

            <img src="img/imageMobile01.jpg" alt="Imagen divisora: La solución para espacios limpios" class="section-divider-img md:hidden" data-aos="fade-up">
            
            <section class="py-12 px-6 bg-white text-center">
                <div class="max-w-7xl mx-auto md:flex md:items-center md:justify-between md:text-left">
                    <div class="md:w-1/2 mb-8 md:mb-0">
                        <h2 class="text-4xl sm:text-5xl md:text-6xl leading-tight font-heading title-light animate-fade-in-down text-center md:text-left">
                            Solicita tu presupuesto gratis 
                        </h2>
                        <h3 class="section-subtitle subtitle-light text-2xl md:text-left">
                            ¿Quieres dejar la limpieza en manos de expertos?
                        </h3>
                    </div>
                    <div class="md:w-1/3 flex flex-col items-center md:items-center">
                        <a href="#quote-form" class="btn btn-primary mb-4" role="button">
                            OBTÉN UNA COTIZACIÓN<i data-lucide="arrow-right" class="text-2xl"></i>
                        </a>
                        <div class="flex items-center">
                            <span class="w-10 h-10 bg-brand-secondary rounded-full flex items-center justify-center mr-2">
                                <i data-lucide="phone-call" class="text-brand-primary text-2xl"></i>
                            </span>
                            <span class="text-xl text-brand-primary font-black"> +1 (425) 243-4579</span>
                        </div>
                    </div>
                </div>
            </section>

            <img src="img/imageMobile02.jpg" alt="Imagen divisora: Calidad y confianza en servicios de limpieza" class="section-divider-img md:hidden" data-aos="fade-up">

            <section id="why-choose-us" class="py-32 px-6 text-center why-choose-us-bg">
                <div class="mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-dark text-2xl">Nuestra diferencia, tu beneficio de limpieza</h3>
                    <h2 class="section-title title-dark mt-2 text-5xl sm:text-6xl">¿POR QUÉ ELEGIRNOS?</h2>
                </div>
                <div class="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="why-choose-card" data-aos="fade-up" data-aos-delay="100">
                        <i data-lucide="medal" class="text-brand-secondary icon w-16 h-16"></i>
                        <h4 class="title">EXPERIENCIA COMPROBADA</h4>
                        <p>Tenemos años de experiencia en la industria de la limpieza, lo que garantiza resultados impecables en cada servicio.</p>
                    </div>
                    <div class="why-choose-card" data-aos="fade-up" data-aos-delay="200">
                        <i data-lucide="handshake" class="text-brand-secondary icon w-16 h-16"></i>
                        <h4 class="title">PERSONAL DE CONFIANZA</h4>
                        <p>Nuestro equipo está altamente capacitado y es completamente digno de confianza para tu tranquilidad y la seguridad de tu espacio.</p>
                    </div>
                    <div class="why-choose-card" data-aos="fade-up" data-aos-delay="300">
                        <i data-lucide="sparkles" class="text-brand-secondary icon w-16 h-16"></i>
                        <h4 class="title">RESULTADOS GARANTIZADOS</h4>
                        <p>Estamos comprometidos con la excelencia, asegurando que cada rincón de tu espacio sea extraordinario y sin preocupaciones.</p>
                    </div>
                </div>
            </section>

            <section id="services-list" class="py-32 px-6 bg-gray-100">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">Todo lo que necesitas para un espacio impecable</h3>
                    <h2 class="section-title title-light mt-2 text-5xl sm:text-6xl">NUESTROS SERVICIOS</h2>
                    <p class="max-w-3xl mx-auto mt-6 text-lg text-gray-700">
                        Ofrecemos una gama completa de servicios para garantizar que tu espacio esté perfectamente limpio y ordenado. Desde limpiezas esenciales hasta servicios especializados, lo tenemos cubierto:
                    </p>
                </div>

                <div class="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <div class="service-card" data-aos="fade-up" data-aos-delay="100">
                        <i data-lucide="home" class="text-brand-primary icon w-16 h-16 block mx-auto"></i>
                        <h4 class="title">Limpieza Residencial</h4>
                        <p class="text-gray-700 mt-2">Servicios de limpieza profunda y mantenimiento para tu hogar, dejándolo impecable.</p>
                    </div>
                    <div class="service-card" data-aos="fade-up" data-aos-delay="200">
                        <i data-lucide="building-2" class="text-brand-primary icon w-16 h-16 block mx-auto"></i>
                        <h4 class="title">Limpieza Comercial</h4>
                        <p class="text-gray-700 mt-2">Mantén tu oficina o negocio impecable con nuestros servicios de limpieza profesional.</p>
                    </div>
                    <div class="service-card" data-aos="fade-up" data-aos-delay="300">
                        <i data-lucide="spray-can" class="text-brand-primary icon w-16 h-16 block mx-auto"></i>
                        <h4 class="title">Limpieza Especializada</h4>
                        <p class="text-gray-700 mt-2">Servicios de limpieza para eventos, post-construcción y otras necesidades específicas.</p>
                    </div>
                </div>

                <div class="text-center mt-16 max-w-3xl mx-auto" data-aos="fade-up">
                    <p class="text-lg text-gray-800">
                        Ya sea que estés planeando una limpieza única o un servicio recurrente, estamos aquí para hacerlo extraordinario.
                        <a href="#quote-form" class="font-bold text-brand-primary hover:text-brand-accent transition-colors">
                            ¡Contáctanos hoy!
                        </a>
                        para saber más sobre cómo podemos dar vida a tu visión de un espacio limpio.
                    </p>
                </div>
            </section>

            <section id="how-it-works" class="py-32 px-6 how-it-works-bg text-white">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-dark text-2xl">De la cotización a la limpieza en 4 pasos</h3>
                    <h2 class="section-title title-dark mt-2 text-5xl sm:text-6xl">TU ESPACIO, CERO COMPLICACIONES</h2>
                </div>
                
                <div class="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="100">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="file-pen-line" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Paso 1</span><br />Llena el Formulario</h3>
                        <p class="text-gray-700">Comienza el proceso diciéndonos qué tipo de limpieza necesitas a través de nuestro formulario.</p>
                    </div>
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="200">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="phone-call" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Paso 2</span><br />Te Llamamos</h3>
                        <p class="text-gray-700">Un miembro de nuestro equipo se pondrá en contacto contigo para entender mejor tus necesidades y finalizar los detalles.</p>
                    </div>
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="300">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="handshake" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Paso 3</span><br />Reserva el Servicio</h3>
                        <p class="text-gray-700">Una vez que todo esté definido, confirmas el servicio de limpieza para la fecha deseada.</p>
                    </div>
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="400">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="party-popper" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Paso 4</span><br />Disfruta de Tu Espacio</h3>
                        <p class="text-gray-700">Nosotros nos encargamos de la limpieza para que tú solo te concentres en disfrutar de tu espacio impecable sin complicaciones.</p>
                    </div>
                </div>

                <div class="text-center mt-16">
                    <a href="#quote-form" class="btn btn-primary inline-flex" role="button" data-aos="fade-up">
                        EMPIEZA CON EL PASO 1 <i data-lucide="arrow-right" class="text-2xl"></i>
                    </a>
                </div>
            </section>

            <img src="img/imageMobile03.jpg" alt="Imagen divisora: Galería de trabajos de limpieza" class="section-divider-img md:hidden" data-aos="fade-up">
            
            <section id="gallery-section" class="py-32 px-6 bg-gray-100">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">Explora nuestro trabajo anterior e inspírate para el tuyo.</h3>
                    <h2 class="section-title title-light mt-2 text-5xl sm:text-6xl">IMAGINA LO QUE PODEMOS HACER POR TI</h2>
                </div>
                <div class="max-w-7xl mx-auto">
                    <div class="gallery-main-display mb-6" data-aos="zoom-in">
                        <img id="main-gallery-image" src="img/imageGallery01.jpg" alt="Cocina impecable después de la limpieza">
                    </div>
                    <div class="gallery-thumbnails-grid" data-aos="fade-up" data-aos-delay="100">
                        <div class="gallery-thumbnail-card active" data-src="img/imageGallery02.jpg"><img src="img/imageGallery02.jpg" alt="Miniatura de baño limpio"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery03.jpg"><img src="img/imageGallery03.jpg" alt="Miniatura de sala de estar organizada"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery04.jpg"><img src="img/imageGallery04.jpg" alt="Miniatura de oficina con escritorios limpios"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery05.jpg"><img src="img/imageGallery05.jpg" alt="Miniatura de pisos brillantes"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery06.jpg"><img src="img/imageGallery06.jpg" alt="Miniatura de ventanas limpias"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery07.jpg"><img src="img/imageGallery07.jpg" alt="Miniatura de aspiradora funcionando"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery08.jpg"><img src="img/imageGallery08.jpg" alt="Miniatura de productos de limpieza"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery09.jpg"><img src="img/imageGallery09.jpg" alt="Miniatura de equipo de limpieza profesional"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery10.jpg"><img src="img/imageGallery10.jpg" alt="Miniatura de área de recepción limpia"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery11.jpg"><img src="img/imageGallery11.jpg" alt="Miniatura de habitación ordenada"></div>
                    </div>
                </div>
            </section>

            <section id="coverage-area" class="py-32 px-6 bg-white">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">¿Dónde hacemos brillar tus espacios?</h3>
                    <h2 class="section-title title-light mt-2 text-5xl sm:text-6xl">NUESTRA COBERTURA</h2>
                </div>
                
                <div class="max-w-7xl mx-auto md:flex md:items-center md:gap-12 md:text-left">
                    <div class="md:w-1/2 flex justify-center md:justify-end mb-8 md:mb-0" data-aos="fade-right">
                        <img src="img/image06.jpg" alt="Mapa ilustrativo del área de cobertura de Cleaning Pro en EE.UU." class="w-full rounded-xl shadow-xl object-cover h-64 sm:h-80 md:h-96">
                    </div>
                    <div class="md:w-1/2 text-center md:text-left">
                        <p class="text-lg text-gray-700 leading-relaxed mb-8" data-aos="fade-up" data-aos-delay="100">
                            Sirviendo a toda la región del noroeste de Washington, nos comprometemos a ofrecer servicios de limpieza de alta calidad que transforman tu hogar o negocio en un espacio impecable. No importa el tamaño del espacio, tenemos todo lo que necesitas.
                        </p>
                        <ul class="grid grid-cols-1 sm:grid-cols-2 gap-4 text-xl text-brand-primary font-bold list-none p-0" data-aos="fade-up" data-aos-delay="200">
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Seattle</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Bellevue</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Redmond</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Kirkland</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Renton</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Tacoma</li>
                        </ul>
                        <p class="text-base text-gray-600 mt-8" data-aos="fade-up" data-aos-delay="300">
                            Si tu ubicación no está en la lista, contáctanos. ¡Es posible que aún podamos ayudarte a limpiar tu espacio!
                        </p>
                    </div>
                </div>
            </section>

            <section id="quote-form" class="bg-brand-primary py-20 md:py-32 px-6 text-white">
                <div class="max-w-7xl mx-auto md:flex md:items-center md:gap-12">
                    <div class="md:w-1/2 text-center md:text-left mb-12 md:mb-0" data-aos="fade-right">
                        <h3 class="section-subtitle subtitle-dark text-2xl text-center md:text-left">¡OBTÉN TU COTIZACIÓN GRATIS HOY!</h3>
                        <h2 class="section-title title-dark mt-2 text-5xl sm:text-6xl text-center md:text-left">¿LISTO PARA UN ESPACIO IMPECABLE?</h2>
                        <p class="text-white leading-relaxed max-w-2xl mt-6 text-xl opacity-90">
                            ¿Listo para un espacio reluciente? Estamos aquí para ayudarte sin ningún compromiso. Ya sea que necesites limpieza residencial, comercial o especializada, ofrecemos soluciones personalizadas a tus necesidades.
                        </p>
                        <ul class="text-white text-lg mt-8 space-y-4 list-none p-0">
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="100">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Limpieza Residencial:</span> Para un hogar siempre impecable.</div>
                            </li>
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="200">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Limpieza Comercial:</span> Mantén tu negocio profesional y prístino.</div>
                            </li>
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="300">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Limpieza Especializada:</span> Soluciones para necesidades específicas.</div>
                            </li>
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="400">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Amplia Cobertura:</span> Servimos en todo el noroeste de Washington.</div>
                            </li>
                        </ul>
                    </div>
                    
                    <div class="md:w-1/2 bg-white p-8 rounded-xl shadow-2xl" data-aos="zoom-in">
                        <h2 class="section-title title-light text-3xl mb-6 text-center w-full">SOLICITA TU COTIZACIÓN HOY</h2>
                        <form id="contact-form" class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-brand-primary text-lg font-bold mb-2">Nombre Completo:</label>
                                    <input type="text" id="name" name="name" class="form-input" placeholder="Tu nombre" required>
                                </div>
                                <div>
                                    <label for="email" class="block text-brand-primary text-lg font-bold mb-2">Correo Electrónico:</label>
                                    <input type="email" id="email" name="email" class="form-input" placeholder="tu.correo@ejemplo.com" required>
                                </div>
                                <div>
                                    <label for="phone" class="block text-brand-primary text-lg font-bold mb-2">Número de Teléfono:</label>
                                    <input type="tel" id="phone" name="phone" class="form-input" placeholder="+1 (XXX) XXX-XXXX" required>
                                </div>
                                <div>
                                    <label for="service-quote" class="block text-brand-primary text-lg font-bold mb-2">Tipo de Servicio:</label>
                                    <select id="service-quote" name="service" class="form-input" required>
                                        <option value="">Por favor, selecciona una opción</option>
                                        <option value="residential_cleaning">Limpieza Residencial</option>
                                        <option value="commercial_cleaning">Limpieza Comercial</option>
                                        <option value="specialized_cleaning">Limpieza Especializada</option>
                                    </select>
                                </div>
                            </div>
                            <div>
                                <label for="message" class="block text-brand-primary text-lg font-bold mb-2">Mensaje / Detalles:</label>
                                <textarea id="message" name="message" rows="5" class="form-input" placeholder="Cuéntanos sobre tus necesidades de limpieza..." required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary w-full mt-6">ENVIAR COTIZACIÓN <i data-lucide="arrow-right" class="text-2xl"></i></button>
                            <div id="form-message" class="mt-4 text-center text-sm font-semibold text-brand-primary hidden"></div>
                        </form>
                    </div>
                </div>
            </section>

            <section class="contact-info-section py-32">
                <div class="max-w-7xl mx-auto" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">Conecta con nosotros</h3>
                    <h2 class="section-title title-light mt-2 text-5xl sm:text-6xl">ATENCIÓN PERSONALIZADA</h2>
                    <p class="text-lg text-gray-700 opacity-90 mb-6">
                        Nuestro equipo está listo para responder a tus preguntas y agendar tu servicio. ¡Tu satisfacción es nuestra prioridad!
                    </p>

                    <div class="contact-cards-container">
                        <div class="contact-card email-card" data-aos="zoom-in" data-aos-delay="100">
                            <i data-lucide="headset" class="icon-large"></i>
                            <div class="text-content">
                                <span class="contact-label">SOPORTE DE VENTAS</span>
                                <a href="mailto:info@cleaningpro.com" class="contact-value">info@cleaningpro.com</a>
                            </div>
                        </div>

                        <div class="contact-card phone-card" data-aos="zoom-in" data-aos-delay="200">
                            <i data-lucide="message-square" class="icon-large"></i>
                            <div class="text-content">
                                <span class="contact-label">CONSULTA GRATIS</span>
                                <a href="https://wa.me/14252434579" target="_blank" class="contact-value">+1 (425) 243-4579</a>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-col sm:flex-row justify-center gap-4 mt-8 md:hidden">
                        <a href="tel:+14252434579" class="btn btn-secondary py-3 px-6 text-lg" role="button">LLAMA AHORA</a>
                        <a href="https://wa.me/14252434579" target="_blank" class="btn btn-secondary py-3 px-6 text-lg" role="button">WHATSAPP</a>
                        <a href="mailto:info@cleaningpro.com" class="btn btn-secondary py-3 px-6 text-lg" role="button">ENVIAR CORREO</a>
                    </div>
                </div>
            </section>
        </main>

        <footer>
            <div class="max-w-7xl mx-auto px-6">
                <div class="footer-logo-container">
                    <img src="img/LogoBlanco.png" alt="Logotipo de Cleaning Pro en pie de página" class="w-20 h-20 object-contain">
                </div>
                <div class="social-links">
                    <a href="#" class="hover:text-brand-secondary transition-colors duration-200 flex items-center gap-2">Facebook</a>
                    <a href="#" class="hover:text-brand-secondary transition-colors duration-200 flex items-center gap-2">Instagram</a>
                    <a href="#" class="hover:text-brand-secondary transition-colors duration-200 flex items-center gap-2">LinkedIn</a>
                </div>
                <?php include 'footer.php'; ?>
            </div>
        </footer>

    </div>

    <button id="openQuoteModalDesktop" class="hidden md:flex bg-brand-red-accent text-white py-6 px-2 rounded-l-xl shadow-lg hover:scale-105 hover:shadow-xl transition-all duration-300 z-50 flex-col items-center justify-center cursor:pointer; border:none; outline:none;" data-aos="fade-left" data-aos-offset="0">
        <span class="font-bold text-lg uppercase">OBTÉN UNA COTIZACIÓN </span>
        <i data-lucide="arrow-right" class="text-3xl mt-2"></i>
    </button>

    <a href="#quote-form" id="fixedBottomQuoteBtn" class="md:hidden fixed bottom-0 left-0 right-0 z-50 bg-brand-secondary text-brand-dark-blue py-4 text-center font-bold text-lg uppercase shadow-lg flex items-center justify-center gap-2">
        SOLICITAR UNA COTIZACIÓN <i data-lucide="arrow-right" class="text-xl"></i>
    </a>

    <div id="quoteModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-end z-[1001]" style="display: none;">
        <div class="bg-white p-8 shadow-2xl w-full relative transform translateX(100%) transition-transform duration-300 ease-out active" id="quoteModalContent">
            <button id="closeQuoteModal" class="absolute top-4 right-4 text-gray-500 hover:text-gray-800 text-3xl font-bold">&times;</button>
            <h3 class="section-subtitle subtitle-light text-2xl">Conecta con nosotros</h3>
            <h2 class="section-title title-light mt-2 text-5xl sm:text-6xl">OBTÉN TU COTIZACIÓN</h2>
            <form id="modal-quote-form" class="space-y-6 w-full">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 w-full">
                    <div>
                        <label for="modal-name" class="block text-brand-primary text-lg font-bold mb-2">Nombre Completo:</label>
                        <input type="text" id="modal-name" name="name" class="form-input" placeholder="Tu nombre" required>
                    </div>
                    <div>
                        <label for="modal-email" class="block text-brand-primary text-lg font-bold mb-2">Correo Electrónico:</label>
                        <input type="email" id="modal-email" name="email" class="form-input" placeholder="tu.correo@ejemplo.com" required>
                    </div>
                    <div>
                        <label for="modal-phone" class="block text-brand-primary text-lg font-bold mb-2">Número de Teléfono:</label>
                        <input type="tel" id="modal-phone" name="phone" class="form-input" placeholder="+1 (XXX) XXX-XXXX" required>
                    </div>
                    <div>
                        <label for="modal-service" class="block text-brand-primary text-lg font-bold mb-2">Tipo de Servicio:</label>
                        <select id="modal-service" name="service" class="form-input" required>
                            <option value="">Por favor, selecciona una opción</option>
                            <option value="residential_cleaning">Limpieza Residencial</option>
                            <option value="commercial_cleaning">Limpieza Comercial</option>
                            <option value="specialized_cleaning">Limpieza Especializada</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label for="modal-message" class="block text-brand-primary text-lg font-bold mb-2">Mensaje / Detalles:</label>
                    <textarea id="modal-message" name="message" rows="5" class="form-input" placeholder="Cuéntanos sobre tus necesidades de limpieza..." required></textarea>
                </div>
                <button type="submit" class="btn btn-primary w-full mt-6">ENVIAR COTIZACIÓN <i data-lucide="arrow-right" class="text-2xl"></i></button>
                <div id="modal-form-message" class="mt-4 text-center text-sm font-semibold text-brand-primary hidden"></div>
            </form>
            
            <div class="contact-cards-container">
                <div class="contact-card email-card" data-aos="zoom-in" data-aos-delay="100">
                    <i data-lucide="headset" class="icon-large"></i>
                    <div class="text-content">
                        <span class="contact-label">SOPORTE DE VENTAS</span>
                        <a href="mailto:info@cleaningpro.com" class="contact-value">info@cleaningpro.com</a>
                    </div>
                </div>
                <div class="contact-card phone-card" data-aos="zoom-in" data-aos-delay="200">
                    <i data-lucide="message-square" class="icon-large"></i>
                    <div class="text-content">
                        <span class="contact-label">CONSULTA GRATIS</span>
                        <a href="https://wa.me/14252434579" target="_blank" class="contact-value">+1 (425) 243-4579</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            AOS.init({
                duration: 800,
                once: true,
                offset: 50,
            });

            // Initialize Lucid Icons
            lucide.createIcons();

            // Mobile Menu Logic
            const openMobileMenuBtn = document.getElementById('openMobileMenu');
            const mobileMenu = document.getElementById('mobileMenu');
            const mobileMenuOverlay = document.getElementById('mobileMenuOverlay');
            const mobileMenuLinks = document.querySelectorAll('.mobile-menu-link');

            function toggleMobileMenu() {
                mobileMenu.classList.toggle('active');
                mobileMenuOverlay.classList.toggle('active');
                document.body.classList.toggle('overflow-hidden');
            }

            openMobileMenuBtn.addEventListener('click', toggleMobileMenu);
            mobileMenuOverlay.addEventListener('click', toggleMobileMenu);

            mobileMenuLinks.forEach(link => {
                link.addEventListener('click', () => {
                    if (mobileMenu.classList.contains('open')) {
                        toggleMobileMenu();
                    }
                });
            });

            // Gallery Logic
            const mainGalleryImage = document.getElementById('main-gallery-image');
            const galleryThumbnails = document.querySelectorAll('.gallery-thumbnail-card');

            galleryThumbnails.forEach(thumbnail => {
                thumbnail.addEventListener('click', () => {
                    galleryThumbnails.forEach(t => t.classList.remove('active'));
                    thumbnail.classList.add('active');
                    mainGalleryImage.src = thumbnail.dataset.src;
                });
            });

            // Form Submission Logic (Main Quote Form)
            const contactForm = document.getElementById('contact-form');
            const formMessage = document.getElementById('form-message');

            if (contactForm) {
                contactForm.addEventListener('submit', function(event) {
                    event.preventDefault();
                    formMessage.textContent = '¡Tu solicitud de cotización ha sido enviada con éxito! Nos pondremos en contacto contigo pronto.';
                    formMessage.classList.remove('hidden');
                    formMessage.classList.add('text-brand-primary');
                    contactForm.reset();
                    setTimeout(() => {
                        formMessage.classList.add('hidden');
                    }, 5000);
                });
            }

            // Quote Modal Logic
            const openQuoteModalDesktopBtn = document.getElementById('openQuoteModalDesktop');
            const openQuoteModalMobileBtn = document.getElementById('openQuoteModalMobile');
            const closeQuoteModalBtn = document.getElementById('closeQuoteModal');
            const quoteModal = document.getElementById('quoteModal');
            const quoteModalContent = document.getElementById('quoteModalContent');

            function openModal() {
                quoteModal.style.display = 'flex';
                setTimeout(() => {
                    quoteModalContent.style.transform = 'translateX(0)';
                    document.body.classList.add('overflow-hidden');
                }, 10);
            }

            function closeModal() {
                quoteModalContent.style.transform = 'translateX(100%)';
                document.body.classList.remove('overflow-hidden');
                setTimeout(() => {
                    quoteModal.style.display = 'none';
                }, 300);
            }

            if (openQuoteModalDesktopBtn) openQuoteModalDesktopBtn.addEventListener('click', openModal);
            if (openQuoteModalMobileBtn) openQuoteModalMobileBtn.addEventListener('click', openModal);
            if (closeQuoteModalBtn) closeQuoteModalBtn.addEventListener('click', closeModal);
            if (quoteModal) {
                quoteModal.addEventListener('click', (event) => {
                    if (event.target === quoteModal) {
                        closeModal();
                    }
                });
            }

            // Modal Quote Form Submission Logic
            const modalQuoteForm = document.getElementById('modal-quote-form');
            const modalFormMessage = document.getElementById('modal-form-message');

            if (modalQuoteForm) {
                modalQuoteForm.addEventListener('submit', function(event) {
                    event.preventDefault();
                    modalFormMessage.textContent = '¡Tu solicitud de cotización ha sido enviada con éxito! Nos pondremos en contacto contigo pronto.';
                    modalFormMessage.classList.remove('hidden');
                    modalFormMessage.classList.add('text-brand-primary');
                    modalQuoteForm.reset();
                    setTimeout(() => {
                        modalFormMessage.classList.add('hidden');
                        closeModal();
                    }, 3000);
                });
            }

            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    let targetElement = document.querySelector(this.getAttribute('href'));
                    if (targetElement) {
                        targetElement.scrollIntoView({
                            behavior: 'smooth'
                        });
                    }
                });
            });

            // Sticky Navbar Logic
            const mainNavbar = document.getElementById('main-navbar');
            if (mainNavbar) {
                const initialNavbarOffset = mainNavbar.offsetTop;
                const navbarHeight = mainNavbar.offsetHeight;

                function handleStickyNavbar() {
                    if (window.pageYOffset > initialNavbarOffset) {
                        mainNavbar.classList.add('sticky-nav');
                        document.body.style.paddingTop = navbarHeight + 'px';
                    } else {
                        mainNavbar.classList.remove('sticky-nav');
                        document.body.style.paddingTop = '0';
                    }
                }
                
                window.addEventListener('scroll', handleStickyNavbar);
                handleStickyNavbar();
            }
        });
    </script>
</body>
</html>