document.addEventListener('DOMContentLoaded', () => {

    // 1. INICIALIZACIÓN DE ANIMACIONES (AOS)
    // ===============================================
    AOS.init({
        duration: 1000,
        once: true,
        mirror: false,
    });

    // 2. LÓGICA DEL MENÚ MÓVIL
    // ===============================================
    const openMobileMenuBtn = document.getElementById('openMobileMenu');
    const mobileMenu = document.getElementById('mobileMenu');
    const mobileMenuOverlay = document.getElementById('mobileMenuOverlay');
    const mobileMenuLinks = document.querySelectorAll('.mobile-menu-link');

    if (openMobileMenuBtn) {
        openMobileMenuBtn.addEventListener('click', function() {
            mobileMenu.classList.add('active');
            mobileMenuOverlay.classList.add('active');
            document.body.classList.add('no-scroll');
        });

        const closeMobileMenu = function() {
            mobileMenu.classList.remove('active');
            mobileMenuOverlay.classList.remove('active');
            document.body.classList.remove('no-scroll');
        };

        mobileMenuOverlay.addEventListener('click', closeMobileMenu);
        mobileMenuLinks.forEach(link => {
            link.addEventListener('click', closeMobileMenu);
        });
    }

    // 3. LÓGICA DE LA GALERÍA INTERACTIVA
    // ===============================================
    const mainGalleryImage = document.getElementById('main-gallery-image');
    const thumbnails = document.querySelectorAll('.gallery-thumbnail-card');

    if (mainGalleryImage && thumbnails.length > 0) {
        thumbnails.forEach(thumbnail => {
            thumbnail.addEventListener('click', function() {
                thumbnails.forEach(t => t.classList.remove('active'));
                this.classList.add('active');
                mainGalleryImage.src = this.dataset.src;
                mainGalleryImage.onerror = function() {
                    this.src = 'https://placehold.co/800x600/07162d/FFFFFF?text=Imagen+No+Disponible';
                };
            });
        });
        if (thumbnails.length > 0) {
            thumbnails[0].classList.add('active');
        }
    }

    // 4. LÓGICA DEL PANEL LATERAL (MODAL)
    // ===============================================
    const openQuoteModalDesktopBtn = document.getElementById('openQuoteModalDesktop');
    const openQuoteModalMobileBtn = document.getElementById('openQuoteModalMobile');
    const quoteModal = document.getElementById('quoteModal');
    const quoteModalContent = document.getElementById('quoteModalContent');
    const closeQuoteModalBtn = document.getElementById('closeQuoteModal');

    if (quoteModal) {
        const openModal = () => {
            quoteModal.classList.add('active');
            if (quoteModalContent) quoteModalContent.classList.add('active');
            document.body.classList.add('no-scroll');
        };

        const closeModal = () => {
            quoteModal.classList.remove('active');
            if (quoteModalContent) quoteModalContent.classList.remove('active');
            document.body.classList.remove('no-scroll');
        };

        if (openQuoteModalDesktopBtn) openQuoteModalDesktopBtn.addEventListener('click', openModal);
        if (openQuoteModalMobileBtn) openQuoteModalMobileBtn.addEventListener('click', openModal);
        if (closeQuoteModalBtn) closeQuoteModalBtn.addEventListener('click', closeModal);

        quoteModal.addEventListener('click', function(event) {
            if (event.target === quoteModal) {
                closeModal();
            }
        });
    }

    // 5. LÓGICA DE ENVÍO DE FORMULARIOS (CONEXIÓN CON PHP)
    // ===============================================
    const contactForm = document.getElementById('contact-form');
    const formMessage = document.getElementById('form-message');
    const modalQuoteForm = document.getElementById('modal-quote-form');
    const modalFormMessage = document.getElementById('modal-form-message');

    const handleFormSubmit = async (event, form, messageElement) => {
        event.preventDefault();
        const formData = new FormData(form);
        const submitButton = form.querySelector('button[type="submit"]');
        const originalButtonText = submitButton.innerHTML;

        submitButton.disabled = true;
        submitButton.innerHTML = 'Enviando...';
        messageElement.classList.add('hidden');

        try {
            const response = await fetch('send_email.php', {
                method: 'POST',
                body: formData
            });
            const data = await response.json();

            messageElement.textContent = data.message;
            messageElement.classList.remove('hidden', 'text-green-500', 'text-red-500');

            if (data.success) {
                messageElement.classList.add('text-green-500');
                form.reset();
            } else {
                messageElement.classList.add('text-red-500');
            }
        } catch (error) {
            messageElement.textContent = 'Error de conexión. Inténtalo más tarde.';
            messageElement.classList.remove('hidden');
            messageElement.classList.add('text-red-500');
            console.error('Error:', error);
        } finally {
            submitButton.disabled = false;
            submitButton.innerHTML = originalButtonText;
        }
    };

    if (contactForm) {
        contactForm.addEventListener('submit', (event) => handleFormSubmit(event, contactForm, formMessage));
    }

    if (modalQuoteForm) {
        modalQuoteForm.addEventListener('submit', (event) => handleFormSubmit(event, modalQuoteForm, modalFormMessage));
    }

    // 6. FORMATO AUTOMÁTICO PARA NÚMERO DE TELÉFONO (NUEVO)
    // =====================================================
    // Selecciona todos los campos de teléfono de la página
    const phoneInputs = document.querySelectorAll('input[type="tel"]');
    
    if (phoneInputs.length > 0) {
        const maskOptions = {
            mask: '(000) 000-0000' // Formato USA (puedes cambiar el guion por espacio si prefieres)
        };
        
        phoneInputs.forEach(function(inputElement) {
            IMask(inputElement, maskOptions);
        });
    }
});


// FUNCIÓN DE VERIFICACIÓN DE PHOSPHOR ICONS (SE EJECUTA AL FINAL)
// =================================================================
function checkPhosphorIconsLoaded() {
    const testElement = document.createElement('i');
    testElement.className = 'ph-bold ph-check';
    testElement.style.position = 'absolute';
    testElement.style.left = '-9999px';
    testElement.style.fontFamily = '"Phosphor Icons"';
    document.body.appendChild(testElement);

    setTimeout(() => {
        const isLoaded = testElement.offsetWidth > 0 || testElement.offsetHeight > 0;
        if (isLoaded) {
            console.log('Phosphor Icons: Fuente cargada correctamente.');
            const debugStyle = document.getElementById('phosphor-debug-style');
            if (debugStyle) debugStyle.remove();
        } else {
            console.warn('Phosphor Icons: La fuente NO parece haberse cargado.');
        }
        document.body.removeChild(testElement);
    }, 100);
}

window.addEventListener('load', checkPhosphorIconsLoaded);