<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tu Sitio Web Profesional - Deja de ser invisible online</title>

   <link rel="icon" href="img/favicon.webp" sizes="any">
    <link rel="icon" href="img/favicon.webp" type="image/svg+xml">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.webp">
    
    <?php require_once 'files/gtm_head.php'; ?>
    
    
    <link rel="canonical" href="https://generamasclientes.com/oferta-web/oferta">

    <meta property="og:title" content="Tu Página Web Profesional para Negocio Local en Estados Unidos">
    <meta property="og:description" content="Deja de ser invisible online. Atrae clientes y genera confianza con una web diseñada para vender.">
    <meta property="og:image" content="https://generamasclientes.com/oferta-web/img/LocalWebPro.webp">
    <meta property="og:url" content="https://generamasclientes.com/oferta-web/index.php">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="LocalWebPro">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Tu Página Web Profesional para Negocio Local en Estados Unidos">
    <meta name="twitter:description" content="Deja de ser invisible online. Atrae clientes y genera confianza con una web diseñada para vender.">
    <meta name="twitter:image" content="https://generamasclientes.com/oferta-web/img/LocalWebPro.webp"> 

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js" defer></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <link rel="stylesheet" href="style.css">
    <script src="script.js"></script>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d', /* Azul Oscuro (Inteligencia) */
                        'brand-secondary': '#9e1428', /* Rojo (Creatividad) */
                        'brand-highlight': '#ffc857', /* Amarillo (Visión) */
                        'brand-light-bg': '#f5f5f5', /* Blanco (Honestidad) */
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a', /* Negro (Prestigio) - para textos principales */
                        'brand-light-text': '#f3f4f6', /* Mantener para textos claros sobre fondos oscuros */
                        'dark-red-bg': '#9e1428', /* Usar Rojo Secundario para fondos específicos */
                        'dark-black-bg': '#07080a', /* Nuevo: Negro (Prestigio) para fondos */
                    },
                    fontFamily: { 'sans': ['Barlow', 'sans-serif'] }
                }
            }
        }
    </script>


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "LocalWebPro - OrozDesign Multimedia",
  "image": "https://generamasclientes.com/oferta-web/img/LocalWebPro.webp",
  "@id": "https://generamasclientes.com",
  "url": "https://generamasclientes.com",
  "telephone": "+1-425-243-4579",
  "priceRange": "$",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Seattle",
    "addressLocality": "Seattle",
    "addressRegion": "WA",
    "postalCode": "98201",
    "addressCountry": "US"
  },
  "description": "Ayudamos a dueños de negocios locales a atraer más clientes y generar confianza con una página web profesional. Ofrecemos diseño web, dominio, hosting y soporte.",
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "opens": "09:00",
    "closes": "17:00"
  },
  "sameAs": [
    "https://www.facebook.com/orozdesign"
  ] 
}
</script>

</head>
<body class="font-sans bg-brand-light-bg text-brand-dark-text overflow-x-hidden">

<?php require_once 'files/gtm_body.php'; ?>


<header id="hero-section"
  class="relative text-white flex items-center justify-center overflow-hidden pt-16 md:pt-20"
  style="
    background-image:
      radial-gradient(900px 420px at 50% 0%, rgba(255,200,87,.08), transparent 60%),
      linear-gradient(rgba(7,22,45,.82), rgba(7,22,45,.82)),
      url('img/BG01.webp?auto=compress&cs=tinysrgb&w=1600&h=900&dpr=1');
    background-size: cover; background-position: center; " loading="lazy">

  <div class="relative z-10 w-full">
    <div class="container mx-auto max-w-5xl px-6 py-20 md:py-28 text-center">

      <p class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 text-brand-highlight font-semibold tracking-widest uppercase ring-1 ring-white/20" data-aos="fade-up" data-aos-delay="60">
        <i data-lucide="alert-circle" class="lucide-icon"></i>
        La oferta especial ha terminado, pero tu oportunidad no
      </p>

      <h1 class="mt-5 font-black uppercase tracking-tight leading-[1.05] text-4xl sm:text-6xl md:text-7xl" data-aos="fade-up" data-aos-delay="140">
        Haz que tu negocio sea visible <span class="text-brand-highlight">con una web profesional</span>
      </h1>

      <p class="mt-5 text-lg md:text-xl text-gray-200 max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="220">
        Obtén tu página web profesional para tu negocio, genera confianza y convierte visitantes en clientes potenciales dispuestos a adquirir tus productos o servicios.
      </p>

      <div class="mt-9 flex justify-center" data-aos="fade-up" data-aos-delay="300">
          <a href="#payment-section-expired" class="inline-flex justify-center items-center gap-2 px-7 py-4 text-base sm:text-lg font-extrabold rounded-xl bg-brand-highlight text-[#07162D] shadow-xl shadow-black/20 ring-2 ring-brand-highlight/60 hover:translate-y-[1px] hover:shadow-lg hover:opacity-95 transition w-full sm:w-auto">
              <i data-lucide="shopping-bag" class="lucide-icon"></i> VER LA OFERTA ACTUAL DE $267
          </a>
      </div>

      <div class="mt-6 flex flex-col sm:flex-row gap-2 sm:gap-4 items-center justify-center text-sm text-gray-300" data-aos="fade-up" data-aos-delay="360">
          <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="lucide-icon"></i> Sin Contratos</span>
          <span class="hidden sm:inline">•</span>
          <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="lucide-icon"></i> Entrega Rápida (72 Horas)</span>
          <span class="hidden sm:inline">•</span>
          <span class="inline-flex items-center gap-1.5"><i data-lucide="trending-up" class="lucide-icon"></i> Diseño Que Vende</span>
      </div>

    </div>
  </div>

  <div class="pointer-events-none absolute inset-x-0 bottom-0 h-24 bg-gradient-to-t from-[#07162D] to-transparent"></div>
</header>

<main>
    
<section id="solucion-advanced" class="relative bg-brand-light-bg py-16 md:py-24 overflow-hidden" data-aos="fade-up">
    <div class="pointer-events-none absolute -top-20 -left-16 w-72 h-72 rounded-full bg-brand-secondary/10 blur-3xl"></div>
    <div class="pointer-events-none absolute -bottom-24 -right-20 w-80 h-80 rounded-full bg-brand-highlight/10 blur-3xl"></div>

    <div class="container mx-auto max-w-7xl px-6">
        <div class="text-center max-w-4xl mx-auto">
            <p class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full
                 bg-brand-highlight/90 text-brand-primary font-semibold tracking-widest uppercase
                 ring-1 ring-brand-primary/10">
                <i data-lucide="radar" class="lucide-icon"></i>
                Proceso simple • Resultados medibles • Sin complicaciones
            </p>
            
            <h2 class="mt-3 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-brand-primary uppercase leading-tight">
                Tu página web profesional <span class="text-brand-secondary">lista en 3 simples pasos</span>
            </h2>

            <div class="mt-6 w-24 h-1.5 mx-auto rounded-full bg-brand-secondary"></div>
            <p class="mt-4 text-base md:text-lg text-brand-dark-text/70">
                Nos encargamos de lo técnico; tú te encargas de atender las solicitudes de clientes potenciales.
            </p>
        </div>

        <div class="mt-12 sm:mt-14 grid grid-cols-1 md:grid-cols-3 gap-6 md:gap-8 lg:gap-10">
      
            <article class="group relative text-center bg-white/95 p-6 sm:p-7 md:p-8 rounded-2xl
                     shadow-sm hover:shadow-xl hover:-translate-y-0.5 transition
                     ring-1 ring-gray-200" data-aos-delay="100">
                <div class="relative mx-auto mb-6 w-20 h-20 rounded-2xl bg-brand-highlight/90 ring-2 ring-brand-highlight/20 flex items-center justify-center">
                    <i data-lucide="file-text" class="lucide-icon-xl text-brand-primary"></i>
                    <span class="absolute -top-2 -left-2 text-xs font-black bg-brand-secondary text-white rounded-full px-2 py-1 uppercase">Paso 1</span>
                </div>
                <h3 class="text-xl sm:text-2xl font-black mb-2 text-brand-dark-text uppercase">
                    Envíanos los datos de tu negocio
                </h3>
                <p class="text-[15px] sm:text-base md:text-lg text-gray-600">
                    Servicios, zonas que atiendes y contacto. Información clave y precisa para iniciar tu proyecto, sin reuniones eternas.
                </p>
            </article>

            <article class="group relative text-center bg-white/95 p-6 sm:p-7 md:p-8 rounded-2xl
                     shadow-sm hover:shadow-xl hover:-translate-y-0.5 transition
                     ring-1 ring-gray-200" data-aos-delay="200">
                <div class="relative mx-auto mb-6 w-20 h-20 rounded-2xl bg-brand-highlight/90 ring-2 ring-brand-highlight/20 flex items-center justify-center">
                    <i data-lucide="monitor-dot" class="lucide-icon-xl text-brand-primary"></i>
                    <span class="absolute -top-2 -left-2 text-xs font-black bg-brand-secondary text-white rounded-full px-2 py-1 uppercase">Paso 2</span>
                </div>
                <h3 class="text-xl sm:text-2xl font-black mb-2 text-brand-dark-text uppercase">
                    Diseñamos tu página web que vende
                </h3>
                <p class="text-[15px] sm:text-base md:text-lg text-gray-600">
                    Aplicamos nuestra estructura probada, mensajes claros y enfoque en conversión para que tu marca inspire confianza.
                </p>
            </article>

            <article class="group relative text-center bg-white/95 p-6 sm:p-7 md:p-8 rounded-2xl
                     shadow-sm hover:shadow-xl hover:-translate-y-0.5 transition
                     ring-1 ring-gray-200" data-aos-delay="300">
                <div class="relative mx-auto mb-6 w-20 h-20 rounded-2xl bg-brand-highlight/90 ring-2 ring-brand-highlight/20 flex items-center justify-center">
                    <i data-lucide="check-circle" class="lucide-icon-xl text-brand-primary"></i>
                    <span class="absolute -top-2 -left-2 text-xs font-black bg-brand-secondary text-white rounded-full px-2 py-1 uppercase">Paso 3</span>
                </div>
                <h3 class="text-xl sm:text-2xl font-black mb-2 text-brand-dark-text uppercase">
                    Publicamos tu web y ganas visibilidad
                </h3>
                <p class="text-[15px] sm:text-base md:text-lg text-gray-600">
                    Tu marca se verá profesional y confiable, y comenzarás a recibir más consultas de clientes potenciales.
                </p>
            </article>
        </div>
    </div>
</section>

<section id="paquete" class="relative py-20 md:py-24 text-brand-light-text overflow-hidden"
  data-aos="fade-up"
  style="background-image: linear-gradient(rgba(7,22,45,.92), rgba(7,22,45,.92)), url('img/BG02.webp'); background-size: cover; background-position: center;">

  <div class="container mx-auto max-w-7xl px-6 relative z-10">
    <div class="flex justify-center">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-brand-highlight/90 text-brand-primary font-bold tracking-widest uppercase
                 ring-1 ring-white/15 text-sm md:text-base text-center">
        <i data-lucide="swords" class="w-4 h-4"></i>
        TU COMPETENCIA NO ESTÁ ESPERANDO. ¿TÚ SÍ?
      </p>
    </div>

    <h3 class="mt-4 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-center text-white uppercase leading-tight max-w-4xl mx-auto">
      La Herramienta Profesional <br class="hidden md:inline" /> <span class="text-brand-highlight">Que Separa a los Negocios Serios del Resto</span>
    </h3>
    
    <div class="mt-10 max-w-3xl mx-auto" data-aos="zoom-in">
      <img src="img/Paquete-Web.webp"
           alt="Paquete LocalWebPro"
           class="rounded-xl w-full h-auto object-cover">
    </div>

    <div class="mt-12 grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-10 max-w-5xl mx-auto">
      <ul class="space-y-6 text-base sm:text-lg">
        <li class="flex items-start gap-4">
          <i data-lucide="check" class="w-6 h-6 text-green-400 mt-1"></i>
          <div>
            <strong class="text-white">Redacción Estratégica Que Vende:</strong>
            <p class="text-gray-300">Textos diseñados para una sola cosa: convertir visitantes en llamadas.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="check" class="w-6 h-6 text-green-400 mt-1"></i>
          <div>
            <strong class="text-white">Dominio Profesional Con Tu Nombre:</strong>
            <p class="text-gray-300">La base para que te vean como un negocio serio, no como un aficionado.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="check" class="w-6 h-6 text-green-400 mt-1"></i>
          <div>
            <strong class="text-white">Alojamiento Rápido y Compartido:</strong>
            <p class="text-gray-300">Velocidad y seguridad para no perder ni un solo cliente potencial.</p>
          </div>
        </li>
      </ul>

      <ul class="space-y-6 text-base sm:text-lg">
        <li class="flex items-start gap-4">
          <i data-lucide="check" class="w-6 h-6 text-green-400 mt-1"></i>
          <div>
            <strong class="text-white">Certificado SSL De Seguridad:</strong>
            <p class="text-gray-300">El "candado" que genera confianza inmediata en tus visitantes.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="check" class="w-6 h-6 text-green-400 mt-1"></i>
          <div>
            <strong class="text-white">Diseño 100% Responsive:</strong>
            <p class="text-gray-300">Perfecto en celulares, donde el 90% de tus clientes te buscarán.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="check" class="w-6 h-6 text-green-400 mt-1"></i>
          <div>
            <strong class="text-white">Acompañamiento y Soporte Técnico:</strong>
            <p class="text-gray-300">No estás solo. Te guiamos para asegurar que tu inversión funcione.</p>
          </div>
        </li>
      </ul>
    </div>

    <div class="mt-12 text-center">
      <a href="#payment-section-expired"
         class="inline-flex items-center justify-center gap-2 px-8 py-4 text-lg font-extrabold rounded-2xl
                bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/30
                hover:opacity-95 hover:translate-y-[1px] transition">
        ADQUIRIR EL PAQUETE PROFESIONAL <i data-lucide="arrow-right" class="w-5 h-5"></i>
      </a>
      <p class="mt-3 text-sm text-gray-300 flex flex-wrap items-center justify-center gap-x-3 gap-y-1">
        <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4"></i> Sin Contratos</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="w-4 h-4"></i> Entrega Rápida (72 Horas)</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5 font-bold"><i data-lucide="tag" class="w-4 h-4"></i> INVERSIÓN: $267</span>
      </p>
    </div>
  </div>
</section>

<section id="qualification-section" class="py-20 md:py-24 bg-white" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6">

    <div class="text-center max-w-4xl mx-auto">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-brand-secondary/90 text-brand-highlight font-bold tracking-widest uppercase
                 ring-1 ring-brand-highlight/30 shadow-sm text-sm md:text-base">
        <i data-lucide="target" class="w-4 h-4 md:w-5 md:h-5"></i>
        Atención: No todos califican para esto
      </p>

      <h2 class="mt-4 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-brand-primary uppercase leading-tight">
        Una web profesional: la diferencia entre un <span class="text-brand-secondary">negocio invisible y uno respetado</span>
      </h2>

      <p class="text-base sm:text-lg md:text-xl mt-4 text-gray-600 font-medium">
        Somos brutalmente honestos: esta solución es para quienes entienden que su presencia online es el reflejo directo de la calidad de su trabajo.
      </p>
    </div>

    <div class="mt-12 md:mt-16 grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-10">

      <article class="p-7 md:p-8 rounded-2xl bg-green-50 ring-1 ring-green-200 shadow-md hover:shadow-lg transition"
               data-aos="fade-right">
        <div class="flex items-center gap-3">
          <i data-lucide="check-circle-2" class="w-7 h-7 text-green-600"></i>
          <h3 class="text-2xl md:text-3xl font-black text-green-800 uppercase">Esto SÍ es para ti si…</h3>
        </div>

        <ul class="mt-6 space-y-5 text-base sm:text-lg md:text-lg text-gray-700 font-medium">
          <li class="flex items-start gap-3">
            <i data-lucide="check" class="w-5 h-5 mt-1 text-green-600"></i>
            <span>SI… Estás <b>harto de ser invisible</b> y listo para que los clientes te encuentren y te tomen en serio.</span>
          </li>
          <li class="flex items-start gap-3">
            <i data-lucide="check" class="w-5 h-5 mt-1 text-green-600"></i>
            <span>SI… <b>Exiges resultados</b> y buscas una herramienta directa que trabaje para ti, no en tu contra.</span>
          </li>
          <li class="flex items-start gap-3">
            <i data-lucide="check" class="w-5 h-5 mt-1 text-green-600"></i>
            <span>SI… Entiendes que una web profesional no es un "gasto", es la <b>inversión clave</b> para cobrar lo que vales.</span>
          </li>
          <li class="flex items-start gap-3">
            <i data-lucide="check" class="w-5 h-5 mt-1 text-green-600"></i>
            <span>SI… Valoras tu tiempo y prefieres <b>enfocarte en tu negocio</b> mientras un experto construye tu activo digital.</span>
          </li>
        </ul>
      </article>

      <article class="p-7 md:p-8 rounded-2xl bg-red-50 ring-1 ring-red-200 shadow-md hover:shadow-lg transition"
               data-aos="fade-left">
        <div class="flex items-center gap-3">
          <i data-lucide="x-octagon" class="w-7 h-7 text-red-600"></i>
          <h3 class="text-2xl md:text-3xl font-black text-red-800 uppercase">Esto NO es para ti si…</h3>
        </div>

        <ul class="mt-6 space-y-5 text-base sm:text-lg md:text-lg text-gray-700 font-medium">
          <li class="flex items-start gap-3">
            <i data-lucide="x" class="w-5 h-5 mt-1 text-red-600"></i>
            <span>SI… Buscas un <b>"botón mágico"</b> para hacerte rico sin mostrar tu negocio de forma profesional.</span>
          </li>
          <li class="flex items-start gap-3">
            <i data-lucide="x" class="w-5 h-5 mt-1 text-red-600"></i>
            <span>SI… Tu mentalidad es de <b>"gasto" en lugar de "inversión"</b> y buscas la opción más barata posible.</span>
          </li>
          <li class="flex items-start gap-3">
            <i data-lucide="x" class="w-5 h-5 mt-1 text-red-600"></i>
            <span>SI… No estás comprometido a <b>responder las nuevas solicitudes</b> de clientes que tu web va a generar.</span>
          </li>
          <li class="flex items-start gap-3">
            <i data-lucide="x" class="w-5 h-5 mt-1 text-red-600"></i>
            <span>SI… Prefieres <b>seguir en el caos de la improvisación</b>, esperando que los clientes caigan del cielo.</span>
          </li>
        </ul>
      </article>
    </div>

    <div class="mt-12 flex flex-col sm:flex-row gap-4 justify-center" data-aos="fade-up">
      <a href="#payment-section-expired"
         class="inline-flex justify-center items-center gap-2 px-7 py-4 text-lg font-extrabold rounded-2xl
                bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/20
                hover:opacity-95 hover:translate-y-[1px] transition w-full sm:w-auto">
        <i data-lucide="thumbs-up" class="w-5 h-5"></i> SÍ, ESTOY LISTO PARA SER VISIBLE
      </a>
    </div>
        <p class="mt-3 text-sm text-black flex flex-wrap items-center justify-center gap-x-3 gap-y-1">
        <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4"></i> Sin Contratos</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="w-4 h-4"></i> Entrega Rápida (72 Horas)</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5 font-bold"><i data-lucide="tag" class="w-4 h-4"></i> INVERSIÓN: $267</span>
      </p>
  </div>
</section>

<section id="price-stack" class="relative py-20 md:py-24 bg-brand-primary overflow-hidden" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6 relative">

    <div class="text-center mb-12 md:mb-16">
      <span class="inline-flex items-center gap-2 px-5 py-2 rounded-full bg-brand-highlight text-brand-primary font-black tracking-widest ring-1 ring-brand-highlight/40 shadow-sm text-xs sm:text-sm">
        <i data-lucide="calculator" class="w-4 h-4"></i>
        LOS NÚMEROS NO MIENTEN: ESTA ES UNA INVERSIÓN, NO UN GASTO
      </span>
      
      <h2 class="mt-6 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-white leading-tight uppercase">
        Tu paquete web profesional: <br /><span class="text-brand-highlight">valor real vs. tu inversión</span>
      </h2>

      <p class="max-w-3xl mx-auto mt-2 text-sm sm:text-base md:text-lg text-gray-300 font-bold">
        Esto es lo que realmente cuesta cada componente para construir una presencia digital que genera clientes.
      </p>
    </div>

    <div class="grid gap-10 lg:grid-cols-2 items-start">

      <div class="relative">
        <span class="hidden sm:block absolute -top-6 -right-2 rotate-6 select-none">
          <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-brand-highlight text-brand-primary ring-2 ring-yellow-300/60 font-black shadow">
            <i data-lucide="badge-dollar-sign" class="w-5 h-5"></i> TE AHORRAS $1,633
          </span>
        </span>

        <div class="bg-white rounded-3xl shadow-2xl ring-1 ring-gray-200 overflow-hidden">
          <div class="bg-slate-50 px-6 sm:px-8 md:px-10 py-5">
            <p class="text-base sm:text-lg font-black text-slate-800">Paquete Profesional – LocalWebPro</p>
          </div>
          <div class="h-3 bg-[radial-gradient(circle,_transparent_2px,_#ffffff_2px)] [background-size:12px_12px]"></div>
          
          <div class="px-6 sm:px-8 md:px-10 py-6 space-y-5">
            <div class="grid grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed">
              <div>
                <strong class="text-lg md:text-xl text-brand-dark-text font-black">Diseño Web Profesional</strong>
                <em class="block text-sm md:text-base text-gray-500">Para que te vean como la autoridad en tu sector.</em>
              </div>
              <span class="text-right text-base md:text-lg font-black text-slate-700">Valor De $1,200</span>
            </div>
            <div class="grid grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed">
              <div>
                <strong class="text-lg md:text-xl text-brand-dark-text font-black">Textos Que Venden (Copy)</strong>
                <em class="block text-sm md:text-base text-gray-500">Para convertir curiosos en clientes que pagan.</em>
              </div>
              <span class="text-right text-base md:text-lg font-black text-slate-700">Valor De $500</span>
            </div>
            <div class="grid grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed">
              <div>
                <strong class="text-lg md:text-xl text-brand-dark-text font-black">Dominio .com (1 Año)</strong>
                <em class="block text-sm md:text-base text-gray-500">Tu dirección profesional en internet.</em>
              </div>
              <span class="text-right text-base md:text-lg font-black text-slate-700">Valor De $25</span>
            </div>
            <div class="grid grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed">
              <div>
                <strong class="text-lg md:text-xl text-brand-dark-text font-black">Alojamiento Web (1 Año)</strong>
                <em class="block text-sm md:text-base text-gray-500">Velocidad y disponibilidad 24/7.</em>
              </div>
              <span class="text-right text-base md:text-lg font-black text-slate-700">Valor de $120</span>
            </div>
            <div class="grid grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed">
              <div>
                <strong class="text-lg md:text-xl text-brand-dark-text font-black">Certificado SSL</strong>
                <em class="block text-sm md:text-base text-gray-500">Seguridad que genera confianza.</em>
              </div>
              <span class="text-right text-base md:text-lg font-black text-slate-700">Valor De $75</span>
            </div>
          </div>
          <div class="h-3 bg-[radial-gradient(circle,_transparent_2px,_#ffffff_2px)] [background-size:12px_12px]"></div>
        </div>
      </div>

      <aside class="lg:sticky top-24">
        <div class="relative bg-brand-primary text-white rounded-3xl p-6 sm:p-8 shadow-2xl ring-1 ring-brand-primary/40 text-center">
          <p class="mt-2 text-xs sm:text-sm font-black text-slate-300">VALOR TOTAL REAL DEL PAQUETE</p>
          <p class="text-4xl sm:text-5xl md:text-6xl font-black text-slate-500 line-through decoration-red-500 decoration-4 my-1">$1,900 USD</p>

          <p class="mt-4 text-xs sm:text-sm font-black text-slate-300">TU AHORRO INMEDIATO HOY</p>
          <p class="text-5xl sm:text-6xl md:text-7xl font-black text-green-400">$1,633 USD</p>

          <p class="mt-6 text-lg sm:text-xl font-black text-brand-highlight">TU ÚNICA INVERSIÓN</p>
          <p class="text-6xl sm:text-7xl md:text-8xl font-black text-white my-3">$267</p>

          <a href="#payment-section-expired"
             class="inline-flex w-full justify-center items-center gap-2 px-8 py-4 text-lg font-black rounded-2xl bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/20 hover:opacity-95 hover:translate-y-[1px] transition tracking-widest">
            SÍ, QUIERO INVERTIR $267 AHORA <i data-lucide="rocket" class="w-5 h-5"></i>
          </a>

          <p class="mt-4 text-sm font-bold text-red-300">
            Este precio podría aumentar en cualquier momento. Asegura tu inversión hoy.
          </p>
        </div>
      </aside>
    </div>
  </div>
</section>
        
<section id="social-proof" class="py-20 md:py-24 bg-white" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6">

    <div class="text-center max-w-4xl mx-auto">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-brand-secondary/90 text-brand-highlight font-bold tracking-widest uppercase
                 ring-1 ring-brand-highlight/30 shadow-sm text-sm md:text-base">
        <i data-lucide="users" class="w-4 h-4 md:w-5 md:h-5"></i>
        La prueba definitiva: Resultados, no palabras
      </p>
      <h2 class="mt-4 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-brand-primary uppercase leading-tight">
        ¿Por qué ellos sí dieron el paso (y ya están viendo resultados)?
      </h2>
      <div class="mt-4 flex flex-wrap items-center justify-center gap-3 text-xs sm:text-sm text-gray-500">
        <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4"></i> Proyectos Reales</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="check-circle-2" class="w-4 h-4"></i> Sitios Activos</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="trophy" class="w-4 h-4"></i> Alta Satisfacción</span>
      </div>
    </div>

    <div class="mt-12 md:mt-16 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">

      <article class="group bg-gray-50 rounded-2xl shadow-lg ring-1 ring-gray-200 overflow-hidden flex flex-col" data-aos="fade-up">
        <a href="https://raudalesenterprise.com/" target="_blank" rel="noopener noreferrer">
          <div class="relative">
            <img src="img/RaudalesEnterprises.webp" alt="Página Web de Raudales Enterprise" class="w-full h-48 object-cover object-top">
            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition"></div>
            <span class="absolute top-40 left-1/2 -translate-x-1/2 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
               CLIENTE SATISFECHO
            </span>
          </div>
        </a>
        <div class="p-6 flex flex-col flex-grow text-center">
          <div class="flex items-center justify-center gap-2 text-black text-sm">
            <i data-lucide="map-pin" class="w-4 h-4 text-gray-400"></i> Canadá
            <span class="mx-2 text-gray-300">•</span>
            <span class="inline-flex items-center gap-0.5 text-brand-highlight" aria-label="Calificación 5 de 5">
              <i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i>
            </span>
          </div>
          <h3 class="mt-2 text-2xl font-black text-brand-dark-text">Raudales Enterprise</h3>
          <p class="text-xs font-semibold text-brand-secondary tracking-wide mt-1">Constructora Empresarial</p>
          <blockquote class="text-gray-700 italic my-4 flex-grow">“El profesionalismo que ahora proyectamos nos ha abierto puertas. El proceso fue simple y el resultado, impecable.”</blockquote>
          <a href="https://raudalesenterprise.com/" target="_blank" rel="noopener noreferrer" class="btn btn-primary mt-2 text-sm w-full">
            Explorar su Sitio Web <i data-lucide="arrow-up-right" class="w-4 h-4 ml-2"></i>
          </a>
        </div>
      </article>

      <article class="group bg-gray-50 rounded-2xl shadow-lg ring-1 ring-gray-200 overflow-hidden flex flex-col" data-aos="fade-up" data-aos-delay="100">
        <a href="https://totalrenovationsservice.com/demo/" target="_blank" rel="noopener noreferrer">
          <div class="relative">
            <img src="img/TotalRenovations.webp" alt="Página Web de Total Renovations" class="w-full h-48 object-cover object-top">
            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition"></div>
            <span class="absolute top-40 left-1/2 -translate-x-1/2 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
               CLIENTE SATISFECHO
            </span>
          </div>
        </a>
        <div class="p-6 flex flex-col flex-grow text-center">
          <div class="flex items-center justify-center gap-2 text-black text-sm">
            <i data-lucide="map-pin" class="w-4 h-4 text-gray-400"></i> Texas
            <span class="mx-2 text-gray-300">•</span>
            <span class="inline-flex items-center gap-0.5 text-brand-highlight" aria-label="Calificación 5 de 5">
              <i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i>
            </span>
          </div>
          <h3 class="mt-2 text-2xl font-black text-brand-dark-text">Total Renovations</h3>
          <p class="text-xs font-semibold text-brand-secondary tracking-wide mt-1">Empresa de Remodelación</p>
          <blockquote class="text-gray-700 italic my-4 flex-grow">“Nuestra nueva página nos hace ver como la empresa seria que somos. Los clientes ahora llegan con mucha más confianza.”</blockquote>
          <a href="https://totalrenovationsservice.com/demo/" target="_blank" rel="noopener noreferrer" class="btn btn-primary mt-2 text-sm w-full">
            Explorar su Sitio Web <i data-lucide="arrow-up-right" class="w-4 h-4 ml-2"></i>
          </a>
        </div>
      </article>

      <article class="group bg-gray-50 rounded-2xl shadow-lg ring-1 ring-gray-200 overflow-hidden flex flex-col" data-aos="fade-up" data-aos-delay="200">
        <a href="https://truemomentsflowers.com" target="_blank" rel="noopener noreferrer">
          <div class="relative">
            <img src="img/TrueMoments.webp" alt="Página Web de True Moments Flowers" class="w-full h-48 object-cover object-top">
            <div class="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent opacity-0 group-hover:opacity-100 transition"></div>
            <span class="absolute top-40 left-1/2 -translate-x-1/2 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
               CLIENTE SATISFECHO
            </span>
          </div>
        </a>
        <div class="p-6 flex flex-col flex-grow text-center">
          <div class="flex items-center justify-center gap-2 text-black text-sm">
            <i data-lucide="map-pin" class="w-4 h-4 text-gray-400"></i> Texas
            <span class="mx-2 text-gray-300">•</span>
            <span class="inline-flex items-center gap-0.5 text-brand-highlight" aria-label="Calificación 5 de 5">
              <i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i><i data-lucide="star" class="w-4 h-4 fill-current"></i>
            </span>
          </div>
          <h3 class="mt-2 text-2xl font-black text-brand-dark-text">True Moments Flowers</h3>
          <p class="text-xs font-semibold text-brand-secondary tracking-wide mt-1">Floristería y Eventos</p>
          <blockquote class="text-gray-700 italic my-4 flex-grow">“No sabía por dónde empezar. Me guiaron en todo y el resultado final superó mis expectativas. ¡Me encanta!”</blockquote>
          <a href="https://truemomentsflowers.com/" target="_blank" rel="noopener noreferrer" class="btn btn-primary mt-2 text-sm w-full">
            Explorar su Sitio Web <i data-lucide="arrow-up-right" class="w-4 h-4 ml-2"></i>
          </a>
        </div>
      </article>
      
    </div>
  </div>
</section>


<section id="testimonials-section" class="py-16 md:py-24 bg-brand-primary">
  <div class="container mx-auto max-w-7xl px-4 sm:px-6">
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">

      <div class="video-container" data-aos="fade-right">
        <div class="relative h-0 pb-[56.25%] rounded-2xl sm:rounded-3xl overflow-hidden shadow-2xl ring-1 ring-white/10">
          <div class="pointer-events-none absolute inset-0 rounded-2xl sm:rounded-3xl ring-2 sm:ring-4 ring-brand-highlight/80"></div>

          <iframe
            class="absolute top-0 left-0 w-full h-full"
            src="https://www.youtube.com/embed/nJz7fgflh-E"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
            allowfullscreen></iframe>

          <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
        </div>

        <div class="mt-6 grid grid-cols-3 gap-3 text-center">
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="50">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">5.0</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Satisfacción</p>
          </div>
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="100">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">+250</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Proyectos</p>
          </div>
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="150">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">16 AÑOS</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Experiencia</p>
          </div>
        </div>
      </div>

      <div class="text-content text-brand-white" data-aos="fade-left" data-aos-delay="100">
        <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-brand-highlight/90 text-brand-primary font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-sm md:text-base">
          <i data-lucide="award" class="w-4 h-4"></i>
          Ayudamos a negocios como el tuyo a crecer en internet
        </div>

        <h2 class="text-3xl sm:text-4xl md:text-5xl font-black uppercase text-white leading-[1.05]">
          Mensajes de dueños de negocios que confiaron en nosotros
        </h2>
        <span class="block mt-3 h-1.5 w-16 rounded-full bg-brand-secondary"></span>

        <p class="mt-6 text-base sm:text-lg text-white/80">
          Nada mejor que escuchar a quienes ya han trabajado con nosotros. Nuestros clientes confían en nuestro compromiso, cumplimiento y el apoyo que brindamos a quienes están iniciando en el mundo digital.
        </p>

        <div class="mt-6 flex flex-wrap items-center gap-x-4 gap-y-2 text-xs text-white/70">
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="shield-check" class="w-4 h-4 text-brand-highlight"></i> Garantía Cero Riesgos
          </span>
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="badge-check" class="w-4 h-4 text-brand-highlight"></i> Resultados Verificados
          </span>
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="thumbs-up" class="w-4 h-4 text-brand-highlight"></i> Clientes Recurrentes
          </span>
        </div>
      </div>

    </div>
  </div>
</section> 

<section id="oferta-irresistible" class="py-20 md:py-24 bg-brand-light-bg">
  <div class="container mx-auto max-w-4xl px-4 sm:px-6">

    <div class="bg-white rounded-2xl shadow-2xl border-t-8 border-brand-secondary p-6 sm:p-8 md:p-12" data-aos="fade-up">

      <div class="text-center">
        <div class="flex flex-col items-center gap-3 mb-3">
          <i data-lucide="shield-check" class="w-14 h-14 md:w-16 md:h-16 text-brand-secondary"></i>
          <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-brand-dark-text uppercase leading-tight">
            Nuestra garantía de cero riesgo para tu tranquilidad
            <span class="block text-xl sm:text-2xl md:text-3xl font-extrabold text-gray-600 normal-case mt-1">
              (La Que NADIE Más Puede Ofrecerte)
            </span>
          </h2>
        </div>

        <div class="mt-4 w-24 h-1.5 mx-auto rounded-full bg-brand-highlight"></div>

        <p class="text-base sm:text-lg md:text-xl text-gray-600 max-w-2xl mx-auto mt-6">
          Entendemos la desconfianza por malas experiencias. Por eso, en lugar de pedirte que confíes en nuestras palabras, te pedimos que confíes en tus propios ojos.
        </p>

        <div class="mt-8 grid grid-cols-1 md:grid-cols-3 gap-5 items-stretch">
          <div class="relative bg-slate-50 rounded-2xl ring-2 ring-brand-secondary/60 p-6 flex flex-col justify-center shadow-xl">
            <span class="absolute -top-4 left-1/2 -translate-x-1/2 px-4 py-1.5 rounded-full bg-brand-secondary text-white text-sm font-bold shadow">
              PAGO INICIAL
            </span>
            <p class="text-7xl sm:text-8xl font-black text-brand-secondary leading-none mt-4">$67</p>
            <p class="text-lg font-semibold text-brand-secondary/80 mt-2">Para Iniciar Hoy</p>
            <p class="text-sm text-slate-600 mt-3">Con esto, nos ponemos a trabajar y asumimos todo el riesgo.</p>
          </div>

          <div class="hidden md:flex items-center justify-center">
            <div class="flex flex-col items-center gap-2">
              <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-highlight/90 text-brand-primary font-bold ring-1 ring-brand-highlight/30 text-xs">
                SIN RIESGOS PARA TI
              </span>
              <i data-lucide="arrow-right" class="w-6 h-6 text-brand-primary"></i>
            </div>
          </div>

          <div class="bg-slate-50 rounded-2xl ring-1 ring-slate-200 p-6 flex flex-col justify-center">
            <p class="text-sm font-bold text-slate-500">SI TE ENCANTA</p>
            <p class="text-5xl sm:text-6xl font-black text-brand-primary leading-none mt-1">$200</p>
            <p class="text-sm text-slate-600 mt-2">Solo si estás 100% satisfecho con el resultado final.</p>
          </div>
        </div>

        <div class="mt-8 bg-emerald-50 text-emerald-900 ring-1 ring-emerald-200 rounded-2xl max-w-3xl mx-auto p-6 text-left">
          <ol class="space-y-5">
            <li class="flex items-start gap-3">
              <div>
                <h3 class="font-black text-lg md:text-xl uppercase">Paso 1: Asumimos todo el trabajo y el riesgo</h3>
                <p class="text-base md:text-lg text-emerald-900/90">
                  Con tu pago inicial de $67, nuestro equipo construye tu página web profesional completa.
                </p>
              </div>
            </li>
            <li class="flex items-start gap-3">
              <div>
                <h3 class="font-black text-lg md:text-xl uppercase">Paso 2: Tú decides si nuestro trabajo vale la pena</h3>
                <p class="text-base md:text-lg text-emerald-900/90">
                  La revisas y si te encanta, <b>liquidas los $200 restantes</b>. Si no, no pagas un centavo más.
                </p>
              </div>
            </li>
          </ol>
        </div>

        <div class="mt-8">
          <a href="#payment-section-expired"
             class="inline-flex w-full sm:w-auto justify-center items-center gap-2 px-8 py-4 text-lg font-extrabold rounded-2xl
                    bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/20
                    hover:opacity-95 hover:translate-y-[1px] transition">
            ¡SÍ, QUIERO EMPEZAR CON $67!
            <i data-lucide="arrow-right" class="w-5 h-5"></i>
          </a>

          <div class="mt-4 flex flex-wrap items-center justify-center gap-3 text-xs sm:text-sm text-gray-500">
            <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4"></i> Pago Seguro</span>
            <span class="inline-flex items-center gap-1.5"><i data-lucide="hand-coins" class="w-4 h-4"></i> Sin Sorpresas Ni Cargos Ocultos</span>
            <span class="inline-flex items-center gap-1.5"><i data-lucide="check-circle-2" class="w-4 h-4"></i> Tú Apruebas Antes De Pagar El Resto</span>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="payment-section-expired" class="py-16 md-py-24 bg-white" data-aos="fade-up">
  <div class="container mx-auto max-w-6xl px-4 sm:px-6">

    <div class="text-center max-w-4xl mx-auto">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-brand-highlight/90 text-brand-primary font-bold tracking-widest uppercase
                 ring-1 ring-brand-highlight/30 shadow-sm text-sm md:text-base">
        <i data-lucide="shopping-bag" class="w-4 h-4 md:w-5 md:h-5"></i>
        Estás a punto de tomar la decisión correcta
      </p>

      <h2 class="mt-4 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-brand-primary uppercase leading-tight">
        El último paso para dejar de ser invisible y tener tu página web
      </h2>

      <div class="mt-6 w-24 h-1.5 mx-auto rounded-full bg-brand-secondary"></div>
    </div>

    <div class="mt-14 grid lg:grid-cols-2 gap-10 md:gap-12 items-start">

      <div class="bg-gray-50 p-6 md:p-8 rounded-2xl ring-1 ring-gray-200" data-aos="fade-right">
        <h3 class="text-2xl md:text-3xl font-black text-brand-dark-text uppercase mb-6">Resumen de tu inversión:</h3>

        <div class="space-y-5">
          <div class="flex items-start gap-3">
            <i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i>
            <div>
              <p class="text-lg font-bold text-brand-dark-text">Construcción De Tu Página Web Completa</p>
              <p class="text-gray-600">Diseñada para convertir visitas en clientes, optimizada para móviles.</p>
            </div>
          </div>
          <div class="flex items-start gap-3">
            <i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i>
            <div>
              <p class="text-lg font-bold text-brand-dark-text">Garantía De Cero Riesgo</p>
              <p class="text-gray-600">Ves el resultado primero. Solo pagas el resto si estás satisfecho.</p>
            </div>
          </div>
          <div class="flex items-start gap-3">
            <i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i>
            <div>
              <p class="text-lg font-bold text-brand-dark-text">Crédito Aplicado De $67</p>
              <p class="text-gray-600">Este anticipo se descuenta del precio final de $267</p>
            </div>
          </div>
        </div>

        <div class="mt-7 grid grid-cols-1 sm:grid-cols-2 gap-4">
          <div class="relative bg-white rounded-2xl ring-2 ring-brand-secondary/60 p-6 text-center shadow-lg">
            <span class="absolute -top-3 left-1/2 -translate-x-1/2 px-3 py-1 rounded-full
                         bg-brand-secondary text-white text-xs font-black uppercase shadow">
              Hoy Inviertes
            </span>
            <p class="text-6xl md:text-7xl font-black text-brand-secondary leading-none mt-2">$67</p>
            <p class="text-sm font-semibold text-brand-secondary/80 mt-2 uppercase">Pago Inicial</p>
            <p class="text-xs text-slate-500 mt-2">Adquiere Tu Página Web Ahora Mismo</p>
          </div>

          <div class="bg-white rounded-2xl ring-1 ring-gray-200 p-6 text-center">
            <p class="text-5xl font-black text-brand-primary leading-none">$200</p>
            <p class="text-sm font-semibold text-gray-500 mt-2 uppercase">Resto Al Aprobar</p>
            <p class="text-xs text-slate-500 mt-2">Solo Si Estás Satisfecho</p>
          </div>
        </div>
      </div>

      <div class="bg-white p-6 md:p-8 items-center rounded-2xl shadow-2xl ring-1 ring-gray-200" data-aos="fade-left">
        <p class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full
                   bg-brand-secondary/90 text-brand-highlight font-bold uppercase tracking-widest
                   ring-1 ring-brand-highlight/30 text-xs">
          <i data-lucide="bolt" class="w-4 h-4"></i> Completa tu pago en 60 segundos
        </p>
        <h3 class="mt-3 text-2xl md:text-3xl font-black text-brand-dark-text uppercase text-center">
          Finaliza tu pago 100% seguro
        </h3>

        <div class="mt-6 flex flex-col space-y-4">
          <a href="pago-normal?p=card" target="_blank"
             class="inline-flex items-center justify-center gap-3 w-full py-4 text-xl font-extrabold rounded-2xl
                    bg-brand-primary text-white hover:opacity-95 hover:translate-y-[1px] transition shadow-lg">
            <i data-lucide="credit-card" class="w-6 h-6"></i>
            PAGAR $67 CON TARJETA
          </a>
          <a href="pago-normal?p=paypal" target="_blank"
             class="inline-flex items-center justify-center gap-3 w-full py-4 text-xl font-extrabold rounded-2xl
                    bg-blue-600 hover:bg-blue-700 text-white transition shadow-lg">
            <i data-lucide="check-circle" class="w-6 h-6"></i>
            PAGAR $67 CON PAYPAL
          </a>
        </div>

        <div class="mt-8 bg-brand-primary/5 ring-1 ring-brand-primary/20 rounded-xl p-5 text-center">
          <p class="text-base md:text-lg font-black text-brand-secondary uppercase">
            NUESTRA GARANTÍA <b>VER PARA CREER</b>
          </p>
          <p class="text-sm md:text-base text-gray-600 mt-1">
            Tu inversión está protegida. Tomas la decisión final solo cuando veas el trabajo terminado. <b>EL RIESGO ES 100% NUESTRO.</b>
          </p>
        </div>
      </div>
    </div>
  </div>
</section>

<div id="exit-intent-popup" class="hidden fixed inset-0 z-[100]">
  <div id="popup-overlay" class="absolute inset-0 bg-brand-primary backdrop-blur-md opacity-0 transition-opacity duration-300"></div>

  <div class="relative h-full w-full flex items-center justify-center p-4">
    <div id="popup-card"
         role="dialog"
         aria-modal="true"
         aria-labelledby="exit-popup-title"
         class="bg-brand-primary rounded-2xl sm:rounded-3xl shadow-2xl w-full max-w-5xl grid md:grid-cols-2 overflow-hidden 
                transform transition-all duration-300 scale-95 opacity-0">

      <div class="hidden md:block relative">
        <img src="img/Espera.webp"
             alt="Seguro Que Quieres Salir"
             class="w-full h-full object-cover" loading="lazy">
        <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
      </div>

      <div class="p-6 sm:p-8 md:p-12 text-center flex flex-col justify-center relative text-white">
        <button id="close-popup"
                class="absolute top-3 right-3 sm:right-4 h-10 w-10 rounded-full flex items-center justify-center text-white/70 hover:text-white hover:bg-white/10 transition"
                aria-label="Cerrar ventana emergente">
          &times;
        </button>

        <span class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-brand-highlight/20 text-brand-highlight font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-[11px] sm:text-xs mx-auto mb-4">
          <i data-lucide="alert-circle" class="w-4 h-4"></i>
          ¿Seguro que quieres irte?
        </span>

        <h2 id="exit-popup-title" class="text-2xl sm:text-3xl lg:text-4xl font-black uppercase leading-tight">
          ¡Espera!<br><span class="text-brand-highlight">Tu Competencia</span><br>Quiere Que Te Vayas
        </h2>

        <div class="my-6 bg-white/5 ring-1 ring-white/10 rounded-2xl py-4 sm:py-6 px-4">
          <p class="text-base sm:text-lg text-white/80">ÚLTIMA OPORTUNIDAD: Pon tu negocio en el mapa con un pago inicial de solo:</p>
          
          <p class="text-6xl sm:text-7xl font-black text-brand-highlight my-2">$67</p>

          <p class="text-base sm:text-lg text-green-400 font-semibold flex flex-col justify-center items-center gap-1">
            <span>Y PAGAS EL RESTO ($200)</span>
            <span>SOLO SI TE ENCANTA EL RESULTADO</span>
          </p>
        </div>

        <div class="space-y-3">
          <a href="pago-normal?p=card" target="_blank"
             class="btn btn-primary w-full text-base sm:text-lg md:text-xl flex items-center justify-center gap-3 py-4 rounded-2xl shadow-lg hover:shadow-xl transition">
            <i data-lucide="credit-card" class="w-6 h-6"></i>
            PAGAR $67 CON TARJETA
          </a>

          <a href="pago-normal?p=paypal" target="_blank"
             class="w-full text-base sm:text-lg md:text-xl flex items-center justify-center gap-3 py-4 rounded-2xl bg-blue-600 hover:bg-blue-700 text-white shadow-lg hover:shadow-xl transition">
            <i data-lucide="check-circle" class="w-6 h-6"></i>
            PAGAR $67 CON PAYPAL
          </a>
        </div>

        <div class="mt-4 flex flex-wrap items-center justify-center gap-x-4 gap-y-1 text-xs text-white/70">
          <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4 text-brand-highlight"></i> Garantía Cero Riesgos</span>
          <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4 text-brand-highlight"></i> Pago 100% Seguro</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div id="social-proof-toast" class="fixed bottom-4 w-[90%] max-w-sm bg-brand-primary border-2 border-brand-highlight rounded-lg shadow-2xl p-4 z-50 
             left-1/2 sm:left-6 sm:-translate-x-0">
    <div class="flex items-start gap-3">
        <div class="flex-shrink-0">
            <img id="toast-image" src="" alt="Cliente Satisfecho" class="h-12 w-12 rounded-full border-2 border-white object-cover bg-gray-700" loading="lazy">
        </div>
        <div class="flex-grow">
            <p id="toast-message" class="text-white font-bold text-sm sm:text-base">Alguien De Texas Acaba De Empezar</p>
            <p class="text-xs sm:text-sm text-gray-400">Hace Unos Momentos</p>
        </div>
        <button id="close-toast" class="text-gray-500 hover:text-white text-2xl leading-none flex-shrink-0">&times;</button>
    </div>
</div>

    </main>

<?php require_once 'files/footer.php'; ?>


    <button id="back-to-top" title="Volver Arriba">
        <i data-lucide="arrow-up" class="text-xl"></i>
    </button>

</body>
</html>