<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Política De Privacidad | OrozDesign Multimedia</title>
    
    <link rel="icon" href="../oferta-web/img/favicon.webp" sizes="any">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <link rel="stylesheet" href="../oferta-web/style.css">
    <script src="../oferta-web/script.js"></script>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d',
                        'brand-secondary': '#9e1428',
                        'brand-highlight': '#ffc857',
                        'brand-light-bg': '#f5f5f5',
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a',
                        'brand-light-text': '#f3f4f6',
                    },
                    fontFamily: { 
                        'sans': ['Barlow', 'sans-serif'] 
                    }
                }
            }
        }
    </script>
</head>

<body class="font-sans bg-brand-light-bg text-brand-dark-text">

    <header class="bg-brand-primary/95 border-b border-white/10 backdrop-blur sticky top-0 z-50">
        <div class="mx-auto max-w-7xl px-4 sm:px-6">
            <div class="h-16 md:h-20 flex items-center justify-between">
                <a href="index.html" class="flex items-center gap-3" aria-label="Ir al inicio">
                    <img src="../oferta-web/img/OrozDesignMultimedia.webp" alt="Logo OrozDesign Multimedia" class="h-8 md:h-10 w-auto">
                </a>
                <a href="/" class="font-bold text-white hover:text-brand-highlight uppercase tracking-wide text-sm">
                    Volver al Inicio
                </a>
            </div>
        </div>
    </header>

    <main class="container mx-auto max-w-4xl px-6 py-16 md:py-24">
        
        <h1 class="font-black text-4xl md:text-5xl text-brand-primary uppercase">Política de Privacidad</h1>
        <p class="mt-2 text-gray-500">Última actualización: <b>25 de agosto de 2025</b></p>
        
        <div class="mt-8 text-lg text-gray-700 leading-relaxed space-y-4">
            <p>Bienvenido a OrozDesign Multimedia ("nosotros", "nuestro"). Valoramos tu privacidad y estamos comprometidos a proteger tu información personal. Esta Política de Privacidad explica cómo recopilamos, usamos, compartimos y protegemos tu información cuando visitas nuestra página web www.generamasclientes.com</p>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">1. INFORMACIÓN QUE RECOPILAMOS</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Podemos recopilar información sobre ti de varias maneras. La información que podemos recopilar en el Sitio incluye:</p>
            <ul class="list-disc list-inside space-y-3 pl-4">
                <li><strong class="text-brand-primary">Datos Personales:</strong> Información de identificación personal, como tu [nombre, correo electrónico, número de teléfono], que nos proporcionas voluntariamente cuando completas un formulario de contacto o realizas una compra.</li>
                <li><strong class="text-brand-primary">Datos Derivados:</strong> Información que nuestros servidores recopilan automáticamente cuando accedes al Sitio, como tu dirección IP, tipo de navegador, sistema operativo, y las páginas que has visto.</li>
                <li><strong class="text-brand-primary">Datos Financieros:</strong> Datos relacionados con tus pagos, como los datos de tu tarjeta de crédito, que recopilamos cuando compras nuestros servicios. Almacenamos solo información muy limitada. La mayoría es procesada por nuestros procesadores de pago, como [Dodo Payments, PayPal, etc.].</li>
            </ul>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">2. CÓMO USAMOS TU INFORMACIÓN</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Tener información precisa sobre ti nos permite ofrecerte una experiencia fluida, eficiente y personalizada. Específicamente, podemos usar la información recopilada sobre ti para:</p>
            <ul class="list-disc list-inside space-y-3 pl-4">
                <li>Crear y gestionar tu cuenta.</li>
                <li>Procesar tus pagos y transacciones.</li>
                <li>Enviarte correos electrónicos sobre nuestros servicios.</li>
                <li>Responder a tus solicitudes de servicio al cliente.</li>
                <li>Analizar el uso del sitio para mejorar nuestros servicios.</li>
                <li>Cumplir con requerimientos legales y regulatorios.</li>
            </ul>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">3. DIVULGACIÓN DE TU INFORMACIÓN</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>No compartiremos tu información con terceros, excepto en las siguientes situaciones:</p>
            <ul class="list-disc list-inside space-y-3 pl-4">
                <li><strong class="text-brand-primary">Por Ley o para Proteger Derechos:</strong> Si la divulgación de tu información es necesaria para responder a un proceso legal, investigar posibles violaciones de nuestras políticas, o proteger los derechos, propiedad y seguridad de otros.</li>
                <li><strong class="text-brand-primary">Proveedores de Servicios Externos:</strong> Podemos compartir tu información con terceros que realizan servicios para nosotros o en nuestro nombre, incluyendo procesamiento de pagos, análisis de datos, y servicios de marketing.</li>
            </ul>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">4. COOKIES Y TECNOLOGÍAS DE SEGUIMIENTO</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Utilizamos cookies y otras tecnologías de seguimiento (como Google Analytics) para ayudar a personalizar el Sitio y mejorar tu experiencia. Al usar el Sitio, aceptas el uso de estas tecnologías. La mayoría de los navegadores están configurados para aceptar cookies por defecto. Puedes eliminar o rechazar las cookies, pero ten en cuenta que dicha acción podría afectar la disponibilidad y funcionalidad del Sitio.</p>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">5. SEGURIDAD DE TU INFORMACIÓN</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Utilizamos medidas de seguridad administrativas, técnicas y físicas para ayudar a proteger tu información personal. Si bien hemos tomado medidas razonables para proteger la información personal que nos proporcionas, ten en cuenta que ningún sistema de seguridad es perfecto o impenetrable.</p>

            <h2 class="font-black text-2xl md:text-3xl text-brand-secondary uppercase pt-8">6. CONTACTO</h2>
            <div class="w-24 h-1 rounded-full bg-brand-highlight mt-2 mb-4"></div>
            <p>Si tienes preguntas o comentarios sobre esta Política de Privacidad, por favor contáctanos en:</p>
            <div class="mt-4 bg-brand-primary/5 border border-brand-primary/20 p-6 rounded-lg">
                <ul class="list-none space-y-2 text-brand-dark-text">
                    <li class="font-black text-xl">OrozDesign Multimedia</li>
                    <li>14 Avenida 17-20 Zona 10, Guatemala City, Guatemala, 01010</li>
                    <li><a href="mailto:[tu-correo@tu-dominio.com]" class="font-bold hover:text-brand-secondary">info@orozdesign.com</a></li>
                    <li><a href="tel:[+14257772109]" class="font-bold hover:text-brand-secondary">+1.425.777.2109</a></li>
                </ul>
            </div>
        </div>

    </main>

</body>
</html>