document.addEventListener('DOMContentLoaded', () => {
    const sidebar = document.getElementById('sidebar');
    const panelOverlay = document.getElementById('panel-overlay');
    const openSidebarBtn = document.getElementById('open-sidebar-btn');
    const sidebarLinks = document.querySelectorAll('.sidebar-link');
    
    const allPanels = document.querySelectorAll('.side-panel');
    const profilePanel = document.getElementById('profile-panel');
    const productPanel = document.getElementById('product-panel');
    const quoteDetailPanel = document.getElementById('quote-detail-panel');

    const openProfileBtn = document.getElementById('open-profile-panel');
    const addProductBtn = document.getElementById('add-product-btn');
    const quotesListContainer = document.getElementById('quotes-list');
    
    const deleteModal = document.getElementById('delete-confirm-modal');
    const mainContent = document.querySelector('main');

    // --- DATOS DE EJEMPLO PARA COTIZACIONES ---
    const sampleQuotes = {
        "1": { client: { name: "Carlos Pérez", email: "carlos.p@email.com", phone: "555-1234", eventDate: "2025-12-15", comments: "Necesito la entrega por la mañana." }, products: [ { name: "Silla Tiffany Blanca", imageUrl: "https://placehold.co/100x100/FFFFFF/333333?text=Silla" }, { name: "Mesa Redonda Imperial", imageUrl: "https://placehold.co/100x100/E0E0E0/333333?text=Mesa" } ] },
        "2": { client: { name: "Ana López", email: "ana.lopez@email.com", phone: "555-5678", eventDate: "2026-01-20", comments: "Sin comentarios." }, products: [ { name: "Carpa Elegante 10x5m", imageUrl: "https://placehold.co/100x100/F0F0F0/333333?text=Carpa" } ] }
    };
    
    // --- Lógica de Paneles Laterales (Perfil, Producto, Detalle de Cotización) ---
    const openPanel = (panel) => {
        panel.classList.remove('translate-x-full');
        panelOverlay.classList.remove('hidden');
        document.body.classList.add('panel-open'); // Agrega clase para controlar el scroll del body
    };

    const closeAllPanels = () => {
        allPanels.forEach(p => p.classList.add('translate-x-full'));
        panelOverlay.classList.add('hidden');
        document.body.classList.remove('panel-open'); // Remueve clase para permitir el scroll del body
    };

    document.querySelectorAll('.close-panel-btn').forEach(btn => btn.addEventListener('click', closeAllPanels));
    panelOverlay.addEventListener('click', closeAllPanels);

    openProfileBtn.addEventListener('click', () => openPanel(profilePanel));
    addProductBtn.addEventListener('click', () => openPanel(productPanel));
    
    // Lógica para el modal de detalle de cotización
    quotesListContainer.addEventListener('click', (e) => {
        const quoteElement = e.target.closest('[data-quote-id]');
        if (quoteElement) {
            const quoteId = quoteElement.dataset.quoteId;
            const quoteData = sampleQuotes[quoteId];
            
            document.getElementById('quote-client-name').textContent = quoteData.client.name;
            document.getElementById('quote-client-email').textContent = quoteData.client.email;
            document.getElementById('quote-client-phone').textContent = quoteData.client.phone;
            document.getElementById('quote-event-date').textContent = quoteData.client.eventDate;
            document.getElementById('quote-client-comments').textContent = quoteData.client.comments;

            const productListEl = document.getElementById('quote-product-list');
            productListEl.innerHTML = ''; // Limpiar lista anterior
            quoteData.products.forEach(product => {
                const li = document.createElement('li');
                li.className = 'flex items-center bg-gray-100 p-2 rounded';
                li.innerHTML = `<img src="${product.imageUrl}" class="w-10 h-10 rounded mr-3"><span>${product.name}</span>`;
                productListEl.appendChild(li);
            });
            
            openPanel(quoteDetailPanel);
        }
    });

    // --- Lógica de Sidebar Móvil ---
    const closeSidebar = () => {
        sidebar.classList.add('-translate-x-full');
        panelOverlay.classList.add('hidden'); // Asegura que el overlay se oculte si se cierra solo el sidebar
    };

    openSidebarBtn.addEventListener('click', () => {
        sidebar.classList.remove('-translate-x-full');
        panelOverlay.classList.remove('hidden'); // Muestra el overlay al abrir el sidebar
    });

    sidebarLinks.forEach(link => {
        link.addEventListener('click', (e) => {
            // Verifica si es un enlace de anclaje (que comienza con #)
            if (link.getAttribute('href').startsWith('#')) {
                // Previene el comportamiento por defecto si no es un enlace de "Salir"
                // (Para que el scroll suave del HTML se encargue si está definido)
                // e.preventDefault(); // Descomentar si quieres manejar el scroll con JS

                sidebarLinks.forEach(l => l.classList.remove('active'));
                link.classList.add('active');

                // Cierra el sidebar solo en pantallas pequeñas (lg breakpoint = 1024px)
                if (window.innerWidth < 1024) {
                    closeSidebar();
                }
            }
            // Si el enlace no es un anclaje (ej. 'Salir' que puede ir a un logout.php),
            // se permite el comportamiento por defecto para navegar.
        });
    });

    // --- Lógica de Modal de Confirmación de Borrado ---
    // Usamos delegación de eventos en mainContent porque los botones de eliminar se pueden añadir/quitar dinámicamente
    mainContent.addEventListener('click', (e) => {
        const deleteButton = e.target.closest('.delete-btn');
        if (deleteButton) {
            const itemName = deleteButton.dataset.deleteItem;
            document.getElementById('item-to-delete-name').textContent = itemName;
            deleteModal.classList.remove('hidden');
        }
    });

    document.getElementById('cancel-delete-btn').addEventListener('click', () => { deleteModal.classList.add('hidden'); });
    document.getElementById('confirm-delete-btn').addEventListener('click', () => {
        const itemToDelete = document.getElementById('item-to-delete-name').textContent;
        console.log(`Simulando eliminación de: ${itemToDelete}`);
        // Aquí iría la lógica real para eliminar el elemento del backend
        // Después de una eliminación exitosa (simulada):
        deleteModal.classList.add('hidden');
        // Aquí podrías añadir una notificación de éxito o recargar la lista
        // showMessageBox('Éxito', `${itemToDelete} ha sido eliminado.`); // Si tuvieras una función showMessageBox
    });
    // Cerrar modal si se hace clic fuera del contenido
    deleteModal.addEventListener('click', (e) => { if (e.target === deleteModal) { deleteModal.classList.add('hidden'); } });
});