<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Catálogo Interactivo - Tu Negocio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>

    <div class="bg-white shadow-md relative z-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-4 flex flex-col sm:flex-row sm:items-center sm:justify-between max-w-6xl">
            <div class="flex items-center flex-shrink-0 mb-2 sm:mb-0">
                <svg class="h-12 w-auto" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="24" cy="24" r="20" fill="var(--brand-yellow)" stroke="var(--brand-dark-blue)" stroke-width="2"/>
                    <path d="M24 10C18.4772 10 14 14.4772 14 20C14 25.5228 18.4772 30 24 30C29.5228 30 34 25.5228 34 20C34 14.4772 29.5228 10 24 10Z" fill="var(--brand-dark-blue)"/>
                    <path d="M24 30V38" stroke="var(--brand-dark-blue)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M18 24L24 30L30 24" stroke="var(--brand-yellow)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <span class="text-3xl font-bold text-brand-dark-blue ml-3 font-heading">Tu Negocio</span>
            </div>
            <a href="tel:+15551234567" class="header-phone-link flex items-center bg-brand-dark-blue text-brand-yellow px-5 py-3 rounded-full shadow-xl ml-0 sm:ml-4 flex-shrink-0 hover:scale-105 hover:shadow-2xl transform transition-all duration-300 ease-in-out no-underline">
                <i class="fa-solid fa-phone mr-3 text-3xl"></i>
                <span class="text-2xl md:text-3xl font-extrabold">+1 (555) 123-4567</span>
            </a>
        </div>
    </div>

    <div class="w-full">
        <img src="https://placehold.co/1200x150/ffc857/07162d?text=ESPACIO+PUBLICITARIO" alt="Espacio publicitario" class="w-full h-auto object-cover">
    </div>

    <section class="bg-[color:var(--brand-dark-blue)] py-4 sm:py-3 text-center relative z-20">
        <h1 class="text-3xl sm:text-4xl font-heading mb-0 leading-tight text-white">
            ¡Bienvenido, <span class="text-[var(--brand-yellow)]">Nombre del Cliente</span>!
        </h1>
        <p class="text-md sm:text-lg max-w-2xl mx-auto text-white mt-1">
            Explora nuestro catálogo para tu evento perfecto.
        </p>
    </section>

    <div class="w-full">
        <div id="app" class="container mx-auto px-4 sm:px-6 lg:px-8 py-4 max-w-7xl">

            <header class="text-center mb-8 mt-8" id="products-section">
                <h2 class="text-3xl md:text-5xl font-heading text-brand-dark-blue">Nuestros Productos</h2>
                <p class="text-gray-600 text-lg mt-2">Selecciona los productos que te interesan para crear una cotización personalizada.</p>
            </header>
            
            <div class="flex justify-center mb-10">
                <select id="category-dropdown" class="category-dropdown w-full max-w-xs md:max-w-sm">
                    </select>
            </div>

            <main id="catalog-view" class="fade-in">
                <div id="product-grid" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8"></div>
            </main>

            <button id="view-quote-btn" class="fixed bottom-5 right-5 btn-action btn-submit-quote flex items-center justify-center z-40 hidden">
                <i class="fa-solid fa-clipboard-list mr-2"></i>
                <span>Mi Cotización</span>
                <span id="quote-count" class="ml-2 bg-brand-red-accent text-white text-xs font-bold rounded-full h-6 w-6 flex items-center justify-center">0</span>
            </button>

            <button id="back-to-top-btn" class="hidden">
                <i class="fa-solid fa-arrow-up"></i>
            </button>

            <div id="quote-form-view" class="quote-panel-backdrop">
                <div id="modal-content-wrapper" class="quote-panel-content">
                    <div class="flex justify-between items-start mb-6">
                        <div>
                            <h2 class="text-2xl font-heading text-brand-dark-blue">Solicitar Cotización</h2>
                            <p class="text-gray-500">Completa tus datos para enviarte la información de los productos seleccionados.</p>
                        </div>
                        <button id="back-to-catalog-btn" class="text-gray-500 hover:text-brand-dark-blue text-3xl font-light leading-none">&times;</button>
                    </div>
                    <div id="quote-summary" class="mb-8 max-h-64 overflow-y-auto pr-2">
                        <h3 class="text-lg font-heading border-b pb-2 mb-4 text-brand-dark-blue">Productos Seleccionados:</h3>
                        <div id="selected-products-list" class="space-y-4"></div>
                        <p id="empty-quote-message" class="text-center text-gray-500 py-4 hidden">Aún no has seleccionado productos.</p>
                    </div>
                    <form id="contact-form">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <input type="text" id="name" name="name" required placeholder="Nombre Completo" class="w-full">
                            <input type="email" id="email" name="email" required placeholder="Correo Electrónico" class="w-full">
                            <input type="tel" id="phone" name="phone" placeholder="Teléfono" class="w-full" pattern="[0-9]{8,15}" title="Por favor, introduce un número de teléfono válido (8-15 dígitos).">
                            <input type="date" id="event-date" name="event-date" required class="w-full">
                            <div class="md:col-span-2">
                                <textarea id="comments" name="comments" rows="4" placeholder="Comentarios Adicionales (ej. fecha del evento, cantidad, etc.)" class="w-full"></textarea>
                            </div>
                        </div>
                        <div class="mt-8 text-right">
                            <button type="submit" id="submit-quote-btn" class="btn-action btn-submit-quote">
                                <i class="fa-solid fa-paper-plane mr-2" id="submit-icon"></i>
                                <span id="submit-text">Enviar Solicitud</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <div id="message-box-backdrop" class="message-box-backdrop">
                <div id="message-box-content" class="message-box-content">
                    <h3 id="message-box-title" class="text-xl font-heading text-brand-dark-blue mb-4"></h3>
                    <p id="message-box-text" class="text-gray-700 mb-6"></p>
                    <button id="message-box-ok-btn" class="btn-action btn-add-quote">Aceptar</button>
                </div>
            </div>

        </div>
    </div>

    <footer class="mt-16 py-8" style="background-color: var(--brand-darkest-blue);">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center text-gray-400">
            <p>&copy; 2024 Nombre de tu Negocio. Todos los derechos reservados.</p>
            <p class="text-sm mt-2">Hecho con <i class="fa-solid fa-heart text-red-500"></i> para eventos increíbles.</p>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>