<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cleaning Pro | Professional Cleaning Services for Homes & Businesses</title>
    <meta name="description" content="Cleaning Pro offers deep cleaning, regular maintenance, and office cleaning services for homes and businesses. Get your free quote today!">
    
    <link rel="icon" type="image/png" href="img/Favicon.png">
    <link rel="apple-touch-icon" href="img/Favicon.png">

    <meta property="og:title" content="Cleaning Pro | Professional Cleaning Services for Homes & Businesses">
    <meta property="og:description" content="Cleaning Pro offers deep cleaning, regular maintenance, and office cleaning services for homes and businesses. Get your free quote today!">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://cleaningpro.com/">
    <meta property="og:image" content="img/image01.jpg">
    <meta property="og:locale" content="en_US"> 


    <script src="https://cdn.tailwindcss.com"></script>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://unpkg.com/imask"></script>
    
    <script src="script.js"></script>
    <link rel="stylesheet" href="style.css">

    <style>
        .sticky-nav {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 50;
            transition: all 0.3s ease-in-out;
        }
    </style>
    
        <?php include 'files/gtm-head.php'; ?>

</head>
<body>

        <?php include 'files/gtm-body.php'; ?>

    <div id="wrapper">

        <header class="hidden md:block bg-white shadow-lg">
            <div class="max-w-7xl mx-auto py-5 px-6 flex items-center">
                <div class="flex-grow flex justify-center">
                    <img src="img/LogoNegro.png" alt="Cleaning Pro Logo" class="w-auto h-21 object-contain max-w-[300px]">
                </div>

                <div class="flex items-center space-x-6 ml-auto">
                    <div class="flex items-center gap-3">
                        <i data-lucide="phone-call" class="text-brand-primary text-3xl"></i>
                        <span class="text-xl text-brand-primary font-black"> +1 (425) 243-4579</span>
                    </div>
                    <a href="mailto:info@cleaningpro.com" class="flex items-center gap-3 hover:opacity-80 transition-opacity duration-200">
    <i data-lucide="mail" class="text-brand-primary text-3xl"></i>
    <span class="text-xl text-brand-primary font-black">
        <script>
            document.write('info' + '@' + 'cleaningpro.com');
        </script>
    </span>
</a>
                    <a href="#quote-form" class="hidden md:flex btn btn-primary py-2 px-4 text-base rounded-md items-center gap-2 ml-6" role="button">
                        GET A QUOTE NOW <i data-lucide="arrow-right" class="text-xl"></i>
                    </a>
                </div>
            </div>
            
            <nav class="bg-brand-primary py-3 shadow-md" id="main-navbar">
                <ul class="max-w-7xl mx-auto flex flex-wrap justify-center items-center gap-x-8 gap-y-2 text-lg font-black">
                    <li><a href="#wrapper" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="home"></i> HOME</a></li>
                    <li><a href="#services-list" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="sparkles"></i> OUR SERVICES</a></li>
                    <li><a href="#how-it-works" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="settings"></i> HOW IT WORKS</a></li>
                    <li><a href="#gallery-section" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="image"></i> GALLERY</a></li>
                    <li><a href="#coverage-area" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="map-pin"></i> AREA OF COVERAGE</a></li>
                    <li><a href="#quote-form" class="hover:text-brand-secondary transition-colors duration-220 px-2 py-1 rounded-md flex items-center gap-1 text-white"><i data-lucide="file-text"></i> GET A QUOTE</a></li>
                    <li><a href="es.php" class="border-2 border-brand-secondary text-brand-secondary hover:bg-brand-secondary hover:text-brand-primary transition-colors duration-220 px-3 py-1 rounded-md flex items-center gap-2 text-sm"><i data-lucide="globe"></i> ESPAÑOL</a></li>
                </ul>
            </nav>
        </header>

        <header class="md:hidden bg-white shadow-lg py-3 px-4 flex items-center fixed top-0 left-0 w-full z-50">
            <img src="img/LogoNegro.png" alt="Cleaning Pro Logo for mobile" class="w-auto h-16 object-contain mr-auto max-w-[120px]">
            
            <button id="openQuoteModalMobile" class="btn-mobile-header">
                <span>GET A QUOTE</span>
                <i data-lucide="file-text"></i>
            </button>

            <i data-lucide="menu" class="hamburger-icon ml-auto icon w-16 h-16 text-brand-primary" id="openMobileMenu"></i>
        </header>

        <div class="mobile-menu-overlay hidden" id="mobileMenuOverlay"></div>
        <div class="mobile-menu" id="mobileMenu">
            <div class="mobile-menu-header">
                <img src="img/LogoBlanco.png" alt="Cleaning Pro Logo in mobile menu" class="w-80 max-w-full h-auto object-contain mb-3">
                
                <div class="contact-card phone-card" data-aos="zoom-in" data-aos-delay="200">
                    <i data-lucide="message-square" class="icon-large"></i>
                    <div class="text-content">
                        <span class="contact-label">FREE CONSULTATION</span>
                        <a href="https://wa.me/14252434579" target="_blank" class="contact-value">+1 (425) 243-4579</a>
                    </div>
                </div>
            </div>
            <nav class="mobile-menu-nav">
                <ul>
                    <li><a href="#wrapper" class="mobile-menu-link"><i data-lucide="home"></i> HOME</a></li>
                    <li><a href="#services-list" class="mobile-menu-link"><i data-lucide="sparkles"></i> OUR SERVICES</a></li>
                    <li><a href="#how-it-works" class="mobile-menu-link"><i data-lucide="settings"></i> HOW IT WORKS</a></li>
                    <li><a href="#gallery-section" class="mobile-menu-link"><i data-lucide="image"></i> GALLERY</a></li>
                    <li><a href="#coverage-area" class="mobile-menu-link"><i data-lucide="map-pin"></i> AREA OF COVERAGE</a></li>
                    <li><a href="#quote-form" class="mobile-menu-link"><i data-lucide="file-text"></i> GET A QUOTE</a></li>
                    <li class="mt-4">
                        <a href="es.php" class="inline-block border-2 border-brand-secondary text-brand-secondary hover:bg-brand-secondary hover:text-brand-primary transition-colors duration-220 px-4 py-2 rounded-md flex items-center gap-2 w-full justify-center">
                            <i data-lucide="globe"></i> ESPAÑOL
                        </a>
                    </li>
                </ul>
            </nav>
            <div class="mobile-menu-footer">
                <?php include 'footer.php'; ?>
            </div>
        </div>
        <main class="flex-grow">
            <section class="bg-brand-secondary text-brand-primary text-center py-3 px-4 text-lg font-heading tracking-wide shadow-md flex items-center justify-center gap-2 md:hidden mt-24">
                <i class="ph-bold ph-calendar-check text-2xl"></i>
                PLANNING YOUR CLEANING
            </section>

            <section id="solution-section" class="text-center py-32 px-10 shadow-inner hero-section-bg">
                <div class="max-w-7xl mx-auto md:flex md:items-center md:gap-12 md:text-left">
                    <div class="md:w-1/2 mb-8 md:mb-0">
                        <h3 class="section-subtitle subtitle-dark mt-4 text-2xl text-center md:text-left" data-aos="fade-up" data-aos-delay="100">LOOKING FOR A SPOTLESS SPACE?</h3>
                        <h1 class="section-title title-dark animate-fade-in-down text-center md:text-left">
                            WE'RE HERE TO MAKE IT SHINE LIKE NEW
                        </h1>
                        <p class="text-lg text-white mt-4 md:text-xl">
                            Whether you need deep cleaning at home, regular maintenance, or office cleaning services, we have everything you need to transform your space. We offer a variety of customizable options to suit any need.
                        </p>
                        <a href="#quote-form" class="btn btn-primary mt-8 inline-flex" role="button" data-aos="fade-up" data-aos-delay="700">
                            GET A QUOTE <i data-lucide="arrow-right" class="text-2xl"></i>
                        </a>
                    </div>
                    <div class="md:w-1/2 flex justify-center md:justify-start">
                        <img src="img/image01.jpg" alt="Image of cleaning products and gloves" class="w-full rounded-xl shadow-xl object-cover h-64 sm:h-80 md:h-96" data-aos="zoom-in">
                    </div>
                </div>
            </section>

            <section class="relative bg-brand-light py-32 px-6 overflow-hidden" data-aos="fade-up">
                <div class="absolute inset-0 opacity-10" style="background-image: radial-gradient(white 1px, transparent 1px); background-size: 20px 20px;"></div>
                <div class="relative z-10 text-center md:flex md:items-center md:justify-center md:text-left max-w-7xl mx-auto md:gap-12">
                    <div class="md:w-1/2 flex justify-center md:justify-end mb-8 md:mb-0">
                        <img src="img/LogoNegro.png" onerror="this.onerror=null; this.src='https://placehold.co/800x600/F0F0F0/333333?text=Image+Not+Found';" alt="Circular Cleaning Pro Logo" class="w-56 h-56 sm:w-72 sm:h-72 object-contain rounded-full border-8 border-brand-secondary shadow-2xl transform hover:scale-105 transition-transform duration-300 p-4 md:hidden">
                        <img src="img/image03.jpg" alt="Full Cleaning Pro logo image for desktop" class="w-full rounded-xl shadow-xl object-cover h-64 sm:h-80 md:h-96 hidden md:block">
                    </div>
                    <div class="md:w-1/2 md:pl-8">
                        <h3 class="section-subtitle subtitle-light mt-4 text-center md:text-left">Create the perfect atmosphere in your home or business.</h3>
                        <h2 class="section-title title-light mt-2 text-center md:text-left">A CLEAN SPACE SHOULDN'T BE STRESSFUL</h2>
                        <p class="text-gray-700 leading-relaxed max-w-2xl mt-6 text-xl opacity-90">
                            After a busy day, the last thing you want is to worry about cleaning. Our deep cleaning and regular maintenance services provide the foundation for a spotless space, ensuring your home or business looks incredible. Our office cleaning services guarantee a productive and healthy environment.
                        </p>
                    </div>
                </div>
            </section>

            <img src="img/imageMobile01.jpg" alt="Divider image: The Solution for clean spaces" class="section-divider-img md:hidden" data-aos="fade-up">
            
            <section class="py-12 px-6 bg-white text-center">
                <div class="max-w-7xl mx-auto md:flex md:items-center md:justify-between md:text-left">
                    <div class="md:w-1/2 mb-8 md:mb-0">
                        <h2 class="section-title title-light animate-fade-in-down text-center md:text-left">
                            Request your free estimate now
                        </h2>
                        <h3 class="section-subtitle subtitle-light md:text-left">
                            Want to leave the cleaning to experts?
                        </h3>
                    </div>
                    <div class="md:w-1/3 flex flex-col items-center md:items-center">
                        <a href="#quote-form" class="btn btn-primary mb-4" role="button">
                            GET A QUOTE NOW <i data-lucide="arrow-right" class="text-2xl"></i>
                        </a>
                        <div class="flex items-center">
                            <span class="w-10 h-10 bg-brand-secondary rounded-full flex items-center justify-center mr-2">
                                <i data-lucide="phone-call" class="text-brand-primary text-2xl"></i>
                            </span>
                            <span class="text-xl text-brand-primary font-black"> +1 (425) 243-4579</span>
                        </div>
                    </div>
                </div>
            </section>

            <img src="img/imageMobile02.jpg" alt="Divider image: Quality and Trust in cleaning services" class="section-divider-img md:hidden" data-aos="fade-up">

            <section id="why-choose-us" class="py-32 px-6 text-center why-choose-us-bg">
                <div class="mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-dark text-2xl">Our difference, your cleaning benefit</h3>
                    <h2 class="section-title title-dark mt-2">WHY CHOOSE US?</h2>
                </div>
                <div class="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="why-choose-card" data-aos="fade-up" data-aos-delay="100">
                        <i data-lucide="medal" class="text-brand-secondary icon w-16 h-16"></i>
                        <h4 class="title">PROVEN EXPERIENCE</h4>
                        <p>We have years of experience in the cleaning industry, ensuring flawless results with every service.</p>
                    </div>
                    <div class="why-choose-card" data-aos="fade-up" data-aos-delay="200">
                        <i data-lucide="handshake" class="text-brand-secondary icon w-16 h-16"></i>
                        <h4 class="title">RELIABLE STAFF</h4>
                        <p>Our team is highly trained and completely trustworthy for your peace of mind and the safety of your space.</p>
                    </div>
                    <div class="why-choose-card" data-aos="fade-up" data-aos-delay="300">
                        <i data-lucide="sparkles" class="text-brand-secondary icon w-16 h-16"></i>
                        <h4 class="title">GUARANTEED RESULTS</h4>
                        <p>We are committed to excellence, ensuring that every corner of your space is extraordinary and worry-free.</p>
                    </div>
                </div>
            </section>

            <section id="services-list" class="py-32 px-6 bg-gray-100">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">Everything you need for a spotless space</h3>
                    <h2 class="section-title title-light mt-2">OUR SERVICES</h2>
                    <p class="max-w-3xl mx-auto mt-6 text-lg text-gray-700">
                        We offer a full range of services to ensure your space is perfectly clean and tidy. From essential cleanings to specialized services, we've got you covered:
                    </p>
                </div>

                <div class="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <div class="service-card" data-aos="fade-up" data-aos-delay="100">
                        <i data-lucide="home" class="text-brand-primary icon w-16 h-16 block mx-auto"></i>
                        <h4 class="title">Residential Cleaning</h4>
                        <p class="text-gray-700 mt-2">Deep cleaning and maintenance services for your home, leaving it spotless.</p>
                    </div>
                    <div class="service-card" data-aos="fade-up" data-aos-delay="200">
                        <i data-lucide="building-2" class="text-brand-primary icon w-16 h-16 block mx-auto"></i>
                        <h4 class="title">Commercial Cleaning</h4>
                        <p class="text-gray-700 mt-2">Keep your office or business spotless with our professional cleaning services.</p>
                    </div>
                    <div class="service-card" data-aos="fade-up" data-aos-delay="300">
                        <i data-lucide="spray-can" class="text-brand-primary icon w-16 h-16 block mx-auto"></i>
                        <h4 class="title">Specialized Cleaning</h4>
                        <p class="text-gray-700 mt-2">Cleaning services for events, post-construction, and other specific needs.</p>
                    </div>
                </div>

                <div class="text-center mt-16 max-w-3xl mx-auto" data-aos="fade-up">
                    <p class="text-lg text-gray-800">
                        Whether you are planning a one-time cleaning or a recurring service, we are here to make it extraordinary.
                        <a href="#quote-form" class="font-bold text-brand-primary hover:text-brand-accent transition-colors">
                            Contact us today! </i>
                        </a>
                        to learn more about how we can bring your vision of a clean space to life.
                    </p>
                </div>
            </section>

            <section id="how-it-works" class="py-32 px-6 how-it-works-bg text-white">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-dark text-2xl">From quote to clean in 4 steps</h3>
                    <h2 class="section-title title-dark mt-2">YOUR SPACE, ZERO HASSLE</h2>
                </div>
                
                <div class="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="100">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="file-pen-line" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Step 1</span><br />Fill Out the Form</h3>
                        <p class="text-gray-700">Start the process by telling us what type of cleaning you need through our form.</p>
                    </div>
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="200">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="phone-call" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Step 2</span><br />We Call You</h3>
                        <p class="text-gray-700">A member of our team will contact you to better understand your needs and finalize details.</p>
                    </div>
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="300">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="handshake" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Step 3</span><br />Book the Service</h3>
                        <p class="text-gray-700">Once everything is defined, you confirm the cleaning service for your date.</p>
                    </div>
                    <div class="text-center p-6 rounded-xl shadow-lg bg-white" data-aos="fade-up" data-aos-delay="400">
                        <div class="w-20 h-20 bg-brand-secondary rounded-full flex items-center justify-center mx-auto mb-6 shadow-md">
                            <i data-lucide="party-popper" class="text-4xl text-brand-primary icon w-10 h-10"></i>
                        </div>
                        <h3 class="font-heading text-2xl text-brand-primary mb-3"><span class="section-subtitle subtitle-light text-2xl">Step 4</span><br />Enjoy Your Space</h3>
                        <p class="text-gray-700">We handle the cleaning so you can just focus on enjoying your spotless space without any hassle.</p>
                    </div>
                </div>

                <div class="text-center mt-16">
                    <a href="#quote-form" class="btn btn-primary inline-flex" role="button" data-aos="fade-up">
                        START WITH STEP 1 <i data-lucide="arrow-right" class="text-2xl"></i>
                    </a>
                </div>
            </section>

            <img src="img/imageMobile03.jpg" alt="Divider image: Gallery of cleaning work" class="section-divider-img md:hidden" data-aos="fade-up">
            
            <section id="gallery-section" class="py-32 px-6 bg-gray-100">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">Explore our past work and get inspired for yours.</h3>
                    <h2 class="section-title title-light mt-2">IMAGINE WHAT WE CAN DO FOR YOU</h2>
                </div>
                <div class="max-w-7xl mx-auto">
                    <div class="gallery-main-display mb-6" data-aos="zoom-in">
                        <img id="main-gallery-image" src="img/imageGallery01.jpg" alt="Spotless kitchen after cleaning">
                    </div>
                    <div class="gallery-thumbnails-grid" data-aos="fade-up" data-aos-delay="100">
                        <div class="gallery-thumbnail-card active" data-src="img/imageGallery02.jpg"><img src="img/imageGallery02.jpg" alt="Thumbnail of clean bathroom"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery03.jpg"><img src="img/imageGallery03.jpg" alt="Thumbnail of organized living room"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery04.jpg"><img src="img/imageGallery04.jpg" alt="Thumbnail of office with clean desks"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery05.jpg"><img src="img/imageGallery05.jpg" alt="Thumbnail of shiny floors"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery06.jpg"><img src="img/imageGallery06.jpg" alt="Thumbnail of clean windows"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery07.jpg"><img src="img/imageGallery07.jpg" alt="Thumbnail of vacuum cleaner working"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery08.jpg"><img src="img/imageGallery08.jpg" alt="Thumbnail of cleaning products"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery09.jpg"><img src="img/imageGallery09.jpg" alt="Thumbnail of professional cleaning equipment"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery10.jpg"><img src="img/imageGallery10.jpg" alt="Thumbnail of clean reception area"></div>
                        <div class="gallery-thumbnail-card" data-src="img/imageGallery11.jpg"><img src="img/imageGallery11.jpg" alt="Thumbnail of tidy bedroom"></div>
                    </div>
                </div>
            </section>

            <section id="coverage-area" class="py-32 px-6 bg-white">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">Where do we make your spaces shine?</h3>
                    <h2 class="section-title title-light mt-2">OUR COVERAGE</h2>
                </div>
                
                <div class="max-w-7xl mx-auto md:flex md:items-center md:gap-12 md:text-left">
                    <div class="md:w-1/2 flex justify-center md:justify-end mb-8 md:mb-0" data-aos="fade-right">
                        <img src="img/image06.jpg" alt="Illustrative map of Cleaning Pro coverage area in the US." class="w-full rounded-xl shadow-xl object-cover h-64 sm:h-80 md:h-96">
                    </div>
                    <div class="md:w-1/2 text-center md:text-left">
                        <p class="text-lg text-gray-700 leading-relaxed mb-8" data-aos="fade-up" data-aos-delay="100">
                            Serving the entire Northwest Washington region, we are committed to delivering high-quality cleaning services that transform your home or business into a spotless space. No matter the size of the space, we have everything you need.
                        </p>
                        <ul class="grid grid-cols-1 sm:grid-cols-2 gap-4 text-xl text-brand-primary font-bold list-none p-0" data-aos="fade-up" data-aos-delay="200">
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Seattle</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Bellevue</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Redmond</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Kirkland</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Renton</li>
                            <li class="flex items-center justify-center sm:justify-start gap-2 bg-brand-light p-4 rounded-md shadow-sm"><i data-lucide="check-circle" class="text-brand-accent text-2xl"></i> Tacoma</li>
                        </ul>
                        <p class="text-base text-gray-600 mt-8" data-aos="fade-up" data-aos-delay="300">
                            If your location is not listed, contact us. We may still be able to help you clean your space!
                        </p>
                    </div>
                </div>
            </section>

            <section id="quote-form" class="bg-brand-primary py-20 md:py-32 px-6 text-white">
                <div class="max-w-7xl mx-auto md:flex md:items-center md:gap-12">
                    <div class="md:w-1/2 text-center md:text-left mb-12 md:mb-0" data-aos="fade-right">
                        <h3 class="section-subtitle subtitle-dark text-2xl text-center md:text-left">GET YOUR FREE QUOTE TODAY!</h3>
                        <h2 class="section-title title-dark mt-2 text-center md:text-left">READY FOR A SPOTLESS SPACE?</h2>
                        <p class="text-white leading-relaxed max-w-2xl mt-6 text-xl opacity-90">
                            Ready for a sparkling space? We are here to help you without any commitment. Whether you need residential, commercial, or specialized cleaning, we offer custom solutions tailored to your needs.
                        </p>
                        <ul class="text-white text-lg mt-8 space-y-4 list-none p-0">
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="100">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Residential Cleaning:</span> For a perpetually spotless home.</div>
                            </li>
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="200">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Commercial Cleaning:</span> Keep your business professional and pristine.</div>
                            </li>
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="300">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Specialized Cleaning:</span> Solutions for specific needs.</div>
                            </li>
                            <li class="flex items-start justify-center md:justify-start gap-3" data-aos="fade-up" data-aos-delay="400">
                                <i data-lucide="check-circle" class="text-brand-secondary text-3xl flex-shrink-0"></i>
                                <div class="text-left"><span class="font-bold">Wide Coverage:</span> We serve all of Northwest Washington.</div>
                            </li>
                        </ul>
                    </div>
                    
                    <div class="md:w-1/2 bg-white p-8 rounded-xl shadow-2xl" data-aos="zoom-in">
                        <h2 class="section-title title-light text-3xl mb-6 text-center w-full">REQUEST YOUR QUOTE TODAY</h2>
                        <form id="contact-form" class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-brand-primary text-lg font-bold mb-2">Full Name:</label>
                                    <input type="text" id="name" name="name" class="form-input" placeholder="Your name" required>
                                </div>
                                <div>
                                    <label for="email" class="block text-brand-primary text-lg font-bold mb-2">Email Address:</label>
                                    <input type="email" id="email" name="email" class="form-input" placeholder="your.email@example.com" required>
                                </div>
                                <div>
                                    <label for="phone" class="block text-brand-primary text-lg font-bold mb-2">Phone Number:</label>
                                    <input type="tel" id="phone" name="phone" class="form-input" placeholder="+1 (XXX) XXX-XXXX" required>
                                </div>
                                <div>
                                    <label for="service-quote" class="block text-brand-primary text-lg font-bold mb-2">Type of Service:</label>
                                    <select id="service-quote" name="service" class="form-input" required>
                                        <option value="">Please select an option</option>
                                        <option value="residential_cleaning">Residential Cleaning</option>
                                        <option value="commercial_cleaning">Commercial Cleaning</option>
                                        <option value="specialized_cleaning">Specialized Cleaning</option>
                                    </select>
                                </div>
                            </div>
                            <div>
                                <label for="message" class="block text-brand-primary text-lg font-bold mb-2">Message / Details:</label>
                                <textarea id="message" name="message" rows="5" class="form-input" placeholder="Tell us about your cleaning needs..." required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary w-full mt-6">SEND QUOTE <i data-lucide="arrow-right" class="text-2xl"></i></button>
                            <div id="form-message" class="mt-4 text-center text-sm font-semibold text-brand-primary hidden"></div>
                        </form>
                    </div>
                </div>
            </section>

            <section class="contact-info-section py-32">
                <div class="max-w-7xl mx-auto" data-aos="fade-up">
                    <h3 class="section-subtitle subtitle-light text-2xl">Connect with us</h3>
                    <h2 class="section-title title-light mt-2">PERSONALIZED ATTENTION</h2>
                    <p class="text-lg text-gray-700 opacity-90 mb-6">
                        Our team is ready to answer your questions and schedule your service. Your satisfaction is our priority!
                    </p>

                    <div class="contact-cards-container">
                        <div class="contact-card email-card" data-aos="zoom-in" data-aos-delay="100">
                            <i data-lucide="headset" class="icon-large"></i>
                            <div class="text-content">
                                <span class="contact-label">SALES SUPPORT</span>
                                <a href="mailto:info@cleaningpro.com" class="contact-value">info@cleaningpro.com</a>
                            </div>
                        </div>

                        <div class="contact-card phone-card" data-aos="zoom-in" data-aos-delay="200">
                            <i data-lucide="message-square" class="icon-large"></i>
                            <div class="text-content">
                                <span class="contact-label">FREE CONSULTATION</span>
                                <a href="https://wa.me/14252434579" target="_blank" class="contact-value">+1 (425) 243-4579</a>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-col sm:flex-row justify-center gap-4 mt-8 md:hidden">
                        <a href="tel:+14252434579" class="btn btn-secondary py-3 px-6 text-lg" role="button">CALL NOW</a>
                        <a href="https://wa.me/14252434579" target="_blank" class="btn btn-secondary py-3 px-6 text-lg" role="button">WHATSAPP</a>
                        <a href="mailto:info@cleaningpro.com" class="btn btn-secondary py-3 px-6 text-lg" role="button">SEND EMAIL</a>
                    </div>
                </div>
            </section>
        </main>

        <footer>
            <div class="max-w-7xl mx-auto px-6">
                <div class="footer-logo-container">
                    <img src="img/LogoBlanco.png" alt="Cleaning Pro logo in footer" class="w-20 h-20 object-contain">
                </div>
                <div class="social-links">
                    <a href="#" class="hover:text-brand-secondary transition-colors duration-200 flex items-center gap-2">Facebook</a>
                    <a href="#" class="hover:text-brand-secondary transition-colors duration-200 flex items-center gap-2">Instagram</a>
                    <a href="#" class="hover:text-brand-secondary transition-colors duration-200 flex items-center gap-2">LinkedIn</a>
                </div>
                <?php include 'footer.php'; ?>
            </div>
        </footer>

    </div>

    <button id="openQuoteModalDesktop" class="hidden md:flex bg-brand-red-accent text-white py-6 px-2 rounded-l-xl shadow-lg hover:scale-105 hover:shadow-xl transition-all duration-300 z-50 flex-col items-center justify-center cursor:pointer; border:none; outline:none;" data-aos="fade-left" data-aos-offset="0">
        <span class="font-bold text-lg uppercase">GET A QUOTE </span>
        <i data-lucide="arrow-right" class="text-3xl mt-2"></i>
    </button>

    <a href="#quote-form" id="fixedBottomQuoteBtn" class="md:hidden fixed bottom-0 left-0 right-0 z-50 bg-brand-secondary text-brand-dark-blue py-4 text-center font-bold text-lg uppercase shadow-lg flex items-center justify-center gap-2">
        REQUEST A QUOTE <i data-lucide="arrow-right" class="text-xl"></i>
    </a>

    <div id="quoteModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-end z-[1001]" style="display: none;">
        <div class="bg-white p-8 shadow-2xl w-full relative transform translateX(100%) transition-transform duration-300 ease-out active" id="quoteModalContent">
            <button id="closeQuoteModal" class="absolute top-4 right-4 text-gray-500 hover:text-gray-800 text-3xl font-bold">&times;</button>
            <h3 class="section-subtitle subtitle-light text-2xl">Connect with us</h3>
            <h2 class="section-title title-light mt-2">GET YOUR FREE QUOTE</h2>
            <form id="modal-quote-form" class="space-y-6 w-full">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 w-full">
                    <div>
                        <label for="modal-name" class="block text-brand-primary text-lg font-bold mb-2">Full Name:</label>
                        <input type="text" id="modal-name" name="name" class="form-input" placeholder="Your name" required>
                    </div>
                    <div>
                        <label for="modal-email" class="block text-brand-primary text-lg font-bold mb-2">Email Address:</label>
                        <input type="email" id="modal-email" name="email" class="form-input" placeholder="your.email@example.com" required>
                    </div>
                    <div>
                        <label for="modal-phone" class="block text-brand-primary text-lg font-bold mb-2">Phone Number:</label>
                        <input type="tel" id="modal-phone" name="phone" class="form-input" placeholder="+1 (XXX) XXX-XXXX" required>
                    </div>
                    <div>
                        <label for="modal-service" class="block text-brand-primary text-lg font-bold mb-2">Type of Service:</label>
                        <select id="modal-service" name="service" class="form-input" required>
                            <option value="">Please select an option</option>
                            <option value="residential_cleaning">Residential Cleaning</option>
                            <option value="commercial_cleaning">Commercial Cleaning</option>
                            <option value="specialized_cleaning">Specialized Cleaning</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label for="modal-message" class="block text-brand-primary text-lg font-bold mb-2">Message / Details:</label>
                    <textarea id="modal-message" name="message" rows="5" class="form-input" placeholder="Tell us about your cleaning needs..." required></textarea>
                </div>
                <button type="submit" class="btn btn-primary w-full mt-6">SEND QUOTE <i data-lucide="arrow-right" class="text-2xl"></i></button>
                <div id="modal-form-message" class="mt-4 text-center text-sm font-semibold text-brand-primary hidden"></div>
            </form>
            
            <div class="contact-cards-container">
                <div class="contact-card email-card" data-aos="zoom-in" data-aos-delay="100">
                    <i data-lucide="headset" class="icon-large"></i>
                    <div class="text-content">
                        <span class="contact-label">SALES SUPPORT</span>
                        <a href="mailto:info@cleaningpro.com" class="contact-value">info@cleaningpro.com</a>
                    </div>
                </div>
                <div class="contact-card phone-card" data-aos="zoom-in" data-aos-delay="200">
                    <i data-lucide="message-square" class="icon-large"></i>
                    <div class="text-content">
                        <span class="contact-label">FREE CONSULTATION</span>
                        <a href="https://wa.me/14252434579" target="_blank" class="contact-value">+1 (425) 243-4579</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            AOS.init({
                duration: 800,
                once: true,
                offset: 50,
            });

            // Initialize Lucid Icons
            lucide.createIcons();

            // Mobile Menu Logic
            const openMobileMenuBtn = document.getElementById('openMobileMenu');
            const mobileMenu = document.getElementById('mobileMenu');
            const mobileMenuOverlay = document.getElementById('mobileMenuOverlay');
            const mobileMenuLinks = document.querySelectorAll('.mobile-menu-link');

           function toggleMobileMenu() {
           mobileMenu.classList.toggle('active');
           mobileMenuOverlay.classList.toggle('active');
           document.body.classList.toggle('overflow-hidden');
                       }

            openMobileMenuBtn.addEventListener('click', toggleMobileMenu);
            mobileMenuOverlay.addEventListener('click', toggleMobileMenu);

            mobileMenuLinks.forEach(link => {
                link.addEventListener('click', () => {
                    if (mobileMenu.classList.contains('open')) {
                        toggleMobileMenu();
                    }
                });
            });

            // Gallery Logic
            const mainGalleryImage = document.getElementById('main-gallery-image');
            const galleryThumbnails = document.querySelectorAll('.gallery-thumbnail-card');

            galleryThumbnails.forEach(thumbnail => {
                thumbnail.addEventListener('click', () => {
                    galleryThumbnails.forEach(t => t.classList.remove('active'));
                    thumbnail.classList.add('active');
                    mainGalleryImage.src = thumbnail.dataset.src;
                });
            });

            // Form Submission Logic (Main Quote Form)
            const contactForm = document.getElementById('contact-form');
            const formMessage = document.getElementById('form-message');

            if (contactForm) {
                contactForm.addEventListener('submit', function(event) {
                    event.preventDefault();
                    formMessage.textContent = 'Your quote request has been sent successfully! We will contact you soon.';
                    formMessage.classList.remove('hidden');
                    formMessage.classList.add('text-brand-primary');
                    contactForm.reset();
                    setTimeout(() => {
                        formMessage.classList.add('hidden');
                    }, 5000);
                });
            }

            // Quote Modal Logic
            const openQuoteModalDesktopBtn = document.getElementById('openQuoteModalDesktop');
            const openQuoteModalMobileBtn = document.getElementById('openQuoteModalMobile');
            const closeQuoteModalBtn = document.getElementById('closeQuoteModal');
            const quoteModal = document.getElementById('quoteModal');
            const quoteModalContent = document.getElementById('quoteModalContent');

            function openModal() {
                quoteModal.style.display = 'flex';
                setTimeout(() => {
                    quoteModalContent.style.transform = 'translateX(0)';
                    document.body.classList.add('overflow-hidden');
                }, 10);
            }

            function closeModal() {
                quoteModalContent.style.transform = 'translateX(100%)';
                document.body.classList.remove('overflow-hidden');
                setTimeout(() => {
                    quoteModal.style.display = 'none';
                }, 300);
            }

            if (openQuoteModalDesktopBtn) openQuoteModalDesktopBtn.addEventListener('click', openModal);
            if (openQuoteModalMobileBtn) openQuoteModalMobileBtn.addEventListener('click', openModal);
            if (closeQuoteModalBtn) closeQuoteModalBtn.addEventListener('click', closeModal);
            if (quoteModal) {
                quoteModal.addEventListener('click', (event) => {
                    if (event.target === quoteModal) {
                        closeModal();
                    }
                });
            }

            // Modal Quote Form Submission Logic
            const modalQuoteForm = document.getElementById('modal-quote-form');
            const modalFormMessage = document.getElementById('modal-form-message');

            if (modalQuoteForm) {
                modalQuoteForm.addEventListener('submit', function(event) {
                    event.preventDefault();
                    modalFormMessage.textContent = 'Your quote request has been sent successfully! We will contact you soon.';
                    modalFormMessage.classList.remove('hidden');
                    modalFormMessage.classList.add('text-brand-primary');
                    modalQuoteForm.reset();
                    setTimeout(() => {
                        modalFormMessage.classList.add('hidden');
                        closeModal();
                    }, 3000);
                });
            }

            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    let targetElement = document.querySelector(this.getAttribute('href'));
                    if (targetElement) {
                        targetElement.scrollIntoView({
                            behavior: 'smooth'
                        });
                    }
                });
            });

            // Sticky Navbar Logic
            const mainNavbar = document.getElementById('main-navbar');
            if (mainNavbar) {
                const initialNavbarOffset = mainNavbar.offsetTop;
                const navbarHeight = mainNavbar.offsetHeight;

                function handleStickyNavbar() {
                    if (window.pageYOffset > initialNavbarOffset) {
                        mainNavbar.classList.add('sticky-nav');
                        document.body.style.paddingTop = navbarHeight + 'px';
                    } else {
                        mainNavbar.classList.remove('sticky-nav');
                        document.body.style.paddingTop = '0';
                    }
                }
                
                window.addEventListener('scroll', handleStickyNavbar);
                handleStickyNavbar();
            }
        });
    </script>
</body>
</html>