<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evento Especial</title>
    <!-- Carga de Tailwind CSS para estilos rápidos y responsivos -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Fonts: Barlow (para títulos) y Inter (para texto general) -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <!-- AOS Library for animations (from your example) -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <!-- Phosphor Icons para iconos -->
    <script src="https://unpkg.com/@phosphor-icons/web"></script>

    <style>
        /* Definición de la paleta de colores inspirada en tu ejemplo */
        :root {
            --brand-primary: #07162d; /* Azul Oscuro (Inteligencia) */
            --brand-secondary: #9e1428; /* Rojo (Creatividad) */
            --brand-background-white: #f5f5f5; /* Blanco Grisáceo (Honestidad) */
            --brand-highlight: #ffc857; /* Amarillo (Visión) */
            --brand-background-black: #07080a; /* Negro (Prestigio) */
        }

        body {
            font-family: 'Inter', sans-serif; /* Fuente principal para el cuerpo */
            background-color: var(--brand-background-white); /* Fondo blanco grisáceo como en tu ejemplo */
            display: flex;
            flex-direction: column; /* Para apilar el header y el contenido */
            justify-content: flex-start; /* Alinear contenido al inicio */
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 0; /* No padding en el body, lo manejamos en el contenido */
            box-sizing: border-box;
            color: #333; /* Color de texto general */
            overflow-x: hidden; /* Previene el scroll horizontal */
        }

        /* Estilos para el encabezado fijo superior */
        .fixed-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 100;
            background-color: var(--brand-background-white); /* Fondo blanco grisáceo */
            box-shadow: 0 2px 4px rgba(0,0,0,0.1); /* Sombra más sutil */
            padding: 0.75rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%; /* Ocupa todo el ancho */
            box-sizing: border-box; /* Incluir padding en el ancho */
        }

        .header-logo {
            height: 40px; /* Tamaño del logo en el header */
            width: auto;
            object-fit: contain;
        }

        .share-button {
            background-color: var(--brand-secondary); /* Color rojo */
            color: white;
            padding: 0.6rem 1.2rem;
            border-radius: 0.5rem; /* Bordes menos redondeados para el botón de compartir */
            font-weight: 700; /* Negrita */
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease; /* Transición más simple */
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.15);
            text-transform: uppercase; /* Mayúsculas */
        }
        .share-button:hover {
            background-color: #7d101f; /* Rojo más oscuro */
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        /* Contenedor principal del contenido */
        .main-content-wrapper {
            max-width: 450px; /* Ancho máximo para el contenido principal */
            width: 100%;
            padding: 100px 20px 20px; /* Padding superior para dejar espacio al header fijo */
            text-align: center;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start; /* Alinear contenido al inicio */
            flex-grow: 1; /* Para que ocupe el espacio restante */
            background-color: var(--brand-background-white); /* Asegurar que el fondo del contenido sea blanco grisáceo */
        }

        .festijado-image-container {
            width: 200px; /* Tamaño de la imagen del festijado, similar al ejemplo */
            height: 200px;
            border-radius: 50%; /* Circular */
            overflow: hidden;
            box-shadow: 0 8px 20px rgba(0,0,0,0.15); /* Sombra más sutil */
            border: 4px solid var(--brand-highlight); /* Borde amarillo llamativo */
            margin-bottom: 2.5rem; /* Espacio debajo de la imagen */
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 4px; /* Padding interno para el borde */
            background-color: white; /* Fondo blanco para la imagen circular */
        }

        .festijado-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 50%; /* Asegurar que la imagen dentro sea circular */
        }

        .event-title {
            font-family: 'Barlow', sans-serif; /* Fuente de acento para el título */
            font-size: 2.5rem; /* Tamaño de fuente grande */
            font-weight: 900; /* Extra negrita */
            color: var(--brand-primary); /* Color azul oscuro como en tu ejemplo */
            margin-bottom: 0.75rem;
            line-height: 1.1;
            text-transform: uppercase; /* Mayúsculas como en tu ejemplo */
        }

        .event-description {
            font-size: 1.1rem; /* Tamaño de fuente para la descripción */
            color: #555; /* Color de texto gris */
            margin-bottom: 2.5rem; /* Más espacio antes de los botones */
            line-height: 1.6;
            font-weight: 400;
        }

        .button {
            display: flex; /* Usar flexbox para centrar contenido y añadir iconos */
            align-items: center;
            justify-content: center;
            width: 100%;
            padding: 1.1rem 1.5rem; /* Relleno ajustado a tu ejemplo */
            margin-bottom: 1rem; /* Espacio entre botones */
            border-radius: 0.5rem; /* Bordes redondeados como en tu ejemplo */
            font-weight: 700; /* Texto más negrita */
            font-size: 1.15rem; /* Tamaño de fuente */
            text-decoration: none;
            transition: all 0.3s ease; /* Transición más simple */
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1); /* Sombra como en tu ejemplo */
            letter-spacing: 0.02em; /* Espaciado de letras sutil */
            text-transform: uppercase; /* Texto en mayúsculas */
            gap: 0.75rem; /* Espacio entre texto e icono */
            border: none; /* Sin borde inicial */
        }

        .button-upload {
            background-color: var(--brand-secondary); /* Color rojo */
            color: #ffffff;
        }
        .button-upload:hover {
            background-color: #7d101f; /* Rojo más oscuro */
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .button-view {
            background-color: var(--brand-primary); /* Color azul oscuro */
            color: #ffffff;
        }
        .button-view:hover {
            background-color: #05101f; /* Azul oscuro más oscuro */
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        /* Estilos para el organizador del evento en la parte inferior */
        .organizer-info {
            margin-top: 2.5rem;
            padding: 2rem; /* Aumentar padding */
            background-color: white; /* Fondo blanco para el recuadro */
            border-radius: 1rem; /* Bordes redondeados */
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15); /* Sombra más fuerte */
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 1rem;
            width: calc(100% - 40px); /* Ocupa el ancho del main-content-wrapper menos el padding */
            max-width: 400px; /* Limitar el ancho */
            margin-left: auto;
            margin-right: auto;
            border: 2px solid var(--brand-highlight); /* Borde amarillo para destacar */
            transition: all 0.3s ease;
        }
        .organizer-info:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.2);
        }

        .organizer-info .organizer-logo {
            height: 70px; /* Tamaño más grande para el logo del organizador */
            width: auto;
            object-fit: contain;
            margin-bottom: 0.5rem;
        }

        .organizer-info .organizer-text {
            font-family: 'Barlow', sans-serif; /* Usar Barlow para el texto del organizador */
            font-size: 1.25rem; /* Tamaño de fuente más grande */
            color: var(--brand-primary); /* Color azul oscuro */
            font-weight: 900; /* Extra negrita */
            text-transform: uppercase;
            letter-spacing: 0.08em; /* Más espaciado de letras */
        }

        /* Share Modal Specific Styles (Actualizados para parecerse más a la imagen) */
        #shareModal {
            display: flex; /* Asegura que el flexbox se aplique */
            align-items: center; /* Centra verticalmente */
            justify-content: center; /* Centra horizontalmente */
            background-color: rgba(0, 0, 0, 0.75); /* Fondo oscuro semi-transparente */
            transition: opacity 0.3s ease, visibility 0.3s ease;
            position: fixed; /* Ensure it's fixed */
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1001; /* Ensure it's above everything else */
        }
        #shareModal.active {
            visibility: visible;
            opacity: 1;
        }
        #shareModalContent {
            position: relative; /* Para posicionar el botón de cerrar */
            background-color: white; /* Fondo blanco */
            padding: 2rem;
            border-radius: 1rem; /* Bordes redondeados */
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3); /* Sombra más pronunciada */
            width: 90%; /* Ancho del modal */
            max-width: 380px; /* Ancho máximo para móviles */
            text-align: center;
            transform: scale(0.9); /* Pequeña escala inicial para animación */
            opacity: 0; /* Inicialmente oculto */
            transition: transform 0.3s ease-out, opacity 0.3s ease-out;
        }
        #shareModal.active #shareModalContent {
            transform: scale(1); /* Escala a tamaño normal */
            opacity: 1;
        }

        #closeShareModal {
            position: absolute;
            top: 10px;
            right: 10px;
            background: none;
            border: none;
            cursor: pointer;
            font-size: 2rem; /* Tamaño del icono X */
            color: #888;
            transition: color 0.2s ease;
            padding: 0.5rem; /* Área de toque más grande */
        }
        #closeShareModal:hover {
            color: #333;
        }

        #shareModalContent .modal-logo {
            height: 60px; /* Tamaño del logo en el modal */
            width: auto;
            object-fit: contain;
            margin-bottom: 1.5rem;
        }

        #shareModalContent .modal-title {
            font-family: 'Barlow', sans-serif;
            font-size: 1.75rem; /* Título "COMPARTIR ESTA APP" */
            font-weight: 900;
            color: var(--brand-primary);
            margin-bottom: 1.5rem;
            text-transform: uppercase;
        }

        #shareModalContent .modal-qr-code {
            width: 150px; /* Tamaño del QR en el modal */
            height: 150px;
            margin: 0 auto 1.5rem auto;
            border: 1px solid #eee; /* Borde sutil para el QR */
            border-radius: 0.5rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        #shareModalContent .modal-description {
            font-size: 0.95rem;
            color: #666;
            margin-bottom: 2rem;
            line-height: 1.4;
        }

        .share-options-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr); /* 2 columnas */
            gap: 1.5rem 1rem; /* Espacio vertical y horizontal */
            width: 100%;
        }

        .share-option-item { /* Renamed from share-option-btn to reflect it's not a full button */
            display: flex;
            align-items: center;
            justify-content: center; /* Center horizontally */
            gap: 0.5rem; /* Space between icon and text */
            font-weight: 600;
            font-size: 1rem; /* Adjust font size */
            text-decoration: none;
            color: var(--brand-primary); /* Text color */
            transition: color 0.2s ease, transform 0.2s ease;
            text-transform: none; /* No uppercase for these labels */
        }
        .share-option-item:hover {
            color: var(--brand-secondary); /* Highlight on hover */
            transform: translateY(-2px);
        }
        .share-option-item i {
            font-size: 1.8rem; /* Icon size */
            color: var(--brand-primary); /* Icon color */
            flex-shrink: 0; /* Prevent icon from shrinking */
        }

        /* Colores específicos para los botones de compartir si se desea */
        .share-whatsapp .ph-whatsapp-logo { color: #25D366; }
        .share-email .ph-envelope-simple { color: #D44638; }
        .share-sms .ph-chats-teardrop { color: #6C757D; }
        .share-facebook .ph-facebook-logo { color: #1877F2; }
        .share-twitter .ph-twitter-logo { color: #1DA1F2; }
    </style>
</head>
<body>

    <!-- Encabezado fijo superior -->
    <header class="fixed-header">
        <img src="https://placehold.co/120x60/f5f5f5/07162d?text=Logo" alt="Logo Organizador" class="header-logo">
        <button class="share-button" id="openShareModalMobile">
            COMPARTIR <i class="ph-bold ph-share-network"></i>
        </button>
    </header>

    <!-- Contenido principal de la página -->
    <div class="main-content-wrapper">
        <!-- Festijado Image -->
        <div class="festijado-image-container" data-aos="zoom-in" data-aos-delay="100">
            <img src="https://placehold.co/220x220/f5f5f5/07162d?text=Foto+Festijado" alt="Foto del Festijado" class="festijado-image">
        </div>

        <!-- Encabezado del evento con estilo mejorado -->
        <h1 class="event-title" data-aos="fade-up" data-aos-delay="200">
            Boda de José y Evelyn
        </h1>
        <!-- Mensaje introductorio con estilo mejorado -->
        <p class="event-description" data-aos="fade-up" data-aos-delay="300">
            ¡Bienvenidos a este día tan especial! Comparte tus fotos y revive los momentos mágicos de nuestra celebración.
        </p>

        <!-- Botón para subir fotos -->
        <a href="#" class="button button-upload" id="uploadButton" data-aos="fade-up" data-aos-delay="400">
            <i class="ph-bold ph-camera text-2xl"></i> Subir Fotos
        </a>

        <!-- Botón para ver la galería de fotos -->
        <a href="#" class="button button-view" id="viewButton" data-aos="fade-up" data-aos-delay="500">
            <i class="ph-bold ph-image-square text-2xl"></i> Ver Fotos
        </a>

        <!-- Información del organizador del evento en la parte inferior -->
        <div class="organizer-info" data-aos="fade-up" data-aos-delay="600">
            <img src="https://placehold.co/100x40/f5f5f5/07162d?text=Tu+Logo" alt="Logo Organizador" class="organizer-logo">
            <span class="organizer-text">Organizado por: [Nombre del Organizador]</span>
        </div>
    </div>

    <!-- Share Modal (funcionalidad de compartir) -->
    <div id="shareModal" class="fixed inset-0 z-[1001] hidden">
        <div id="shareModalContent">
            <button id="closeShareModal" class="text-gray-500 hover:text-gray-800 text-3xl font-bold">&times;</button>
            
            <img src="https://placehold.co/150x80/f5f5f5/07162d?text=Tu+Logo" alt="Logotipo de General Cleaning Services" class="modal-logo">
            <h2 class="modal-title">COMPARTIR ESTA APP</h2>
            
            <img src="https://placehold.co/200x200/f5f5f5/07162d?text=Tu+Código+QR" alt="Código QR de General Cleaning Services" class="modal-qr-code">
            <p class="modal-description">Escanea el código QR para compartir esta página o usa las opciones de abajo.</p>

            <div class="share-options-grid">
                <a id="shareWhatsappBtn" href="#" target="_blank" class="share-option-item share-whatsapp">
                    <i class="ph-bold ph-whatsapp-logo"></i> WhatsApp
                </a>
                <a id="shareEmailBtn" href="#" class="share-option-item share-email">
                    <i class="ph-bold ph-envelope-simple"></i> Correo Electrónico
                </a>
                <a id="shareSmsBtn" href="#" class="share-option-item share-sms">
                    <i class="ph-bold ph-chats-teardrop"></i> Mensaje de Texto
                </a>
                <a id="shareFacebookBtn" href="#" target="_blank" class="share-option-item share-facebook">
                    <i class="ph-bold ph-facebook-logo"></i> Facebook
                </a>
                <a id="shareTwitterBtn" href="#" target="_blank" class="share-option-item share-twitter">
                    <i class="ph-bold ph-twitter-logo"></i> X (Twitter)
                </a>
            </div>
        </div>
    </div>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        // Initialize AOS
        document.addEventListener('DOMContentLoaded', () => {
            AOS.init({
                duration: 800,
                once: true,
                offset: 50, // Offset (in px) from the top of the screen to trigger animations
            });
        });

        // Lógica para simular el estado del evento (activo o finalizado)
        // En una implementación real, 'eventEnded' vendría de una base de datos o API
        const eventEnded = false; // Cambia a 'true' para simular que el evento ha terminado

        window.onload = function() {
            const uploadButton = document.getElementById('uploadButton');
            const viewButton = document.getElementById('viewButton');
            const mainContentWrapper = document.querySelector('.main-content-wrapper');

            if (eventEnded) {
                uploadButton.style.display = 'none'; // Oculta el botón de subir fotos
                
                // Crea y añade un mensaje si la carga de fotos ha finalizado
                const messageDiv = document.createElement('p');
                messageDiv.className = 'text-gray-600 font-semibold mt-6 mb-4 text-lg'; // Clases de Tailwind para estilo
                messageDiv.textContent = 'La carga de fotos ha finalizado. ¡Ahora puedes disfrutar de la galería completa!';
                
                // Inserta el mensaje antes del botón de ver fotos
                mainContentWrapper.insertBefore(messageDiv, viewButton);

                // Ajusta el margen superior del botón de ver fotos si es el único visible
                viewButton.style.marginTop = '1.5rem'; 

            } else {
                uploadButton.style.display = 'flex'; // Asegura que el botón de subir esté visible (flex para centrado)
            }

            // Aquí iría la lógica real para redirigir a las páginas de subir/ver fotos
            // Se reemplazaría con las URLs reales de tu plataforma
            uploadButton.addEventListener('click', (e) => {
                e.preventDefault();
                console.log('Redirigiendo a la página de subida de fotos...');
                // window.location.href = 'URL_PARA_SUBIR_FOTOS';
            });

            viewButton.addEventListener('click', (e) => {
                e.preventDefault();
                console.log('Redirigiendo a la galería de fotos...');
                // window.location.href = 'URL_PARA_VER_FOTOS';
            });

            // Lógica del Modal de Compartir
            const openShareModalMobileBtn = document.getElementById('openShareModalMobile');
            const shareModal = document.getElementById('shareModal');
            const closeShareModalBtn = document.getElementById('closeShareModal');
            
            function openShareModal() {
                shareModal.classList.remove('hidden');
                shareModal.classList.add('active');
                document.body.classList.add('overflow-hidden'); // Prevenir scroll del body
            }

            function closeShareModal() {
                shareModal.classList.remove('active');
                shareModal.classList.add('hidden');
                document.body.classList.remove('overflow-hidden');
            }

            if (openShareModalMobileBtn) {
                openShareModalMobileBtn.addEventListener('click', openShareModal);
            }
            if (closeShareModalBtn) {
                closeShareModalBtn.addEventListener('click', closeShareModal);
            }
            // Cerrar modal al hacer clic fuera del contenido
            if (shareModal) {
                shareModal.addEventListener('click', (event) => {
                    if (event.target === shareModal) {
                        closeShareModal();
                    }
                });
            }

            // Configuración de enlaces para compartir
            const pageUrl = encodeURIComponent(window.location.href);
            const shareMessage = encodeURIComponent('¡Mira las fotos de este evento especial! Visita la galería aquí: ');

            const shareWhatsappBtn = document.getElementById('shareWhatsappBtn');
            const shareEmailBtn = document.getElementById('shareEmailBtn');
            const shareSmsBtn = document.getElementById('shareSmsBtn');
            const shareFacebookBtn = document.getElementById('shareFacebookBtn');
            const shareTwitterBtn = document.getElementById('shareTwitterBtn');

            if (shareWhatsappBtn) { shareWhatsappBtn.href = `https://wa.me/?text=${shareMessage}${pageUrl}`; }
            if (shareEmailBtn) { shareEmailBtn.href = `mailto:?subject=Fotos%20del%20Evento%20Especial&body=${shareMessage}${pageUrl}`; }
            if (shareSmsBtn) { shareSmsBtn.href = `sms:?body=${shareMessage}${pageUrl}`; }
            if (shareFacebookBtn) { shareFacebookBtn.href = `https://www.facebook.com/sharer/sharer.php?u=${pageUrl}`; }
            if (shareTwitterBtn) { shareTwitterBtn.href = `https://twitter.com/intent/tweet?text=${shareMessage}&url=${pageUrl}`; }
        };
    </script>
</body>
</html>
