<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>Página Web Para Negocios Locales En Estados Unidos | LocalWebPro Por Solo $197</title>
    <meta name="description" content="Consigue una página web profesional en Estados Unidos diseñada para atraer clientes. Paquete todo incluido por $197 para dueños de negocios locales. ¡Garantía de Cero Riesgo!">

<?php require_once 'files/gtm_head.php'; ?>


    <link rel="icon" href="img/favicon.webp" sizes="any">
    <link rel="icon" href="img/favicon.webp" type="image/svg+xml">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.webp">
    
    <link rel="canonical" href="https://generamasclientes.com/oferta-web/oferta-flash">

    <meta property="og:title" content="Página Web Profesional para tu Negocio Local por Solo $197">
    <meta property="og:description" content="Deja de ser invisible online. Atrae clientes y genera confianza con una web diseñada para vender.">
    <meta property="og:image" content="https://generamasclientes.com/oferta-web/img/LocalWebPro.webp">
    <meta property="og:url" content="https://generamasclientes.com/oferta-web">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="LocalWebPro">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Página Web Profesional para tu Negocio Local por Solo $197">
    <meta name="twitter:description" content="Deja de ser invisible online. Atrae clientes y genera confianza con una web diseñada para vender.">
    <meta name="twitter:image" content="https://generamasclientes.com/oferta-web/img/LocalWebPro.webp"> 

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js" defer></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <link rel="stylesheet" href="style.css">
    <script src="oferta-flash.js"></script>
    <script src="script.js"></script>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d', /* Azul Oscuro (Inteligencia) */
                        'brand-secondary': '#9e1428', /* Rojo (Creatividad) */
                        'brand-highlight': '#ffc857', /* Amarillo (Visión) */
                        'brand-light-bg': '#f5f5f5', /* Blanco (Honestidad) */
                        'brand-white': '#f5f5f5',
                        'brand-dark-text': '#07080a', /* Negro (Prestigio) - para textos principales */
                        'brand-light-text': '#f3f4f6', /* Mantener para textos claros sobre fondos oscuros */
                        'dark-red-bg': '#9e1428', /* Usar Rojo Secundario para fondos específicos */
                        'dark-black-bg': '#07080a', /* Nuevo: Negro (Prestigio) para fondos */
                    },
                    fontFamily: { 'sans': ['Barlow', 'sans-serif'] }
                }
            }
        }
    </script>


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "LocalWebPro - OrozDesign Multimedia",
  "image": "https://generamasclientes.com/oferta-web/img/LocalWebPro.webp",
  "@id": "https://generamasclientes.com",
  "url": "https://generamasclientes.com",
  "telephone": "+1-425-243-4579",
  "priceRange": "$",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Seattle",
    "addressLocality": "Seattle",
    "addressRegion": "WA",
    "postalCode": "98201",
    "addressCountry": "US"
  },
  "description": "Ayudamos a dueños de negocios locales a atraer más clientes y generar confianza con una página web profesional. Ofrecemos diseño web, dominio, hosting y soporte.",
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday"
    ],
    "opens": "09:00",
    "closes": "17:00"
  },
  "sameAs": [
    "https://www.facebook.com/orozdesign"
  ] 
}
</script>

</head>
<body class="font-sans bg-brand-light-bg text-brand-dark-text overflow-x-hidden">

<?php require_once 'files/gtm_body.php'; ?>


<div id="topbar" class="fixed inset-x-0 top-0 z-50 bg-brand-primary/95 border-b border-white/10 backdrop-blur">
    <div class="mx-auto max-w-7xl px-4 sm:px-6">
        <div class="h-16 md:h-20 flex items-center justify-between">
            <a href="#hero-section" class="flex items-center gap-3" aria-label="Ir al inicio">
                <img src="img/OrozDesignMultimedia.webp" alt="Logo OrozDesign Multimedia" class="h-8 md:h-10 w-auto object-contain" loading="eager">
            </a>

            <nav class="hidden md:flex items-center gap-6 font-extrabold uppercase tracking-wide text-white">
                <a href="#paquete" class="inline-flex items-center gap-2 hover:text-brand-highlight">
                    <i data-lucide="package" class="w-5 h-5"></i>El Paquete
                </a>
                <a href="#ai-tools" class="inline-flex items-center gap-2 hover:text-brand-highlight">
                    <i data-lucide="gift" class="w-5 h-5"></i>Bonos Gratis
                </a>
                <a href="#testimonials-section" class="inline-flex items-center gap-2 hover:text-brand-highlight">
                    <i data-lucide="award" class="w-5 h-5"></i>Resultados
                </a>
                <a href="#faq" class="inline-flex items-center gap-2 hover:text-brand-highlight">
                    <i data-lucide="help-circle" class="w-5 h-5"></i>Preguntas
                </a>
<a href="#final-offer-and-payment" class="inline-flex items-center gap-2 bg-brand-highlight text-brand-dark-text px-4 py-2 rounded-lg font-black hover:opacity-90">
    ¡AHORA SÍ QUIERO MI WEB! <i data-lucide="mouse-pointer-click" class="w-5 h-5"></i>
</a>
            </nav>
            <button id="menu-toggle" class="md:hidden inline-flex items-center justify-center px-3 py-2 rounded-lg bg-brand-highlight text-brand-dark-text font-black">
                <i data-lucide="menu" class="lucide-icon"></i>
            </button>
        </div>
    </div>
</div>

<div id="mobile-menu" class="fixed inset-0 z-[60] hidden">
    <div id="mm-backdrop" class="absolute inset-0 bg-black/60 backdrop-blur-sm"></div>

    <aside class="relative w-full h-full bg-[#0B1B31] text-white flex flex-col animate-fade-in">
        <div class="p-4 border-b border-white/10 flex items-center justify-between flex-shrink-0">
            <span class="text-xs font-semibold tracking-widest uppercase text-brand-highlight">Oferta Por Tiempo Limitado</span>
            <button id="mm-close" class="p-2 rounded-md hover:bg-white/10"><i data-lucide="x" class="lucide-icon"></i></button>
        </div>

        <div class="flex-grow p-6 text-center overflow-y-auto">
            <div class="w-full max-w-sm mx-auto"> 
                <img src="img/Paquete-Web.webp" alt="Paquete Web LocalWebPro" class="w-full h-auto rounded-xl ring-1 ring-white/10 mb-4" loading="lazy">
                <h3 class="text-2xl font-black leading-tight uppercase">Tu Web Lista Para Vender</h3>
                <p class="mt-2 text-sm text-gray-300">Profesional, Rápida y Optimizada Para Convertir Clientes</p>

                <ul class="mt-4 space-y-2 text-sm text-gray-200 inline-block text-left">
                    <li class="flex items-start gap-2"><i data-lucide="check-circle" class="lucide-icon"></i> Diseño Enfocado En Ventas</li>
                    <li class="flex items-start gap-2"><i data-lucide="zap" class="lucide-icon"></i> Carga Rápida En Móvil</li>
                    <li class="flex items-start gap-2"><i data-lucide="shield-check" class="lucide-icon"></i> Sin Contratos Ni Cargos Ocultos</li>
                </ul>

                <a href="#final-offer-and-payment" class="inline-flex items-center gap-2 bg-brand-highlight text-brand-dark-text px-4 py-2 rounded-lg font-black hover:opacity-90">
    ¡AHORA SÍ QUIERO MI WEB! <i data-lucide="mouse-pointer-click" class="w-5 h-5"></i>
</a>
                
                <nav class="mt-6 pt-6 border-t border-white/10">
                    <ul class="space-y-1 text-base font-bold">
                        <li>
                            <a href="#paquete" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="package" class="lucide-icon"></i>El Paquete Completo
                            </a>
                        </li>
                        <li>
                            <a href="#ai-tools" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="gift" class="lucide-icon"></i>Tus Bonos Gratis
                            </a>
                        </li>
                        <li>
                            <a href="#testimonials-section" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="award" class="lucide-icon"></i>Resultados
                            </a>
                        </li>
                        <li>
                            <a href="#faq" class="flex items-center gap-2 px-3 py-4 rounded-lg hover:bg-white/10 text-lg uppercase tracking-wider">
                                <i data-lucide="help-circle" class="lucide-icon"></i>Preguntas
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>
    </aside>
</div>

<header id="hero-section"
  class="relative text-white flex items-center justify-center overflow-hidden pt-16 md:pt-20"
  style="
    background-image:
      radial-gradient(900px 420px at 50% 0%, rgba(255,200,87,.08), transparent 60%),
      linear-gradient(rgba(7,22,45,.82), rgba(7,22,45,.82)),
      url('img/BG01.webp?auto=compress&cs=tinysrgb&w=1600&h=900&dpr=1');
    background-size: cover; background-position: center; " loading="lazy">

  <div class="relative z-10 w-full">
    <div class="container mx-auto max-w-5xl px-6 py-20 md:py-28 text-center">

      <p class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-secondary/80 text-white font-bold tracking-widest uppercase ring-1 ring-white/20" data-aos="fade-up" data-aos-delay="60">
        <i data-lucide="alert-triangle" class="lucide-icon"></i>
        ACCESO FINAL: SÓLO POR 24 HORAS
      </p>

      <h1 class="mt-5 font-black uppercase tracking-tight leading-[1.05] text-4xl sm:text-6xl md:text-7xl" data-aos="fade-up" data-aos-delay="140">
        La Oportunidad Que Pensaste Haber Perdido<br class="hidden sm:inline">
        <span class="text-brand-highlight">Regresa Una Última Vez</span>
      </h1>

      <p class="mt-5 text-lg md:text-xl text-gray-200 max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="220">
        Dudaste una vez. El mercado no espera. Por petición, abrimos un número <strong>críticamente bajo</strong> de cupos. Esta no es otra campaña, es la <strong>liquidación final</strong> de esta oferta. Mañana, será demasiado tarde.
      </p>

      <div class="mt-9 flex justify-center" data-aos="fade-up" data-aos-delay="300">
        <a href="#payment-section" class="btn btn-highlight text-lg md:text-xl btn-pulse inline-flex items-center justify-center gap-2 px-8 py-4 rounded-2xl shadow-xl shadow-black/30 ring-2 ring-brand-highlight/60 hover:translate-y-[1px] hover:opacity-95 transition">
          <i data-lucide="lock" class="w-6 h-6"></i>
          ASEGURAR MI ACCESO FINAL
        </a>
      </div>

      <div class="mt-6 flex flex-col sm:flex-row gap-2 sm:gap-4 items-center justify-center text-sm text-gray-300" data-aos="fade-up" data-aos-delay="360">
        <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="lucide-icon"></i> Garantía Cero Riesgo</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="lucide-icon"></i> Tu Web Lista En 3 Días</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="trending-up" class="lucide-icon"></i> Enfocada En Generar Clientes</span>
      </div>

    </div>
  </div>

  <div class="pointer-events-none absolute inset-x-0 bottom-0 h-24 bg-gradient-to-t from-[#07162D] to-transparent"></div>
</header>

<main>

<section id="fast-delivery-wow-section" class="bg-white text-brand-dark-text py-20 md:py-24">
  <div class="container mx-auto max-w-7xl px-6">
    <div class="grid lg:grid-cols-2 gap-10 lg:gap-12 items-center">

      <div class="text-left" data-aos="fade-right">
        <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                   bg-brand-secondary text-white font-bold tracking-widest uppercase
                   ring-1 ring-brand-secondary/30 shadow-sm text-sm md:text-base">
          <i data-lucide="rocket" class="w-4 h-4 md:w-5 md:h-5"></i>
          LA ESPERA TERMINÓ. TU NEGOCIO EN LÍNEA.
        </p>

        <h2 class="mt-4 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-brand-primary uppercase leading-tight">
          Tu Página Web Profesional, Lista Para Vender En <span class="text-brand-secondary">Solo 3 Días</span>
        </h2>

        <p class="text-base sm:text-lg md:text-xl mt-5 text-gray-600">
          Ya has esperado suficiente. Mientras la competencia sigue captando clientes en línea, tu momento de actuar es ahora. Nos entregas la información de tu negocio y en <strong>3 días hábiles (o menos)</strong> te entregamos una página web profesional y funcional. Sin demoras. Sin excusas.
        </p>

        <div class="mt-8 flex flex-col sm:flex-row items-stretch sm:items-center gap-4">
          <a href="#payment-section"
             class="inline-flex justify-center items-center gap-2 px-7 py-4 text-lg font-extrabold rounded-2xl
                    bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/20
                    hover:opacity-95 hover:translate-y-[1px] transition w-full sm:w-auto">
            ¡QUIERO MI WEB! <i data-lucide="arrow-right" class="w-5 h-5"></i>
          </a>
          <a href="#paquete"
             class="inline-flex justify-center items-center gap-2 px-7 py-4 text-lg font-extrabold rounded-2xl
                    border border-gray-300 bg-transparent text-brand-dark-text hover:bg-gray-100
                    transition w-full sm:w-auto">
            VER EL PAQUETE COMPLETO
          </a>
        </div>

        <div class="mt-4 flex flex-wrap items-center gap-x-4 gap-y-2 text-sm text-gray-500">
          <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="w-4 h-4"></i> Entrega Exprés Garantizada</span>
          <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4"></i> Cero Riesgo Para Ti</span>
          <span class="inline-flex items-center gap-1.5"><i data-lucide="phone-call" class="w-4 h-4"></i> Soporte Humano Real</span>
        </div>
      </div>

      <div data-aos="fade-left" data-aos-delay="200">
        <div class="relative bg-brand-primary ring-1 ring-brand-primary/20 rounded-2xl p-3 shadow-2xl overflow-hidden">
          <div class="absolute -top-5 -left-5 w-28 h-28 bg-brand-highlight/20 rounded-full blur-2xl"></div>
          <div class="absolute -bottom-6 -right-6 w-36 h-36 bg-white/10 rounded-full blur-2xl"></div>

          <img src="img/IMG05.webp" 
               alt="Tu Pagina Web Lista En 3 Días"
               class="rounded-xl w-full h-auto object-cover shadow-lg" loading="lazy">
        </div>
      </div>

    </div>
  </div>
</section>

<section id="paquete" class="relative py-20 md:py-24 text-brand-light-text overflow-hidden"
  data-aos="fade-up"
  style="background-image: linear-gradient(rgba(7,22,45,.92), rgba(7,22,45,.92)), url('img/BG02.webp?auto=compress&cs=tinysrgb&w=1260&h=800&dpr=1'); background-size: cover; background-position: center;" loading="lazy">

  <div class="container mx-auto max-w-7xl px-6 relative z-10">
    <div class="flex justify-center">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-white/90 text-brand-secondary font-bold tracking-widest uppercase
                 ring-1 ring-white/15 text-sm md:text-base text-center">
        <i data-ldata-lucide="package-check" class="w-4 h-4"></i>
        LA SOLUCIÓN COMPLETA. SIN PIEZAS FALTANTES, SIN ESTRÉS
      </p>
    </div>

    <h3 class="mt-4 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-center text-white uppercase leading-tight max-w-4xl mx-auto">
      Todo lo que tu negocio necesita para verse profesional en línea, <span class="text-brand-highlight">en un solo paquete</span>
    </h3>

    <div class="mt-6 flex flex-wrap gap-2 justify-center">
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="globe" class="w-4 h-4"></i> Dominio .com Incluido
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="server" class="w-4 h-4"></i> Hosting de Alta Velocidad
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="shield-check" class="w-4 h-4"></i> Certificado de Seguridad SSL
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="pen-tool" class="w-4 h-4"></i> Redacción que Convierte
      </span>
      <span class="shrink-0 inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/15 text-xs md:text-sm">
        <i data-lucide="smartphone" class="w-4 h-4"></i> Diseño 100% Adaptable
      </span>
    </div>

    <div class="mt-10 max-w-3xl mx-auto" data-aos="zoom-in">
      <img src="img/Paquete-Web.webp"
           alt="Paquete Completo LocalWebPro"
           class="rounded-xl w-full h-auto object-cover" loading="lazy">
    </div>

    <div class="mt-12 grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-10 max-w-5xl mx-auto">
      <ul class="space-y-6 text-base sm:text-lg">
        <li class="flex items-start gap-4">
          <i data-lucide="pencil" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Redacción Que Convierte:</strong>
            <p class="text-gray-300">Dejamos de lado el relleno. Cada palabra se diseña para una sola cosa: que tu visitante se convierta en cliente.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="globe" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Tu Propio Dominio (.com):</strong>
            <p class="text-gray-300">La base de tu marca en internet. Proyecta autoridad y confianza al instante con una dirección profesional (*tunegocio.com*).</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="server" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Hosting de Alta Velocidad:</strong>
            <p class="text-gray-300">Un sitio lento es un sitio que no vende. Garantizamos que tu web cargue rápido para no perder ni un solo cliente por impaciencia.</p>
          </div>
        </li>
      </ul>

      <ul class="space-y-6 text-base sm:text-lg">
        <li class="flex items-start gap-4">
          <i data-lucide="shield-check" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Seguridad SSL (El Candado):</strong>
            <p class="text-gray-300">Protege los datos de tus clientes y genera confianza visual inmediata. Indispensable para que Google te tome en serio.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="smartphone" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Diseño Adaptable a Todo Dispositivo:</strong>
            <p class="text-gray-300">Tu negocio se verá impecable y profesional en celulares, tablets y computadoras. Cero clientes perdidos por una mala experiencia móvil.</p>
          </div>
        </li>
        <li class="flex items-start gap-4">
          <i data-lucide="messages-square" class="w-6 h-6 text-brand-highlight mt-1"></i>
          <div>
            <strong class="text-white">Soporte Real y Sin Tecnicismos:</strong>
            <p class="text-gray-300">¿Dudas? ¿Ajustes? Hablas con nosotros, no con un bot. Te acompañamos hasta que tu web esté exactamente como la necesitas.</p>
          </div>
        </li>
      </ul>
    </div>

    <div class="mt-12 text-center">
      <a href="#payment-section"
         class="inline-flex items-center justify-center gap-2 px-8 py-4 text-lg font-extrabold rounded-2xl
                bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/30
                hover:opacity-95 hover:translate-y-[1px] transition">
        SÍ, QUIERO LA SOLUCIÓN COMPLETA <i data-lucide="arrow-right" class="w-5 h-5"></i>
      </a>
      <p class="mt-3 text-sm text-gray-300 flex flex-wrap items-center justify-center gap-x-3 gap-y-1">
        <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4"></i> Garantía Cero Riesgo</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="timer" class="w-4 h-4"></i> Entrega en 3 Días</span>
        <span class="hidden sm:inline">•</span>
        <span class="inline-flex items-center gap-1.5"><i data-lucide="package" class="w-4 h-4"></i> Todo Incluido por $197</span>
      </p>
    </div>
  </div>
</section>

<section id="main-offer-section" class="py-20 md:py-24 bg-brand-light-bg text-brand-dark-text">
  <div class="container mx-auto max-w-4xl px-6 text-center">

    <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
               bg-brand-secondary text-white font-bold tracking-widest uppercase
               ring-1 ring-brand-secondary/30 shadow-sm text-sm md:text-base" data-aos="fade-up">
      <i data-lucide="alert-triangle" class="w-4 h-4 md:w-5 md:h-5"></i>
      LA DECISIÓN QUE POSPUSISTE. EL PRECIO QUE NO VOLVERÁ.
    </p>

    <h2 class="mt-4 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black uppercase leading-tight text-brand-primary"
        data-aos="fade-up" data-aos-delay="80">
      O TOMAS ACCIÓN EN LAS PRÓXIMAS 24 HORAS, O <span class="text-brand-secondary">PIERDES ESTE PRECIO PARA SIEMPRE</span>
    </h2>

    <div class="relative bg-white text-brand-dark-text rounded-3xl shadow-2xl my-10 md:my-12 p-6 sm:p-8 md:p-10"
         data-aos="zoom-in-up" data-aos-delay="140">

      <div class="absolute -top-4 left-1/2 -translate-x-1/2">
        <span class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full
                     bg-brand-secondary text-white font-black uppercase ring-2 ring-white text-xs sm:text-sm">
          <i data-lucide="door-closed" class="w-4 h-4"></i> AVISO FINAL: LA OFERTA SE CIERRA EN 24 HORAS
        </span>
      </div>

      <img src="img/LocalWebPro.webp" alt="Paquete Final Local Web Pro"
           class="mt-4 w-full" loading="lazy">

      <div class="mt-6 flex flex-wrap justify-center gap-2">
        <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-highlight ring-1 ring-gray-200 text-xs sm:text-sm text-brand-dark-text font-semibold">
          <i data-lucide="layout-template" class="w-4 h-4"></i> Página Web Profesional
        </span>
        <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-highlight ring-1 ring-gray-200 text-xs sm:text-sm text-brand-dark-text font-semibold">
          <i data-lucide="pen-tool" class="w-4 h-4"></i> Redacción Que Convierte
        </span>
        <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-highlight ring-1 ring-gray-200 text-xs sm:text-sm text-brand-dark-text font-semibold">
          <i data-lucide="globe" class="w-4 h-4"></i> Dominio .com Incluido
        </span>
        <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-highlight ring-1 ring-gray-200 text-xs sm:text-sm text-brand-dark-text font-semibold">
          <i data-lucide="server" class="w-4 h-4"></i> Hosting Rápido y Seguro
        </span>
        <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-brand-highlight ring-1 ring-gray-200 text-xs sm:text-sm text-brand-dark-text font-semibold">
          <i data-lucide="shield-check" class="w-4 h-4"></i> Certificado de Seguridad SSL
        </span>
      </div>

      <div class="mt-8">
        <p class="text-base sm:text-lg font-semibold text-slate-600">
          Valor Real del Paquete:
          <span class="text-xl sm:text-2xl font-black line-through text-brand-primary/90">$1,500+</span>
        </p>

        <div class="mt-2">
          <span class="block text-6xl sm:text-7xl md:text-8xl font-black text-brand-secondary leading-none">$197</span>
          <p class="mt-2 text-base sm:text-lg text-gray-700 font-bold">Único pago. Sin cargos ocultos. Sin segunda oportunidad.</p>
          <p class="mt-2 text-xs sm:text-sm text-gray-500 italic">
            *Pago único por la construcción de tu sitio web. A partir del segundo año, solo $125 anuales por la renovación de dominio, hosting y SSL.
          </p>
        </div>
      </div>

      <div class="mt-8">
        <a href="#payment-section"
           class="inline-flex w-full sm:w-auto justify-center items-center gap-2 px-8 py-4 text-lg font-extrabold rounded-2xl
                  bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/20
                  hover:opacity-95 hover:translate-y-[1px] transition">
          SÍ, QUIERO MI PÁGINA WEB AHORA <i data-lucide="lock" class="w-5 h-5"></i>
        </a>
      </div>

      <div class="mt-6 text-gray-700">
        <p class="font-semibold text-base sm:text-lg flex items-center justify-center gap-2">
          <i data-lucide="shield-check" class="w-5 h-5 text-green-600"></i>
          Nuestra Garantía "Ver Para Creer"
        </p>
        <p class="text-gray-600 text-sm sm:text-base mt-1">
          No pagas el total hasta que veas tu web terminada y profesional. <strong>El riesgo es 100% nuestro, la oportunidad es 100% tuya.</strong>
        </p>
      </div>
    </div>

    <div class="mt-4 text-xs sm:text-sm text-brand-primary font-semibold flex flex-wrap items-center justify-center gap-x-4 gap-y-1">
      <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4"></i> Pago 100% Seguro</span>
      <span class="inline-flex items-center gap-1.5"><i data-lucide="headphones" class="w-4 h-4"></i> Soporte Humano</span>
      <span class="inline-flex items-center gap-1.5"><i data-lucide="check-circle-2" class="w-4 h-4"></i> Sin Contratos Ni Ataduras</span>
    </div>
  </div>
</section>

<section id="ai-tools" class="py-20 md:py-24 bg-dark-black-bg text-brand-light-text" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6">
    
    <div class="text-center max-w-5xl mx-auto mb-12">
      <p class="text-sm sm:text-base md:text-2xl font-bold text-brand-highlight uppercase tracking-widest mb-4 md:mb-6 animate-pulse">
        Y UN RECORDATORIO FINAL...
      </p>

      <div class="flex items-center justify-center gap-3 md:gap-4 mb-2">
        <i data-lucide="gift" class="w-6 h-6 md:w-8 md:h-8 text-brand-highlight"></i>
        <span class="text-brand-highlight text-3xl sm:text-4xl md:text-6xl font-black uppercase">EL BONUS DECISIVO</span>
      </div>

      <h3 class="text-2xl sm:text-3xl md:text-5xl font-black text-brand-white uppercase leading-tight">
        El acceso a tu Mini Agencia de Marketing con IA que viste la última vez... 
        <span class="text-brand-highlight">también se va para siempre en 24 horas.</span>
      </h3>
      
      <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full ring-2 ring-white/90 bg-brand-secondary/90 my-3">
        <i data-lucide="badge-dollar-sign" class="w-5 h-5 text-brand-highlight"></i>
        <span class="text-xs sm:text-sm md:text-base font-extrabold tracking-wider text-white uppercase">
          Valorado en <span class="line-through opacity-80">$497</span> — incluido GRATIS solo hoy
        </span>
      </div>
    </div>

    <div class="mt-10 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
      
      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-PlanificadorMarketing.webp" alt="Planificador de Objetivos de Marketing con IA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Planificador de Objetivos de Marketing </h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Un Plan Semanal, Mensual O Trimestral Paso A Paso</p>
          <p class="text-base md:text-lg text-gray-300">
            Deja de improvisar y empieza a crecer con un plan claro. Esta herramienta usa IA para crear un plan de marketing estratégico para ti. No tendrás que adivinar qué hacer a continuación.
          </p>
        </div>
      </article>

      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="100">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-AnunciosPublicitarios.webp" alt="Generador de Anuncios Publicitarios con IA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Generador de Anuncios Publicitarios </h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Textos De Anuncios Que Realmente Venden Para Tus Servicios</p>
          <p class="text-base md:text-lg text-gray-300">
            Transforma tus servicios en anuncios que atraen clientes. Olvídate de adivinar qué funciona y obtén textos persuasivos y listos para usar en tus campañas.
          </p>
        </div>
      </article>

      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="200">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-PublicacionesSociales.webp" alt="Creador de Publicaciones Sociales con IA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Creador de Publicaciones Sociales </h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Posts Que Abordan El Problema, La Solución Y Tu Servicio</p>
          <p class="text-base md:text-lg text-gray-300">
            Nunca te quedes sin ideas para tus redes sociales. Genera textos que captan la atención de tus clientes ideales, muestran tu valor y te posicionan.
          </p>
        </div>
      </article>

      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="300">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-SeguimientoProspectos.webp" alt="Asistente de Seguimiento para Prospectos con IA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
        <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Asistente de Seguimiento para Prospectos</h4>
          <p class="text-brand-highlight leading-snug font-black">Crea Mensajes Para Convertir De Clientes Potenciales En Clientes</p>
          <p class="text-base md:text-lg text-gray-300">
            Cierra ventas después de cotizar con secuencias de seguimiento persuasivas y claras que responden objeciones.
          </p>
        </div>
      </article>

      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="400">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-CotizacionesDigitales.webp" alt="Generador de Cotizaciones Digitales con IA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Generador de Cotizaciones Digitales</h4>
          <p class="text-brand-highlight leading-snug font-black">Genera Cotizaciones Profesionales En PDF En Menos De Un Minuto</p>
          <p class="text-base md:text-lg text-gray-300">
            Proyecta una imagen profesional y acelera el proceso de venta. Crea cotizaciones con tu marca de forma rápida y sencilla.
          </p>
        </div>
      </article>

      <article class="group bg-brand-primary rounded-2xl shadow-xl border border-white/10 overflow-hidden flex flex-col"
               data-aos="fade-up" data-aos-delay="500">
        <div class="relative">
          <div class="w-full">
            <img src="img/MarketingIA-FacturasDigitales.webp" alt="Generador de Facturas Digitales con IA"
                 class="w-full h-full object-cover" loading="lazy">
          </div>
          <span class="absolute top-3 left-3 px-3 py-1 rounded-full text-xs font-black uppercase bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60">
            Incluido GRATIS
          </span>
        </div>
        <div class="p-6 md:p-8 flex flex-col gap-3 grow">
          <h4 class="font-black text-xl md:text-2xl uppercase text-brand-white">Generador de Facturas Digitales </h4>
          <p class="text-brand-highlight leading-snug font-black">Genera Facturas Profesionales Para Tus Servicios Fácilmente</p>
          <p class="text-base md:text-lg text-gray-300">
            Emite facturas en PDF con tu marca y cobra a tiempo. Orden y confianza para ti y tus clientes.
          </p>
        </div>
      </article>

    </div>


    <div class="text-center mt-10">
      <a href="#payment-section" class="inline-flex items-center gap-2 px-8 py-4 text-xl font-extrabold rounded-2xl
                                       bg-brand-highlight text-[#07162D] ring-2 ring-brand-highlight/60 shadow-xl shadow-black/30
                                       hover:opacity-95 hover:translate-y-[1px] transition">
        QUIERO MI WEB CON TODOS LOS BONUS <i data-lucide="arrow-right" class="w-6 h-6"></i>
      </a>
    </div>
    
     <div class="mt-4 text-xs sm:text-sm text-white flex flex-wrap items-center justify-center gap-x-4 gap-y-1">
      <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4"></i> Pago Seguro</span>
      <span class="inline-flex items-center gap-1.5"><i data-lucide="headphones" class="w-4 h-4"></i> Acompañamiento Experto</span>
      <span class="inline-flex items-center gap-1.5"><i data-lucide="check-circle-2" class="w-4 h-4"></i> Sin Contratos</span>
    </div>
    
  </div>
</section>

<section id="course-bonus" class="py-20 md:py-24 text-brand-light-text relative overflow-hidden"
  style="
    background-image:
      linear-gradient(rgba(7,22,45,.92), rgba(7,22,45,.92)),
      url('img/BG02.webp?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');
    background-size: cover; background-position: center;"
  data-aos="fade-up" loading="lazy">

  <div class="pointer-events-none absolute -top-24 -left-24 w-72 h-72 bg-brand-highlight/14 rounded-full blur-3xl"></div>

  <div class="container mx-auto max-w-7xl px-6 relative z-10">
    <div class="text-center max-w-4xl mx-auto">
      <p class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                 bg-brand-secondary/90 text-brand-highlight font-bold tracking-widest uppercase
                 ring-1 ring-brand-highlight/30 shadow-sm text-sm md:text-base mb-3"
         data-aos="fade-up">
        <i data-lucide="award" class="w-4 h-4 md:w-5 md:h-5"></i>
        Y PARA HACER ESTA DECISIÓN INEVITABLE...
      </p>

      <h2 class="font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-white uppercase leading-tight
                 drop-shadow-[0_2px_16px_rgba(0,0,0,.35)]"
          data-aos="fade-up" data-aos-delay="80">
        No Solo Construimos El Motor De Tu Negocio. <span class="text-brand-highlight">Te Entregamos las Llaves.</span>
      </h2>
    </div>

    <div class="mt-12 md:mt-16 grid lg:grid-cols-2 gap-8 lg:gap-12 items-center">
      <div data-aos="fade-right">
        <div class="relative bg-white/5 ring-1 ring-white/10 rounded-2xl p-2 md:p-3 shadow-2xl">
          <img src="img/Domina-El-Marketing.webp"
               alt="Curso Domina El Marketing De Tu Negocio"
               class="w-full h-auto rounded-xl object-cover" loading="lazy">
        </div>
      </div>

      <div data-aos="fade-left">
        <div class="bg-brand-primary/85 backdrop-blur-sm p-6 sm:p-8 rounded-2xl shadow-xl ring-1 ring-white/10">
          <div class="flex items-start gap-4">
            <i data-lucide="graduation-cap" class="w-8 h-8 text-brand-highlight"></i>
            <div>
              <p class="text-sm sm:text-base font-semibold text-brand-highlight uppercase">Bonus Final: Incluido Sólo en esta oferta de 24 horas</p>
              <h3 class="text-2xl sm:text-3xl font-black text-white uppercase leading-tight">
                Domina el marketing de tu negocio en menos de 24 horas
              </h3>
            </div>
          </div>

          <p class="text-base sm:text-lg text-gray-300 mt-4">
            Una web profesional atrae. Pero saber cómo usarla, te hace imparable. Con este curso práctico tomarás el control total:
          </p>

          <ul class="mt-4 space-y-3 text-base sm:text-lg text-gray-200">
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Define una Estrategia Ganadora</strong> para que cada acción de marketing tenga un propósito y un retorno claro.</span>
            </li>
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Escribe Anuncios Que Venden</strong> sin gastar fortunas en otros, atrayendo a los clientes que realmente te interesan.</span>
            </li>
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Crea Contenido Que Conecta</strong> y te posiciona como la autoridad indiscutible en tu área local.</span>
            </li>
            <li class="flex items-start gap-3">
              <i data-lucide="check-circle" class="w-6 h-6 text-green-400 mt-1"></i>
              <span><strong>Usa la Inteligencia Artificial</strong> como tu asistente 24/7 para automatizar tareas y acelerar tu crecimiento.</span>
            </li>
          </ul>

          <div class="mt-8 grid grid-cols-2 overflow-hidden rounded-xl ring-1 ring-brand-highlight/30">
            <div class="p-4 text-center bg-white/5">
              <p class="text-xs sm:text-sm font-bold text-gray-400 uppercase">Valor real</p>
              <p class="text-3xl sm:text-5xl font-bold text-gray-500 line-through decoration-2">$250</p>
            </div>
            <div class="p-4 text-center bg-brand-highlight/10 animate-pulse">
              <p class="text-xs sm:text-sm font-bold text-brand-highlight uppercase">Precio para ti hoy</p>
              <p class="text-3xl sm:text-5xl font-black text-brand-highlight">GRATIS</p>
            </div>
          </div>

          <div class="mt-6 text-center">
            <p class="inline-block bg-brand-secondary text-red-100 font-extrabold text-lg md:text-xl px-5 py-2 rounded-full ring-1 ring-red-500/70">
              Tu Acceso Gratuito Desaparece Con Esta Oferta
            </p>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>

<section id="final-offer-and-payment" class="relative py-20 md:py-24 bg-brand-light-bg overflow-hidden" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6 relative">

<div class="text-center mb-12 md:mb-16">
  <span class="inline-flex items-center gap-2 px-5 py-2 rounded-full bg-brand-secondary text-white font-black tracking-widest ring-1 ring-brand-secondary/40 shadow-sm text-xs sm:text-sm">
    <i data-lucide="zap" class="w-4 h-4"></i>
    LA ÚLTIMA LLAMADA REAL. SIN EXCEPCIONES
  </span>
  <h2 class="mt-6 font-black text-3xl sm:text-4xl md:text-5xl lg:text-6xl text-brand-primary leading-tight uppercase">
    El precio de tu credibilidad online: <span class="text-brand-secondary">$197</span><br class="hidden sm:inline"> El costo de seguir siendo invisible: <span class="text-brand-secondary">Incalculable</span>
  </h2>
  <p class="max-w-3xl mx-auto mt-2 text-sm sm:text-base md:text-lg text-slate-600 font-bold">
    Tu búsqueda de una solución profesional y asequible termina aquí. Lo que sigue es el desglose de la inversión más inteligente que harás este año para el futuro de tu negocio.
  </p>
</div>

    <div class="grid gap-10 lg:grid-cols-2 items-start">

      <div class="relative">
        <div class="bg-white rounded-3xl shadow-2xl ring-1 ring-gray-200 overflow-hidden">
          <div class="bg-slate-50 px-6 sm:px-8 md:px-10 py-5">
            <p class="text-[11px] sm:text-xs font-bold text-slate-500 uppercase">Comprobante de Valor Total</p>
            <p class="text-base sm:text-lg font-black text-slate-800">Tu Paquete Completo – LocalWebPro</p>
          </div>
          <div class="h-3 bg-[radial-gradient(circle,_transparent_2px,_#ffffff_2px)] [background-size:12px_12px]"></div>
          
          <div class="px-6 sm:px-8 md:px-10 py-6 space-y-5">
            <div class="grid grid-cols-1 md:grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed border-slate-200">
              <div class="flex items-start gap-3"><i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i><div><strong class="text-lg md:text-xl text-brand-dark-text font-black">Diseño Web Profesional</strong><em class="block text-sm md:text-base text-gray-500">Eleva la percepción de tu negocio.</em></div></div><span class="text-right text-base md:text-lg font-black text-slate-700">Valor de $1,200</span>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed border-slate-200">
              <div class="flex items-start gap-3"><i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i><div><strong class="text-lg md:text-xl text-brand-dark-text font-black">Textos Que Venden (Copy Persuasivo)</strong><em class="block text-sm md:text-base text-gray-500">Mensajes estratégicos y CTA's efectivas.</em></div></div><span class="text-right text-base md:text-lg font-black text-slate-700">Valor de $500</span>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed border-slate-200">
              <div class="flex items-start gap-3"><i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i><div><strong class="text-lg md:text-xl text-brand-dark-text font-black">Dominio .com Incluido - (1 Año)</strong><em class="block text-sm md:text-base text-gray-500">Nombre profesional y fácil de recordar.</em></div></div><span class="text-right text-base md:text-lg font-black text-slate-700">Valor de $25</span>
            </div>
             <div class="grid grid-cols-1 md:grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed border-slate-200">
              <div class="flex items-start gap-3"><i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i><div><strong class="text-lg md:text-xl text-brand-dark-text font-black">Alojamiento Web Compartido (1 Año)</strong><em class="block text-sm md:text-base text-gray-500">Velocidad y disponibilidad para no perder ventas.</em></div></div><span class="text-right text-base md:text-lg font-black text-slate-700">Valor de $120</span>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-[1fr_auto] gap-3 pb-5 border-b border-dashed border-slate-200">
              <div class="flex items-start gap-3"><i data-lucide="check-circle" class="w-6 h-6 text-green-600 mt-0.5"></i><div><strong class="text-lg md:text-xl text-brand-dark-text font-black">Certificado De Seguridad SSL</strong><em class="block text-sm md:text-base text-gray-500">Protección para tus clientes y mejor experiencia.</em></div></div><span class="text-right text-base md:text-lg font-black text-slate-700">Valor de $75</span>
            </div>
            <div class="rounded-2xl bg-brand-highlight ring-1 ring-yellow-300/60 px-5 py-5">
              <div class="grid grid-cols-1 md:grid-cols-[1fr_auto] gap-3"><div class="flex items-start gap-3"><i data-lucide="gift" class="w-6 h-6 text-brand-secondary mt-0.5"></i><strong class="text-lg md:text-xl text-brand-primary font-black">BONUS #1: Tu Propia Agencia De Marketing Impulsada Con IA</strong></div><span class="text-right text-base md:text-lg font-black text-brand-secondary">Valor de $497</span></div>
              <div class="mt-4 grid grid-cols-1 md:grid-cols-[1fr_auto] gap-3"><div class="flex items-start gap-3"><i data-lucide="gift" class="w-6 h-6 text-brand-secondary mt-0.5"></i><strong class="text-lg md:text-xl text-brand-primary font-black">BONUS #2: Domina El Marketing De Tu Negocio En Menos De 24 Horas</strong></div><span class="text-right text-base md:text-lg font-black text-brand-secondary">Valor de $250</span></div>
            </div>
          </div>
          <div class="h-3 bg-[radial-gradient(circle,_transparent_2px,_#ffffff_2px)] [background-size:12px_12px]"></div>
        </div>
      </div>

      <aside class="relative">
        <div class="sticky top-24 bg-brand-primary text-white rounded-3xl p-6 sm:p-8 shadow-2xl ring-1 ring-brand-primary/40 text-center">
            
            <h3 class="text-2xl font-black text-white uppercase">Tu Decisión Final</h3>
            <p class="mt-4 text-base font-black text-slate-300">VALOR TOTAL DEL PAQUETE</p>
            <p class="text-5xl md:text-6xl font-black text-slate-500 line-through decoration-red-500 decoration-4 my-1">$2,647</p>

            <p class="mt-4 text-lg font-black text-white">PRECIO FINAL HOY: <span class="text-brand-highlight">$197</span></p>

            <div class="my-6 bg-white/5 border-2 border-dashed border-white/20 rounded-xl p-4">
                <p class="font-bold text-white uppercase">Y CON NUESTRA GARANTÍA DE CERO RIESGO...</p>
                <p class="mt-2 text-lg text-white/80">Empiezas Hoy Con Solo:</p>
                <p class="text-7xl sm:text-8xl font-black text-brand-highlight leading-none my-2">$27</p>
                <p class="text-base text-white/90">Pagas el resto (<strong>$170</strong>) únicamente si apruebas el resultado final.</p>
            </div>
            
            <div class="mt-6 flex flex-col space-y-3">
                <a href="pay.php?p=card" target="_blank" class="inline-flex items-center justify-center gap-3 w-full py-4 text-xl font-extrabold rounded-2xl bg-brand-highlight text-brand-primary hover:opacity-95 hover:translate-y-[1px] transition shadow-lg">
                    <i data-lucide="credit-card" class="w-6 h-6"></i>
                    PAGAR $27 CON TARJETA
                </a>

                <a href="pay.php?p=paypal" target="_blank" class="inline-flex items-center justify-center gap-3 w-full py-4 text-xl font-extrabold rounded-2xl bg-blue-600 hover:bg-blue-700 text-white transition shadow-lg">
                    <i data-lucide="check-circle" class="w-6 h-6"></i>
                    PAGAR $27 CON PAYPAL
                </a>
            </div>

            <div class="mt-6 flex flex-wrap items-center justify-center gap-4 text-xs sm:text-sm text-gray-200 font-bold">
                <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4"></i> Garantía "Ver Para Creer"</span>
                <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4"></i> Pago 100% Seguro</span>
            </div>
        </div>
      </aside>

    </div>
  </div>
</section>

<section id="cta-section" class="py-20 md:py-24 bg-brand-primary text-white" data-aos="fade-up">
  <div class="container mx-auto max-w-7xl px-6 text-center">

    <div class="flex justify-center mb-4">
      <i data-lucide="clock" class="w-14 h-14 md:w-16 md:h-16 text-brand-highlight"></i>
    </div>
    <p class="text-sm sm:text-base md:text-xl mt-2 text-brand-highlight font-semibold uppercase tracking-widest">
      Lo que hagas antes de que el reloj llegue a cero, define tu futuro
    </p>
    <h2 class="mt-2 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black uppercase leading-tight">
      Mañana: ¿Seguirás dudando o empezarás a <span class="text-brand-highlight">verte profesional</span>?
    </h2>

    <div class="mt-4 flex flex-wrap items-center justify-center gap-2">
      <span class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full bg-white/10 ring-1 ring-white/20 text-sm sm:text-sm font-bold">
        <i data-lucide="timer" class="w-4 h-4"></i> EL TIEMPO SE ACABA
      </span>
    </div>

    <div class="my-10 md:my-12 max-w-4xl mx-auto" data-aos="fade-up" data-aos-delay="80">
      <img src="img/Paquete-Web.webp" alt="Paquete Web LocalWebPro"
           class="w-full" loading="lazy">
    </div>

    <div
      class="relative mx-auto max-w-3xl rounded-2xl shadow-2xl ring-2 ring-brand-highlight/60 p-[1px] bg-gradient-to-br from-brand-highlight/40 via-white/10 to-brand-highlight/20"
      data-aos="zoom-in" data-aos-delay="120"
      id="cta-timer-card" aria-labelledby="cta-deadline-label">

      <div class="relative rounded-2xl bg-[#0b1b33]/90 backdrop-blur-sm p-6 sm:p-8 md:p-10 pt-10 overflow-visible">
        
        <span class="absolute -top-5 left-1/2 -translate-x-1/2 z-20 px-3 py-1 rounded-full
                     bg-brand-highlight text-[#07162D] text-xs sm:text-sm font-black uppercase
                     ring-2 ring-brand-highlight/70 shadow">
          TU ACCESO FINAL AL PAQUETE COMPLETO
        </span>

        <p id="cta-deadline-label" class="text-xl md:text-2xl font-black text-brand-highlight uppercase leading-tight">
          Este precio y los bonus desaparecen en:
        </p>

        <div id="countdown" class="mt-4 grid grid-cols-3 gap-3 sm:gap-4">
    <div class="flex flex-col items-center bg-white/5 rounded-xl py-3 sm:py-4 ring-1 ring-white/10">
        <span id="hours" class="tabular-nums text-4xl sm:text-6xl font-black leading-none">23</span>
        <span class="mt-1 text-[11px] sm:text-xs uppercase tracking-widest text-gray-300">Horas</span>
    </div>
    <div class="flex flex-col items-center bg-white/5 rounded-xl py-3 sm:py-4 ring-1 ring-white/10">
        <span id="minutes" class="tabular-nums text-4xl sm:text-6xl font-black leading-none">59</span>
        <span class="mt-1 text-[11px] sm:text-xs uppercase tracking-widest text-gray-300">Minutos</span>
    </div>
    <div class="flex flex-col items-center bg-white/5 rounded-xl py-3 sm:py-4 ring-1 ring-white/10">
        <span id="seconds" class="tabular-nums text-4xl sm:text-6xl font-black leading-none animate-pulse">23</span>
        <span class="mt-1 text-[11px] sm:text-xs uppercase tracking-widest text-gray-300">Segundos</span>
    </div>
</div>

        <p class="mt-6 text-center text-sm sm:text-base font-bold text-red-300">
          La oferta completa termina cuando el reloj llegue a cero. <span class="opacity-80">(Sin Excepciones)</span>
        </p>
      </div>
    </div>

    <div class="mt-8">
      <a id="cta-button" href="#final-offer-and-payment"
         class="btn btn-highlight text-lg md:text-2xl btn-pulse inline-flex items-center justify-center gap-2
                px-8 py-4 rounded-2xl shadow-xl shadow-black/30 ring-2 ring-brand-highlight/60
                hover:translate-y-[1px] hover:opacity-95 transition">
        <i data-lucide="zap" class="w-5 h-5"></i>
        ¡SÍ, QUIERO EMPEZAR CON $27!
        <i data-lucide="arrow-right" class="w-5 h-5"></i>
      </a>

      <div class="mt-4 flex flex-wrap items-center justify-center gap-4 text-xs sm:text-sm text-white/90">
        <span class="inline-flex items-center gap-1.5">
          <i data-lucide="lock" class="w-4 h-4"></i> Compra Segura
        </span>
        <span class="inline-flex items-center gap-1.5">
          <i data-lucide="check-circle-2" class="w-4 h-4"></i> Sin Contratos
        </span>
        <span class="inline-flex items-center gap-1.5">
          <i data-lucide="headphones" class="w-4 h-4"></i> Soporte Humano
        </span>
      </div>
    </div>

  </div>
</section>

<section id="faq" class="py-16 md:py-24 bg-brand-light-bg">
  <div class="container mx-auto max-w-7xl px-4 sm:px-6">

    <div class="text-center max-w-4xl mx-auto mb-12 sm:mb-16" data-aos="fade-up">
      <span class="inline-flex items-center gap-2 px-5 py-2 rounded-full bg-brand-highlight/90 text-brand-primary font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-sm md:text-base">
        <i data-lucide="shield-check" class="w-4 h-4"></i>
        Respuestas Finales Antes de Actuar
      </span>

      <h2 class="mt-6 text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-brand-primary uppercase leading-[1.05]">
        Basta de dudas. <span class="text-brand-secondary">Es hora de tener la certeza</span> que tu negocio merece.
      </h2>

      <span class="block mx-auto mt-4 h-1.5 w-32 rounded-full bg-brand-secondary"></span>
    </div>

    <div class="grid lg:grid-cols-2 gap-x-16 gap-y-12 items-start">

      <div class="lg:sticky top-24" data-aos="fade-right">
       <div class="bg-brand-primary text-white p-6 pt-10 rounded-3xl shadow-2xl ring-1 ring-brand-highlight/40 relative overflow-visible">

         <span class="absolute top-0 left-1/2 -translate-x-1/2 -translate-y-1/2
                      px-4 py-1.5 rounded-full bg-brand-highlight text-[#07162D]
                      font-black uppercase text-xs ring-2 ring-brand-highlight/70 shadow-md z-20 whitespace-nowrap">
           Nuestra Garantía "Ver Para Creer"
         </span>

         <div class="text-center">
           <h4 class="font-black text-2xl sm:text-3xl uppercase">Tu Inversión Está Blindada</h4>
           <p class="mt-2 text-base text-white/80">Inicias con solo <b>$27</b>. No pagas un centavo más hasta que apruebes el resultado.</p>
         </div>

         <div class="mt-8 flex flex-col sm:flex-row gap-4">
           <div class="bg-white/10 rounded-xl p-4 text-center flex-1">
             <i data-lucide="shield-check" class="w-8 h-8 text-emerald-400 mx-auto"></i>
             <p class="mt-2 text-sm font-bold">Riesgo Cero</p>
             <p class="text-xs text-white/70 mt-1">SI NO TE ENCANTA, NO PAGAS EL RESTO</p>
           </div>
           <div class="bg-white/10 rounded-xl p-4 text-center flex-1">
             <i data-lucide="rocket" class="w-8 h-8 text-blue-400 mx-auto"></i>
             <p class="mt-2 text-sm font-bold">Velocidad Máxima</p>
             <p class="text-xs text-white/70 mt-1">TU WEB LISTA EN 3 DÍAS HÁBILES</p>
           </div>
           <div class="bg-white/10 rounded-xl p-4 text-center flex-1">
             <i data-lucide="coins" class="w-8 h-8 text-yellow-300 mx-auto"></i>
             <p class="mt-2 text-sm font-bold">Inversión Inteligente</p>
             <p class="text-xs text-white/70 mt-1">$27 AHORA · $170 AL APROBAR</p>
           </div>
         </div>

         <div class="mt-8 bg-white/5 rounded-xl p-5 text-sm">
           <h5 class="font-extrabold mb-3 text-brand-highlight uppercase">Nuestro Modelo vs. El Riesgo Tradicional</h5>
           <ul class="space-y-2">
             <li class="flex items-start gap-2">
               <i data-lucide="check" class="w-5 h-5 text-emerald-400 flex-shrink-0"></i>
               <span><b>Con Nosotros:</b> Inviertes el total solo si estás 100% satisfecho.</span>
             </li>
             <li class="flex items-start gap-2">
               <i data-lucide="x" class="w-5 h-5 text-red-400 flex-shrink-0"></i>
               <span><b>Con Agencias:</b> Arriesgas el 50% o 100% de tu dinero por adelantado.</span>
             </li>
           </ul>
         </div>

         <div class="mt-6 pt-4 border-t border-white/20 text-center">
           <a href="#final-offer-and-payment"
              class="inline-flex items-center justify-center gap-2 w-full px-6 py-4 text-lg font-extrabold rounded-2xl
                     bg-brand-highlight text-[#07162D] shadow-lg shadow-black/20
                     hover:opacity-95 hover:translate-y-[1px] transition animate-pulse">
             EMPEZAR AHORA CON SOLO $27
             <i data-lucide="arrow-right" class="w-5 h-5"></i>
           </a>
           <p class="mt-3 text-xs text-white/70 flex items-center justify-center gap-1">
             <i data-lucide="lock" class="w-4 h-4"></i> Compra 100% Segura y Protegida
           </p>
         </div>
       </div>
     </div>

     <div class="space-y-4" data-aos="fade-left">

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2"><i data-lucide="help-circle" class="w-5 h-5 text-brand-secondary"></i> YA ME DECEPCIONARON ANTES, ¿POR QUÉ ESTO ES DIFERENTE?</span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600 space-y-3">
           <p>Porque no entregamos "páginas bonitas", entregamos <b>activos de negocio diseñados para convertir.</b> La diferencia es la estrategia: cada palabra y cada botón tienen el único objetivo de que tu visitante se convierta en cliente. No es solo diseño, es ingeniería de resultados.</p>
         </div>
       </details>

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2"><i data-lucide="wallet" class="w-5 h-5 text-brand-secondary"></i> ¿Y SI PIERDO MIS $27?</span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>Es imposible. Piensa en los $27 como tu boleto para ver el producto final sin compromiso. Si lo que construimos no te convence al 100% de que vale la inversión total, no pagas el resto. <b>El único que arriesga tiempo y recursos aquí, somos nosotros.</b></p>
         </div>
       </details>

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2"><i data-lucide="clock-7" class="w-5 h-5 text-brand-secondary"></i> ¿REALMENTE LA ENTREGAN EN 3 DÍAS?</span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>Sí, en <b>3 días hábiles o menos.</b> No creemos en las esperas, porque cada día que tu negocio no tiene una presencia online profesional es un día que le regalas clientes a tu competencia.</p>
         </div>
       </details>
       
       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2"><i data-lucide="file-text" class="w-5 h-5 text-brand-secondary"></i> ¿HAY CARGOS OCULTOS DESPUÉS DE LOS $197?</span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>No. Los <b>$197 son un pago único</b> por toda la construcción. A partir del segundo año, solo hay una cuota de <b>$125 anuales</b> para mantener activos tu dominio, hosting y certificado de seguridad. Transparencia total.</p>
         </div>
       </details>

       <details class="group bg-white p-5 rounded-xl border border-slate-200 hover:border-brand-secondary open:shadow-md open:bg-slate-50 transition-all duration-300">
         <summary class="font-bold text-base sm:text-lg cursor-pointer list-none flex justify-between items-center text-brand-dark-text">
           <span class="flex items-center gap-2"><i data-lucide="zap" class="w-5 h-5 text-brand-secondary"></i> ¿CUÁL ES EL TRUCO DE UN PRECIO TAN BAJO?</span>
           <i data-lucide="chevron-down" class="w-5 h-5 transition-transform duration-300 group-open:rotate-180 text-brand-secondary"></i>
         </summary>
         <div class="mt-4 text-gray-600">
           <p>El "truco" es la <b>eficiencia</b>. No empezamos de cero. Usamos nuestra propia plataforma estratégica ya probada y la personalizamos para tu negocio. Esto nos permite entregarte un producto de altísimo valor a una fracción del costo, sin sacrificar la calidad profesional. Ganas tú en el precio, ganamos nosotros en velocidad.</p>
         </div>
       </details>

     </div>
    </div>
  </div>
</section>

<section id="testimonials-section" class="py-16 md:py-24 bg-brand-primary">
  <div class="container mx-auto max-w-7xl px-4 sm:px-6">
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">

      <div class="video-container" data-aos="fade-right">
        <div class="relative h-0 pb-[56.25%] rounded-2xl sm:rounded-3xl overflow-hidden shadow-2xl ring-1 ring-white/10">
          <div class="pointer-events-none absolute inset-0 rounded-2xl sm:rounded-3xl ring-2 sm:ring-4 ring-brand-highlight/80"></div>

          <iframe
            class="absolute top-0 left-0 w-full h-full"
            src="https://www.youtube.com/embed/nJz7fgflh-E"
            title="Testimonios de Clientes Satisfechos"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
            allowfullscreen></iframe>

          <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
        </div>

        <div class="mt-6 grid grid-cols-3 gap-3 text-center">
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="50">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">5.0</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Satisfacción</p>
          </div>
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="100">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">+250</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">Negocios Impulsados</p>
          </div>
          <div class="rounded-xl bg-white/5 text-white/90 p-3 ring-1 ring-white/10" data-aos="zoom-in" data-aos-delay="150">
            <p class="text-xl sm:text-2xl font-black text-brand-highlight">16 AÑOS</p>
            <p class="text-[11px] sm:text-xs font-semibold uppercase tracking-wide text-white/70">De Experiencia</p>
          </div>
        </div>
      </div>

      <div class="text-content text-brand-white" data-aos="fade-left" data-aos-delay="100">
        <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-brand-highlight/90 text-brand-primary font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-sm md:text-base">
          <i data-lucide="award" class="w-4 h-4"></i>
          LA PRUEBA DE QUE TOMAR LA DECISIÓN CORRECTA, FUNCIONA
        </div>

        <h2 class="text-3xl sm:text-4xl md:text-5xl font-black uppercase text-white leading-[1.05]">
          No escuches nuestras palabras. Escucha sus resultados.
        </h2>
        <span class="block mt-3 h-1.5 w-16 rounded-full bg-brand-secondary"></span>

        <p class="mt-6 text-base sm:text-lg text-white/80">
          La duda antes de invertir es normal. Por eso, te invitamos a ver el impacto real a través de los ojos de dueños de negocios que estaban exactamente donde tú estás ahora. Ellos dieron el paso, y esta es la tranquilidad y la imagen profesional que consiguieron.
        </p>

        <div class="mt-6 flex flex-wrap items-center gap-x-4 gap-y-2 text-xs text-white/70">
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="shield-check" class="w-4 h-4 text-brand-highlight"></i> Garantía Cero Riesgo
          </span>
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="badge-check" class="w-4 h-4 text-brand-highlight"></i> Confianza Demostrada
          </span>
          <span class="inline-flex items-center gap-1.5">
            <i data-lucide="thumbs-up" class="w-4 h-4 text-brand-highlight"></i> Clientes Satisfechos
          </span>
        </div>
      </div>

    </div>
  </div>
</section>

<div id="exit-intent-popup" class="hidden fixed inset-0 z-[100]">
  <div id="popup-overlay" class="absolute inset-0 bg-brand-primary/80 backdrop-blur-md opacity-0 transition-opacity duration-300"></div>

  <div class="relative h-full w-full flex items-center justify-center p-4">
    <div id="popup-card"
         role="dialog"
         aria-modal="true"
         aria-labelledby="exit-popup-title"
         class="bg-brand-primary rounded-2xl sm:rounded-3xl shadow-2xl w-full max-w-5xl grid md:grid-cols-2 overflow-hidden 
                transform transition-all duration-300 scale-95 opacity-0">

      <div class="hidden md:block relative">
        <img src="img/Espera.webp"
             alt="No Dejes Pasar La Oferta Por Segunda Vez"
             class="w-full h-full object-cover" loading="lazy">
        <div class="pointer-events-none absolute inset-0 bg-gradient-to-t from-black/40 to-transparent"></div>
      </div>

      <div class="p-6 sm:p-8 md:p-12 text-center flex flex-col justify-center relative text-white">
        <button id="close-popup"
                class="absolute top-3 right-3 sm:right-4 h-10 w-10 rounded-full flex items-center justify-center text-white/70 hover:text-white hover:bg-white/10 transition"
                aria-label="Cerrar ventana emergente">
          &times;
        </button>

        <span class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-brand-highlight/20 text-brand-highlight font-extrabold tracking-[0.08em] uppercase ring-1 ring-black/5 text-[11px] sm:text-xs mx-auto mb-4">
          <i data-lucide="history" class="w-4 h-4"></i>
          LA HISTORIA SE REPITE... ¿O NO?
        </span>

        <h2 id="exit-popup-title" class="text-2xl sm:text-3xl lg:text-4xl font-black uppercase leading-tight">
          Ya la dejaste pasar una vez. ¿De verdad vas a cometer el mismo error <span class="text-brand-highlight">dos veces</span>?
        </h2>

        <div class="my-6 bg-white/5 ring-1 ring-white/10 rounded-2xl py-4 sm:py-6 px-4">
          <p class="text-base sm:text-lg text-white/80">Esta Oferta De <b>Cero Riesgo</b> NO Volverá:</p>
          <p class="text-6xl sm:text-7xl font-black text-brand-highlight my-2">$27</p>
          <p class="text-base sm:text-lg text-green-400 font-semibold flex flex-col justify-center items-center gap-1">
            <span>PARA INICIAR HOY MISMO.</span>
            <span>EL RESTO, SOLO SI TE GUSTA EL RESULTADO.</span>
          </p>
        </div>

        <div class="space-y-3">
          <a href="pay.php?p=card" target="_blank"
             class="btn btn-primary w-full text-base sm:text-lg md:text-xl flex items-center justify-center gap-3 py-4 rounded-2xl shadow-lg hover:shadow-xl transition">
            <i data-lucide="credit-card" class="w-6 h-6"></i>
            NO, ESTA VEZ SÍ INVIERTO $27
          </a>

          <a href="pay.php?p=paypal" target="_blank"
             class="w-full text-base sm:text-lg md:text-xl flex items-center justify-center gap-3 py-4 rounded-2xl bg-blue-600 hover:bg-blue-700 text-white shadow-lg hover:shadow-xl transition">
            <i data-lucide="check-circle" class="w-6 h-6"></i>
            NO, ESTA VEZ SÍ INVIERTO $27
          </a>
        </div>

        <div class="mt-4 flex flex-wrap items-center justify-center gap-x-4 gap-y-1 text-xs text-white/70">
          <span class="inline-flex items-center gap-1.5"><i data-lucide="shield-check" class="w-4 h-4 text-brand-highlight"></i> Garantía Cero Riesgo</span>
          <span class="inline-flex items-center gap-1.5"><i data-lucide="lock" class="w-4 h-4 text-brand-highlight"></i> Pago 100% Seguro</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div id="social-proof-toast" class="fixed bottom-4 w-[90%] max-w-sm bg-brand-primary border-2 border-brand-highlight rounded-lg shadow-2xl p-4 z-50 
             left-1/2 sm:left-6 sm:-translate-x-0">
    <div class="flex items-start gap-3">
        <div class="flex-shrink-0">
            <img id="toast-image" src="" alt="Cliente Satisfecho" class="h-12 w-12 rounded-full border-2 border-white object-cover bg-gray-700" loading="lazy">
        </div>
        <div class="flex-grow">
            <p id="toast-message" class="text-white font-bold text-sm sm:text-base">Alguien De Texas Acaba De Empezar</p>
            <p class="text-xs sm:text-sm text-gray-400">Hace Unos Momentos</p>
        </div>
        <button id="close-toast" class="text-gray-500 hover:text-white text-2xl leading-none flex-shrink-0">&times;</button>
    </div>
</div>

    </main>

<?php require_once 'files/footer.php'; ?>


    <button id="back-to-top" title="Volver Arriba">
        <i data-lucide="arrow-up" class="text-xl"></i>
    </button>

<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
      {
        "@type": "Question",
        "name": "Ya me decepcionaron antes, ¿por qué esto es diferente?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Porque no entregamos 'páginas bonitas', sino activos de negocio diseñados para convertir. La diferencia es la estrategia: cada palabra y cada botón tienen el único objetivo de que tu visitante se convierta en cliente. No es solo diseño, es ingeniería de resultados."
        }
      },
      {
        "@type": "Question",
        "name": "¿Qué pasa si invierto los $27 y no me gusta el resultado?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Absolutamente nada. El pago inicial de $27 es tu acceso sin compromiso para ver el sitio web terminado. Si el resultado no te convence al 100%, simplemente no pagas el resto ($170). El riesgo es completamente nuestro."
        }
      },
      {
        "@type": "Question",
        "name": "¿Realmente entregan la página web en 3 días?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Sí, en 3 días hábiles o menos. Priorizamos la velocidad porque cada día que tu negocio no tiene una presencia online profesional es un día que le regalas clientes a tu competencia."
        }
      },
      {
        "@type": "Question",
        "name": "El precio de $197, ¿es un pago único o hay cargos ocultos?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Es un pago único de $197 por el diseño y la construcción completa. El único costo adicional es una cuota anual de $125 a partir del segundo año para mantener activos tu dominio, hosting y certificado de seguridad. Transparencia total."
        }
      },
      {
        "@type": "Question",
        "name": "¿Cuál es el truco de un precio tan bajo?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "El secreto es la eficiencia, no un truco. Usamos nuestra propia plataforma estratégica ya probada y la personalizamos para tu negocio. Esto nos permite entregarte un producto de altísimo valor a una fracción del costo y tiempo de una agencia tradicional."
        }
      },
      {
        "@type": "Question",
        "name": "¿El paquete incluye los textos, imágenes y diseño para móviles?",
        "acceptedAnswer": {
          "@type":": "Answer",
          "text": "Sí, lo incluye todo. Nos encargamos de la redacción persuasiva (copywriting), seleccionamos imágenes profesionales para tu negocio y garantizamos un diseño que se vea perfecto en cualquier dispositivo móvil para maximizar la conversión."
        }
      },
      {
        "@type": "Question",
        "name": "¿Quién es el dueño del dominio y la página web?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Tú. Desde el primer momento, el dominio se registra a tu nombre y tienes la propiedad total de tu página web. Te garantizamos el control total sobre tus activos digitales."
        }
      }
    ]
}
</script>
</body>
</html>