document.addEventListener('DOMContentLoaded', () => {

  /**
   * -------------------------------------------
   * INICIALIZACIÓN DE LIBRERÍAS EXTERNAS
   * -------------------------------------------
   */
  const initLibraries = () => {
    if (typeof AOS !== 'undefined') {
      AOS.init({ duration: 800, once: true, offset: 50, easing: 'ease-out-cubic' });
    }
    if (typeof lucide !== 'undefined') {
      lucide.createIcons();
    }
  };

  /**
   * -------------------------------------------
   * LÓGICA DEL FOOTER
   * -------------------------------------------
   */
  const updateFooterYear = () => {
    const yearEl = document.getElementById('year');
    if (yearEl) {
      yearEl.textContent = new Date().getFullYear();
    }
  };

  /**
   * -------------------------------------------
   * LÓGICA DEL BOTÓN "VOLVER ARRIBA"
   * -------------------------------------------
   */
  const setupBackToTopButton = () => {
    const backToTopButton = document.getElementById('back-to-top');
    if (!backToTopButton) return;

    window.addEventListener('scroll', () => {
      if (window.scrollY > 300) {
        backToTopButton.classList.add('show');
      } else {
        backToTopButton.classList.remove('show');
      }
    });

    backToTopButton.addEventListener('click', () => {
      window.scrollTo({ top: 0, behavior: 'smooth' });
    });
  };

  /**
   * -------------------------------------------
   * LÓGICA DEL MENÚ MÓVIL
   * -------------------------------------------
   */
  const setupMobileMenu = () => {
    const menuToggle = document.getElementById('menu-toggle');
    const mobileMenu = document.getElementById('mobile-menu');
    const closeButton = document.getElementById('mm-close');
    const backdrop = document.getElementById('mm-backdrop');
    const menuLinks = document.querySelectorAll('#mobile-menu nav a');
    const body = document.body;

    if (!menuToggle || !mobileMenu) return;

    const openMenu = () => {
      mobileMenu.classList.remove('hidden');
      body.style.overflow = 'hidden';
    };

    const closeMenu = () => {
      mobileMenu.classList.add('hidden');
      body.style.overflow = '';
    };

    menuToggle.addEventListener('click', openMenu);
    if (closeButton) closeButton.addEventListener('click', closeMenu);
    if (backdrop) backdrop.addEventListener('click', closeMenu);
    menuLinks.forEach(link => link.addEventListener('click', closeMenu));
    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape' && !mobileMenu.classList.contains('hidden')) {
        closeMenu();
      }
    });
  };

  /**
   * -------------------------------------------
   * LÓGICA DE LA NOTIFICACIÓN DE PRUEBA SOCIAL
   * -------------------------------------------
   */
  const setupSocialProofToast = () => {
    // ... (Tu código de prueba social existente va aquí, sin cambios)
    const toastElement = document.getElementById('social-proof-toast');
    if (!toastElement) return;
    const messageElement = document.getElementById('toast-message');
    const imageElement = document.getElementById('toast-image');
    const closeButton = document.getElementById('close-toast');
    const clients = [
         { name: "Maria S. De Houston, TX", image: "clientes/MariaS.webp" },
         { name: "John D. De Miami, FL", image: "clientes/JohnD.webp" },
         { name: "Carlos R. De Los Angeles, CA", image: "clientes/CarlosR.webp" },
         { name: "Sofia L. De Chicago, IL", image: "clientes/SofiaL.webp" },
         { name: "David P. De Phoenix, AZ", image: "clientes/DavidP.webp" },
         { name: "Ana B. De Philadelphia, PA", image: "clientes/AnaB.webp" },
         { name: "José M. De San Antonio, TX", image: "clientes/JoseM.webp" },
         { name: "Laura F. De San Diego, CA", image: "clientes/LauraF.webp" }
    ];
    const showToast = () => {
        const randomClient = clients[Math.floor(Math.random() * clients.length)];
        const finalMessage = `${randomClient.name} Acaba De Realizar Su Pago Inicial De $27`;
        if(messageElement) messageElement.textContent = finalMessage;
        if(imageElement) imageElement.src = randomClient.image;
        toastElement.classList.add('show');
        setTimeout(() => {
          toastElement.classList.remove('show');
        }, 6000);
    };
    if (closeButton) {
        closeButton.addEventListener('click', () => {
            toastElement.classList.remove('show');
        });
    }
    const startToastCycle = () => {
        const randomInterval = Math.floor(Math.random() * (22000 - 9000 + 1)) + 9000;
        setTimeout(() => {
          showToast();
          startToastCycle();
        }, randomInterval);
    };
    setTimeout(startToastCycle, 12000);
  };

  /**
   * -------------------------------------------
   * LÓGICA DEL POP-UP DE INTENCIÓN DE SALIDA
   * -------------------------------------------
   */
    const popup = document.getElementById('exit-intent-popup');
    if (popup) {
        const popupOverlay = document.getElementById('popup-overlay');
        const popupCard = document.getElementById('popup-card');
        const popupCloseButton = document.getElementById('close-popup');
        const popupLinks = document.querySelectorAll('#exit-intent-popup a');
        let popupShown = false;

        const showPopup = () => {
            if (popupShown) return;
            popupShown = true;
            popup.classList.remove('hidden');
            setTimeout(() => {
                if (popupOverlay) popupOverlay.classList.remove('opacity-0');
                if (popupCard) popupCard.classList.remove('scale-95', 'opacity-0');
            }, 50);
        };
        const hidePopup = () => {
            if (!popupShown) return;
            popupShown = false;
            if (popupOverlay) popupOverlay.classList.add('opacity-0');
            if (popupCard) popupCard.classList.add('scale-95', 'opacity-0');
            setTimeout(() => popup.classList.add('hidden'), 300);
        };

        document.addEventListener('mouseout', e => { if (e.clientY < 20) showPopup(); });

        let hasScrolledDeep = false;
        const scrollTriggerPoint = 800;
        document.addEventListener('scroll', () => {
            const currentScrollY = window.scrollY;
            if (!hasScrolledDeep && currentScrollY > scrollTriggerPoint) hasScrolledDeep = true;
            if (hasScrolledDeep && currentScrollY < 50) {
                showPopup();
                hasScrolledDeep = false;
            }
        }, { passive: true });

        if (popupCloseButton) popupCloseButton.addEventListener('click', hidePopup);
        if (popupOverlay) popupOverlay.addEventListener('click', hidePopup);
        popupLinks.forEach(link => link.addEventListener('click', hidePopup));
        document.addEventListener('keydown', e => { if (e.key === 'Escape' && popupShown) hidePopup(); });
    }

  // --- EJECUTAR TODAS LAS FUNCIONES ---
  initLibraries();
  updateFooterYear();
  setupBackToTopButton();
  setupMobileMenu();
  setupSocialProofToast();
  setupExitIntentPopup(); 
});