<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contactanos | OrozDesign Multimedia</title>

    <link rel="icon" href="../oferta-web/img/favicon.webp" sizes="any">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest" defer></script>

    <link rel="stylesheet" href="../oferta-web/style.css">
    <script src="../oferta-web/script.js"></script>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand-primary': '#07162d',
                        'brand-secondary': '#9e1428',
                        'brand-highlight': '#ffc857',
                        'brand-light-bg': '#f5f5f5',
                        'brand-white': '#FFFFFF',
                        'brand-dark-text': '#07080a',
                        'brand-light-text': '#f3f4f6',
                    },
                    fontFamily: { 
                        'sans': ['Barlow', 'sans-serif'] 
                    }
                }
            }
        }
    </script>
</head>
<body class="font-sans bg-brand-light-bg text-brand-dark-text">

    <header class="bg-brand-primary/95 border-b border-white/10 backdrop-blur sticky top-0 z-50">
        <div class="mx-auto max-w-7xl px-4 sm:px-6">
            <div class="h-16 md:h-20 flex items-center justify-between">
                <a href="/" class="flex items-center gap-3"><img src="../oferta-web/img/OrozDesignMultimedia.webp" alt="Logo OrozDesign Multimedia" class="h-8 md:h-10 w-auto"></a>
                <a href="/" class="font-bold text-white hover:text-brand-highlight uppercase tracking-wide text-sm">Volver al Inicio</a>
            </div>
        </div>
    </header>

    <main class="container mx-auto max-w-3xl px-6 py-16 md:py-24">
        
        <div class="text-center">
            <h1 class="font-black text-4xl md:text-6xl text-brand-primary uppercase tracking-tight leading-tight">¿LISTO PARA CRECER?</h1>
            <div class="w-24 h-1.5 rounded-full bg-brand-secondary mx-auto mt-4"></div>
            <p class="mt-4 text-lg md:text-xl text-gray-600 max-w-2xl mx-auto">
                Completa el formulario y uno de nuestros estrategas se pondrá en contacto contigo en menos de 24 horas para discutir cómo podemos ayudarte a conseguir más clientes.
            </p>
        </div>

        <div class="mt-12 bg-white p-8 md:p-10 rounded-2xl shadow-2xl border-t-4 border-brand-secondary">
            
            <form id="contact-form" class="space-y-6">
                
                <div class="relative">
                    <label for="name" class="font-bold text-brand-primary block mb-2">Nombre Completo</label>
                    <i data-lucide="user" class="absolute left-3 top-11 w-5 h-5 text-gray-400"></i>
                    <input type="text" id="name" name="name" required placeholder="Ej: Juan Pérez" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-highlight transition">
                </div>
                
                <div class="grid md:grid-cols-2 gap-6">
                    <div class="relative">
                        <label for="email" class="font-bold text-brand-primary block mb-2">Correo Electrónico</label>
                        <i data-lucide="mail" class="absolute left-3 top-11 w-5 h-5 text-gray-400"></i>
                        <input type="email" id="email" name="email" required placeholder="tu@correo.com" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-highlight transition">
                    </div>
                    <div class="relative">
                        <label for="phone" class="font-bold text-brand-primary block mb-2">Teléfono (10 dígitos)</label>
                        <i data-lucide="phone" class="absolute left-3 top-11 w-5 h-5 text-gray-400"></i>
                        <input type="tel" id="phone" name="phone" required placeholder="Ej: 5551234567" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-highlight transition">
                    </div>
                </div>

                <div class="relative">
                    <label for="service" class="font-bold text-brand-primary block mb-2">Servicio de Interés</label>
                    <i data-lucide="briefcase" class="absolute left-3 top-11 w-5 h-5 text-gray-400"></i>
                    <select id="service" name="service" required class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-highlight transition bg-white appearance-none">
                        <option value="" disabled selected>Selecciona un servicio...</option>
                        <option value="Pagina Web Profesional">Página Web Profesional</option>
                        <option value="Marketing Digital">Marketing Digital</option>
                        <option value="Otro">Otro</option>
                    </select>
                </div>

                <div class="relative">
                    <label for="message" class="font-bold text-brand-primary block mb-2">Tu Mensaje</label>
                    <i data-lucide="message-square" class="absolute left-3 top-11 w-5 h-5 text-gray-400"></i>
                    <textarea id="message" name="message" rows="5" required placeholder="Cuéntanos un poco sobre tu proyecto..." class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-highlight transition"></textarea>
                </div>
                
                <div id="form-response" class="text-center font-bold py-2"></div>

                <div>
                    <button type="submit" id="submit-button" class="w-full bg-brand-highlight text-brand-dark-text font-black text-lg uppercase py-4 rounded-lg hover:bg-yellow-500 transition-all shadow-lg focus:outline-none focus:ring-4 focus:ring-yellow-300">
                        Solicitar mi Cotización
                    </button>
                </div>
            </form>
        </div>
    </main>
    

    <button id="back-to-top" title="Volver Arriba">
        <i data-lucide="arrow-up" class="text-xl"></i>
    </button>
    
</body>
</html>